/*
 * Decompiled with CFR 0.152.
 */
package com.irisvalet.android.apps.mobilevalethelper.database;

import android.content.Context;
import android.database.Cursor;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.irisvalet.android.apps.mobilevalethelper.ContentManager;
import com.irisvalet.android.apps.mobilevalethelper.GuestManager;
import com.irisvalet.android.apps.mobilevalethelper.LanguagesManager;
import com.irisvalet.android.apps.mobilevalethelper.PropertyManager;
import com.irisvalet.android.apps.mobilevalethelper.ShoppingCart;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.ConversationsResponseDetailsContent;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.ForecastResponseDetailsForecastContent;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.GuestProfileResponseDetailsProfileContent;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.HomePageResponseDetailsHomepageContent;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.HotelCMSSettingsContent;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.HotelCartSettingsContent;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.HotelLanguagesSettingsContent;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.HotelPropertySettingsContent;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.OrderHistoryResponseDetailsGetOrdersContent;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.OutletDeliveryLocationsResponseDetailsLocationsContent;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.OutletsResponseDetailsOutletsContent;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.RegisterAssetResponseDetailsAssetContent;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.SectionsResponseDetailsSectionsContent;
import com.irisvalet.android.apps.mobilevalethelper.database.contentproviders.DataContentProvider;
import com.irisvalet.android.apps.mobilevalethelper.database.tables.DataContentTable;
import com.irisvalet.android.apps.mobilevalethelper.object.BaseObject;
import com.irisvalet.android.apps.mobilevalethelper.object.CategoryItem;
import com.irisvalet.android.apps.mobilevalethelper.object.Conversation;
import com.irisvalet.android.apps.mobilevalethelper.object.DeliveryLocation;
import com.irisvalet.android.apps.mobilevalethelper.object.DeliveryLocationArea;
import com.irisvalet.android.apps.mobilevalethelper.object.Language;
import com.irisvalet.android.apps.mobilevalethelper.object.NonVerifiedGuestField;
import com.irisvalet.android.apps.mobilevalethelper.object.OrderHistoryItem;
import com.irisvalet.android.apps.mobilevalethelper.object.Outlet;
import com.irisvalet.android.apps.mobilevalethelper.object.OutletSettings;
import com.irisvalet.android.apps.mobilevalethelper.object.Section;
import com.irisvalet.android.apps.mobilevalethelper.object.User;
import com.irisvalet.android.apps.mobilevalethelper.utils.CategoryItemsComparator;
import com.irisvalet.android.apps.mobilevalethelper.utils.DebugLog;
import com.irisvalet.android.apps.mobilevalethelper.utils.SectionsComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DataCacheHelper {
    private String TAG = "DataCacheHelper";
    private Context mAppContext;

    public DataCacheHelper(Context context) {
        this.mAppContext = context;
    }

    public void deleteContentForOldVersion(int version) {
        DebugLog.d(this.TAG, "deleteContentForVersion");
        DataContentProvider provider = new DataContentProvider(this.mAppContext);
        String selection = "type = '" + DataType.STATIC_CONTENT.toString() + "' AND " + "version" + " <> '" + Integer.toString(version) + "' AND " + "propertyCode" + " = '" + ContentManager.getPropertyCode() + "'";
        this.mAppContext.getContentResolver().delete(provider.CONTENT_URI, selection, null);
        selection = "type = '" + DataType.CONTENT_HOMEPAGE.toString() + "' AND " + "version" + " <> '" + Integer.toString(version) + "' AND " + "propertyCode" + " = '" + ContentManager.getPropertyCode() + "'";
        this.mAppContext.getContentResolver().delete(provider.CONTENT_URI, selection, null);
        selection = "type = '" + DataType.CONTENT_SECTIONS_ITEMS.toString() + "' AND " + "version" + " <> '" + Integer.toString(version) + "' AND " + "propertyCode" + " = '" + ContentManager.getPropertyCode() + "'";
        this.mAppContext.getContentResolver().delete(provider.CONTENT_URI, selection, null);
        selection = "type = '" + DataType.CONTENT_OUTLETS.toString() + "' AND " + "version" + " <> '" + Integer.toString(version) + "' AND " + "propertyCode" + " = '" + ContentManager.getPropertyCode() + "'";
        this.mAppContext.getContentResolver().delete(provider.CONTENT_URI, selection, null);
        selection = "type = '" + DataType.CONTENT_OUTLET_SETTINGS.toString() + "' AND " + "version" + " <> '" + Integer.toString(version) + "' AND " + "propertyCode" + " = '" + ContentManager.getPropertyCode() + "'";
        this.mAppContext.getContentResolver().delete(provider.CONTENT_URI, selection, null);
        selection = "type = '" + DataType.CONTENT_DELIVERY_AREAS.toString() + "' AND " + "version" + " <> '" + Integer.toString(version) + "' AND " + "propertyCode" + " = '" + ContentManager.getPropertyCode() + "'";
        this.mAppContext.getContentResolver().delete(provider.CONTENT_URI, selection, null);
        selection = "type = '" + DataType.CONTENT_HOMEPAGE_BY_GUEST.toString() + "' AND " + "version" + " <> '" + Integer.toString(version) + "' AND " + "propertyCode" + " = '" + ContentManager.getPropertyCode() + "'";
        this.mAppContext.getContentResolver().delete(provider.CONTENT_URI, selection, null);
        selection = "type = '" + DataType.CONTENT_SECTIONS_ITEMS_BY_GUEST.toString() + "' AND " + "version" + " <> '" + Integer.toString(version) + "' AND " + "propertyCode" + " = '" + ContentManager.getPropertyCode() + "'";
        this.mAppContext.getContentResolver().delete(provider.CONTENT_URI, selection, null);
    }

    public void insertStaticContent(String propertyCode, String langCode, int version, JsonObject content) {
        DebugLog.d(this.TAG, "insertStaticContent");
        DataContentProvider provider = new DataContentProvider(this.mAppContext);
        String selection = "type = '" + DataType.STATIC_CONTENT.toString() + "' AND " + "langCode" + " = '" + langCode + "' AND " + "version" + " = '" + Integer.toString(version) + "' AND " + "propertyCode" + " = '" + propertyCode + "'";
        this.mAppContext.getContentResolver().delete(provider.CONTENT_URI, selection, null);
        this.mAppContext.getContentResolver().insert(provider.CONTENT_URI, DataContentTable.getContentValues(propertyCode, langCode, version, DataType.STATIC_CONTENT.toString(), null, content.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonObject getStaticContent(String propertyCode, String langCode) {
        if (this.mAppContext != null) {
            Cursor cursor = null;
            try {
                String data;
                DataContentProvider provider = new DataContentProvider(this.mAppContext);
                String selection = "type = '" + DataType.STATIC_CONTENT.toString() + "' AND " + "langCode" + " = '" + langCode + "' AND " + "version" + " = '" + ContentManager.getContentVersionNumber() + "' AND " + "propertyCode" + " = '" + propertyCode + "'";
                cursor = this.mAppContext.getContentResolver().query(provider.CONTENT_URI, DataContentTable.projection, selection, null, null);
                if (cursor != null && !TextUtils.isEmpty((CharSequence)(data = DataContentTable.getDataFromCursor(cursor)))) {
                    Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm").create();
                    JsonObject jsonObject = (JsonObject)gson.fromJson(data, JsonObject.class);
                    return jsonObject;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (cursor != null && !cursor.isClosed()) {
                        cursor.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return null;
    }

    public void clearGuestData() {
        this.deleteGuestProfile();
        this.deleteGuestDetailsProfile();
        this.deleteMessages();
        this.deleteGuestOrderHistory();
        this.deleteGuestSections();
        this.deleteGuestHomepage();
    }

    private void deleteGuestProfile() {
        DataContentProvider provider = new DataContentProvider(this.mAppContext);
        String selection = "type = '" + DataType.GUEST_PROFILE.toString() + "'";
        this.mAppContext.getContentResolver().delete(provider.CONTENT_URI, selection, null);
    }

    private void deleteGuestDetailsProfile() {
        DataContentProvider provider = new DataContentProvider(this.mAppContext);
        String selection = "type = '" + DataType.USER_DETAILS.toString() + "'";
        this.mAppContext.getContentResolver().delete(provider.CONTENT_URI, selection, null);
    }

    private void deleteGuestSections() {
        DataContentProvider provider = new DataContentProvider(this.mAppContext);
        String selection = "type = '" + DataType.CONTENT_SECTIONS_ITEMS_BY_GUEST.toString() + "'";
        this.mAppContext.getContentResolver().delete(provider.CONTENT_URI, selection, null);
    }

    private void deleteGuestHomepage() {
        DataContentProvider provider = new DataContentProvider(this.mAppContext);
        String selection = "type = '" + DataType.CONTENT_HOMEPAGE_BY_GUEST.toString() + "'";
        this.mAppContext.getContentResolver().delete(provider.CONTENT_URI, selection, null);
    }

    private void deleteAllCarts() {
        DataContentProvider provider = new DataContentProvider(this.mAppContext);
        String selection = "type = '" + DataType.SHOPPING_CART.toString() + "'";
        this.mAppContext.getContentResolver().delete(provider.CONTENT_URI, selection, null);
    }

    private void deleteMessages() {
        DataContentProvider provider = new DataContentProvider(this.mAppContext);
        String selection = "type = '" + DataType.GUEST_CONVERSATIONS.toString() + "'";
        this.mAppContext.getContentResolver().delete(provider.CONTENT_URI, selection, null);
    }

    private void deleteGuestOrderHistory() {
        DataContentProvider provider = new DataContentProvider(this.mAppContext);
        String selection = "type = '" + DataType.GUEST_ORDER_HISTORY.toString() + "'";
        this.mAppContext.getContentResolver().delete(provider.CONTENT_URI, selection, null);
    }

    public boolean isUserExists() {
        return this.getUser() != null;
    }

    public void insertGuestProfile(GuestProfileResponseDetailsProfileContent content) {
        DataContentProvider provider = new DataContentProvider(this.mAppContext);
        String selection = "type = '" + DataType.GUEST_PROFILE.toString() + "'";
        this.mAppContext.getContentResolver().delete(provider.CONTENT_URI, selection, null);
        this.mAppContext.getContentResolver().insert(provider.CONTENT_URI, DataContentTable.getContentValues(ContentManager.getPropertyCode(), LanguagesManager.getSelectedLanguageCode(), ContentManager.getContentVersionNumber(), DataType.GUEST_PROFILE.toString(), null, content.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GuestProfileResponseDetailsProfileContent getGuestProfile() {
        if (this.mAppContext != null) {
            Cursor cursor = null;
            try {
                String data;
                DataContentProvider provider = new DataContentProvider(this.mAppContext);
                String selection = "type = '" + DataType.GUEST_PROFILE.toString() + "'";
                cursor = this.mAppContext.getContentResolver().query(provider.CONTENT_URI, DataContentTable.projection, selection, null, null);
                if (cursor != null && !TextUtils.isEmpty((CharSequence)(data = DataContentTable.getDataFromCursor(cursor)))) {
                    Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm").create();
                    GuestProfileResponseDetailsProfileContent guestProfileResponseDetailsProfileContent = (GuestProfileResponseDetailsProfileContent)gson.fromJson(data, GuestProfileResponseDetailsProfileContent.class);
                    return guestProfileResponseDetailsProfileContent;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (cursor != null && !cursor.isClosed()) {
                        cursor.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return null;
    }

    public void saveUser(User content) {
        DataContentProvider provider = new DataContentProvider(this.mAppContext);
        String selection = "type = '" + DataType.USER_DETAILS.toString() + "'";
        this.mAppContext.getContentResolver().delete(provider.CONTENT_URI, selection, null);
        this.mAppContext.getContentResolver().insert(provider.CONTENT_URI, DataContentTable.getContentValues(ContentManager.getPropertyCode(), LanguagesManager.getSelectedLanguageCode(), ContentManager.getContentVersionNumber(), DataType.USER_DETAILS.toString(), null, content.toString()));
    }

    public void deleteUser() {
        DataContentProvider provider = new DataContentProvider(this.mAppContext);
        String selection = "type = '" + DataType.USER_DETAILS.toString() + "'";
        this.mAppContext.getContentResolver().delete(provider.CONTENT_URI, selection, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUser() {
        if (this.mAppContext != null) {
            Cursor cursor = null;
            try {
                String data;
                DataContentProvider provider = new DataContentProvider(this.mAppContext);
                String selection = "type = '" + DataType.USER_DETAILS.toString() + "'";
                cursor = this.mAppContext.getContentResolver().query(provider.CONTENT_URI, DataContentTable.projection, selection, null, null);
                if (cursor != null && !TextUtils.isEmpty((CharSequence)(data = DataContentTable.getDataFromCursor(cursor)))) {
                    Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm").create();
                    GuestManager.setUser((User)gson.fromJson(data, User.class));
                    User user = GuestManager.getUser();
                    return user;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (cursor != null && !cursor.isClosed()) {
                        cursor.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return null;
    }

    public void insertForecast(ForecastResponseDetailsForecastContent content) {
        DebugLog.d(this.TAG, "insertForecast");
        DataContentProvider provider = new DataContentProvider(this.mAppContext);
        String selection = "type = '" + DataType.FORECAST_DATA.toString() + "' AND " + "propertyCode" + " = '" + ContentManager.getPropertyCode() + "'";
        this.mAppContext.getContentResolver().delete(provider.CONTENT_URI, selection, null);
        this.mAppContext.getContentResolver().insert(provider.CONTENT_URI, DataContentTable.getContentValues(ContentManager.getPropertyCode(), LanguagesManager.getSelectedLanguageCode(), ContentManager.getContentVersionNumber(), DataType.FORECAST_DATA.toString(), null, content.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForecastResponseDetailsForecastContent getForecast() {
        if (this.mAppContext != null) {
            Cursor cursor = null;
            try {
                String data;
                DataContentProvider provider = new DataContentProvider(this.mAppContext);
                String selection = "type = '" + DataType.FORECAST_DATA.toString() + "' AND " + "propertyCode" + " = '" + ContentManager.getPropertyCode() + "'";
                cursor = this.mAppContext.getContentResolver().query(provider.CONTENT_URI, DataContentTable.projection, selection, null, null);
                if (cursor != null && !TextUtils.isEmpty((CharSequence)(data = DataContentTable.getDataFromCursor(cursor)))) {
                    Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm").create();
                    ForecastResponseDetailsForecastContent forecastResponseDetailsForecastContent = (ForecastResponseDetailsForecastContent)gson.fromJson(data, ForecastResponseDetailsForecastContent.class);
                    return forecastResponseDetailsForecastContent;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (cursor != null && !cursor.isClosed()) {
                        cursor.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return null;
    }

    public void insertCartSettings(String propertyCode, int version, HotelCartSettingsContent settings) {
        DataContentProvider provider = new DataContentProvider(this.mAppContext);
        String selection = "type = '" + DataType.CART_SETTINGS.toString() + "' AND " + "propertyCode" + " = '" + ContentManager.getPropertyCode() + "'";
        this.mAppContext.getContentResolver().delete(provider.CONTENT_URI, selection, null);
        this.mAppContext.getContentResolver().insert(provider.CONTENT_URI, DataContentTable.getContentValues(propertyCode, null, version, DataType.CART_SETTINGS.toString(), null, settings.toString()));
    }

    public void insertCMSSettings(String propertyCode, int version, HotelCMSSettingsContent settings) {
        DataContentProvider provider = new DataContentProvider(this.mAppContext);
        String selection = "type = '" + DataType.CMS_SETTINGS.toString() + "' AND " + "propertyCode" + " = '" + ContentManager.getPropertyCode() + "'";
        this.mAppContext.getContentResolver().delete(provider.CONTENT_URI, selection, null);
        this.mAppContext.getContentResolver().insert(provider.CONTENT_URI, DataContentTable.getContentValues(propertyCode, null, version, DataType.CMS_SETTINGS.toString(), null, settings.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HotelCMSSettingsContent getCMSSettings() {
        if (PropertyManager.mHotelCMSSettings != null) {
            return PropertyManager.mHotelCMSSettings;
        }
        if (this.mAppContext != null) {
            Cursor cursor = null;
            try {
                String data;
                DataContentProvider provider = new DataContentProvider(this.mAppContext);
                String selection = "type = '" + DataType.CMS_SETTINGS.toString() + "' AND " + "propertyCode" + " = '" + ContentManager.getPropertyCode() + "'";
                cursor = this.mAppContext.getContentResolver().query(provider.CONTENT_URI, DataContentTable.projection, selection, null, null);
                if (cursor != null && !TextUtils.isEmpty((CharSequence)(data = DataContentTable.getDataFromCursor(cursor)))) {
                    Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm").create();
                    HotelCMSSettingsContent hotelCMSSettingsContent = PropertyManager.mHotelCMSSettings = (HotelCMSSettingsContent)gson.fromJson(data, HotelCMSSettingsContent.class);
                    return hotelCMSSettingsContent;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (cursor != null && !cursor.isClosed()) {
                        cursor.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return null;
    }

    public void insertPropertySettings(String propertyCode, int version, HotelPropertySettingsContent settings) {
        DataContentProvider provider = new DataContentProvider(this.mAppContext);
        String selection = "type = '" + DataType.PROPERTY_SETTINGS.toString() + "' AND " + "propertyCode" + " = '" + ContentManager.getPropertyCode() + "'";
        this.mAppContext.getContentResolver().delete(provider.CONTENT_URI, selection, null);
        this.mAppContext.getContentResolver().insert(provider.CONTENT_URI, DataContentTable.getContentValues(propertyCode, null, version, DataType.PROPERTY_SETTINGS.toString(), null, settings.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HotelPropertySettingsContent getPropertySettings() {
        if (PropertyManager.mPropertySettings != null) {
            return PropertyManager.mPropertySettings;
        }
        if (this.mAppContext != null) {
            Cursor cursor = null;
            try {
                String data;
                DataContentProvider provider = new DataContentProvider(this.mAppContext);
                String selection = "type = '" + DataType.PROPERTY_SETTINGS.toString() + "' AND " + "propertyCode" + " = '" + ContentManager.getPropertyCode() + "'";
                cursor = this.mAppContext.getContentResolver().query(provider.CONTENT_URI, DataContentTable.projection, selection, null, null);
                if (cursor != null && !TextUtils.isEmpty((CharSequence)(data = DataContentTable.getDataFromCursor(cursor)))) {
                    Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm").create();
                    HotelPropertySettingsContent hotelPropertySettingsContent = PropertyManager.mPropertySettings = (HotelPropertySettingsContent)gson.fromJson(data, HotelPropertySettingsContent.class);
                    return hotelPropertySettingsContent;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (cursor != null && !cursor.isClosed()) {
                        cursor.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return null;
    }

    public void insertLanguages(String propertyCode, int versionNumber, HotelLanguagesSettingsContent settings) {
        DataContentProvider provider = new DataContentProvider(this.mAppContext);
        String selection = "type = '" + DataType.LANGUAGE_SETTINGS.toString() + "' AND " + "propertyCode" + " = '" + ContentManager.getPropertyCode() + "'";
        this.mAppContext.getContentResolver().delete(provider.CONTENT_URI, selection, null);
        this.mAppContext.getContentResolver().insert(provider.CONTENT_URI, DataContentTable.getContentValues(propertyCode, null, versionNumber, DataType.LANGUAGE_SETTINGS.toString(), null, settings.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Language> getLanguagesSettings() {
        if (this.mAppContext != null) {
            Cursor cursor = null;
            try {
                Gson gson;
                HotelLanguagesSettingsContent content;
                String data;
                DataContentProvider provider = new DataContentProvider(this.mAppContext);
                String selection = "type = '" + DataType.LANGUAGE_SETTINGS.toString() + "' AND " + "propertyCode" + " = '" + ContentManager.getPropertyCode() + "'";
                cursor = this.mAppContext.getContentResolver().query(provider.CONTENT_URI, DataContentTable.projection, selection, null, null);
                if (cursor != null && !TextUtils.isEmpty((CharSequence)(data = DataContentTable.getDataFromCursor(cursor))) && (content = (HotelLanguagesSettingsContent)(gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm").create()).fromJson(data, HotelLanguagesSettingsContent.class)) != null) {
                    ArrayList<Language> arrayList = content.languages;
                    return arrayList;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (cursor != null && !cursor.isClosed()) {
                        cursor.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return null;
    }

    public void insertHomePageContent(String propertyCode, String langCode, int version, HomePageResponseDetailsHomepageContent content) {
        DebugLog.d(this.TAG, "insertHomePageContent");
        DataContentProvider provider = new DataContentProvider(this.mAppContext);
        String selection = "type = '" + DataType.CONTENT_HOMEPAGE.toString() + "' AND " + "langCode" + " = '" + langCode + "' AND " + "version" + " = '" + Integer.toString(version) + "' AND " + "propertyCode" + " = '" + propertyCode + "'";
        this.mAppContext.getContentResolver().delete(provider.CONTENT_URI, selection, null);
        this.mAppContext.getContentResolver().insert(provider.CONTENT_URI, DataContentTable.getContentValues(propertyCode, langCode, version, DataType.CONTENT_HOMEPAGE.toString(), null, content.toString()));
    }

    public void insertHomePageContentByGuest(String propertyCode, String langCode, int version, HomePageResponseDetailsHomepageContent content) {
        DebugLog.d(this.TAG, "insertHomePageContentByGuest");
        DataContentProvider provider = new DataContentProvider(this.mAppContext);
        String selection = "type = '" + DataType.CONTENT_HOMEPAGE_BY_GUEST.toString() + "' AND " + "langCode" + " = '" + langCode + "' AND " + "version" + " = '" + Integer.toString(version) + "' AND " + "propertyCode" + " = '" + propertyCode + "'";
        this.mAppContext.getContentResolver().delete(provider.CONTENT_URI, selection, null);
        this.mAppContext.getContentResolver().insert(provider.CONTENT_URI, DataContentTable.getContentValues(propertyCode, langCode, version, DataType.CONTENT_HOMEPAGE_BY_GUEST.toString(), null, content.toString()));
    }

    public HomePageResponseDetailsHomepageContent getHomePageContent() {
        return this.getHomePageContent(LanguagesManager.getSelectedLanguageCode());
    }

    public HomePageResponseDetailsHomepageContent getHomePageContentByGuest() {
        return this.getHomePageContentByGuest(LanguagesManager.getSelectedLanguageCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HomePageResponseDetailsHomepageContent getHomePageContent(String languageCode) {
        if (this.mAppContext != null) {
            Cursor cursor = null;
            try {
                String data;
                String versionNumber = "0";
                try {
                    versionNumber = Integer.toString(ContentManager.getContentVersionNumber());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String propertyCode = ContentManager.getPropertyCode();
                DebugLog.d(this.TAG, "getHomePageContent for propertyCode: " + propertyCode);
                DataContentProvider provider = new DataContentProvider(this.mAppContext);
                String selection = "type = '" + DataType.CONTENT_HOMEPAGE.toString() + "' AND " + "propertyCode" + " = '" + propertyCode + "'";
                if (languageCode != null) {
                    selection = selection + " AND langCode = '" + languageCode + "'";
                }
                if (!versionNumber.equals("0")) {
                    selection = selection + " AND version = '" + versionNumber + "'";
                }
                if ((cursor = this.mAppContext.getContentResolver().query(provider.CONTENT_URI, DataContentTable.projection, selection, null, null)) != null && !TextUtils.isEmpty((CharSequence)(data = DataContentTable.getDataFromCursor(cursor)))) {
                    Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm").create();
                    HomePageResponseDetailsHomepageContent homePageResponseDetailsHomepageContent = (HomePageResponseDetailsHomepageContent)gson.fromJson(data, HomePageResponseDetailsHomepageContent.class);
                    return homePageResponseDetailsHomepageContent;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (cursor != null && !cursor.isClosed()) {
                        cursor.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HomePageResponseDetailsHomepageContent getHomePageContentByGuest(String languageCode) {
        if (this.mAppContext != null) {
            Cursor cursor = null;
            try {
                String data;
                String versionNumber = "0";
                try {
                    versionNumber = Integer.toString(ContentManager.getContentVersionNumber());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String propertyCode = ContentManager.getPropertyCode();
                DebugLog.d(this.TAG, "getHomePageContent for propertyCode: " + propertyCode);
                DataContentProvider provider = new DataContentProvider(this.mAppContext);
                String selection = "type = '" + DataType.CONTENT_HOMEPAGE_BY_GUEST.toString() + "' AND " + "propertyCode" + " = '" + propertyCode + "'";
                if (languageCode != null) {
                    selection = selection + " AND langCode = '" + languageCode + "'";
                }
                if (!versionNumber.equals("0")) {
                    selection = selection + " AND version = '" + versionNumber + "'";
                }
                if ((cursor = this.mAppContext.getContentResolver().query(provider.CONTENT_URI, DataContentTable.projection, selection, null, null)) != null && !TextUtils.isEmpty((CharSequence)(data = DataContentTable.getDataFromCursor(cursor)))) {
                    Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm").create();
                    HomePageResponseDetailsHomepageContent homePageResponseDetailsHomepageContent = (HomePageResponseDetailsHomepageContent)gson.fromJson(data, HomePageResponseDetailsHomepageContent.class);
                    return homePageResponseDetailsHomepageContent;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (cursor != null && !cursor.isClosed()) {
                        cursor.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return null;
    }

    public void insertSectionsCategoryItems(String propertyCode, String langCode, int version, String outletCode, SectionsResponseDetailsSectionsContent content, int guestId) {
        if (TextUtils.isEmpty((CharSequence)outletCode)) {
            outletCode = "0";
        }
        DataContentProvider provider = new DataContentProvider(this.mAppContext);
        String selection = guestId == 0 ? "type = '" + DataType.CONTENT_SECTIONS_ITEMS.toString() + "' AND " + "langCode" + " = '" + langCode + "' AND " + "version" + " = '" + Integer.toString(version) + "' AND " + "propertyCode" + " = '" + propertyCode + "' AND " + "params" + " = '" + outletCode + "'" : "type = '" + DataType.CONTENT_SECTIONS_ITEMS_BY_GUEST.toString() + "' AND " + "langCode" + " = '" + langCode + "' AND " + "version" + " = '" + Integer.toString(version) + "' AND " + "propertyCode" + " = '" + propertyCode + "' AND " + "params" + " = '" + outletCode + "'";
        DebugLog.d(this.TAG, "insertSectionsCategoryItems: " + selection);
        this.mAppContext.getContentResolver().delete(provider.CONTENT_URI, selection, null);
        if (guestId == 0) {
            this.mAppContext.getContentResolver().insert(provider.CONTENT_URI, DataContentTable.getContentValues(propertyCode, langCode, version, DataType.CONTENT_SECTIONS_ITEMS.toString(), outletCode, content.toString()));
        } else {
            this.mAppContext.getContentResolver().insert(provider.CONTENT_URI, DataContentTable.getContentValues(propertyCode, langCode, version, DataType.CONTENT_SECTIONS_ITEMS_BY_GUEST.toString(), outletCode, content.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<CategoryItem> getCategoryItems(String outletCode, String categoryCode) {
        if (this.mAppContext != null) {
            Cursor cursor = null;
            try {
                Gson gson;
                SectionsResponseDetailsSectionsContent content;
                String data;
                if (TextUtils.isEmpty((CharSequence)outletCode)) {
                    outletCode = "0";
                }
                String versionNumber = "0";
                try {
                    versionNumber = Integer.toString(ContentManager.getContentVersionNumber());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                DataContentProvider provider = new DataContentProvider(this.mAppContext);
                String selection = "type = '" + DataType.CONTENT_SECTIONS_ITEMS.toString() + "' AND " + "langCode" + " = '" + LanguagesManager.getSelectedLanguageCode() + "' AND " + "version" + " = '" + versionNumber + "' AND " + "propertyCode" + " = '" + ContentManager.getPropertyCode() + "' AND " + "params" + " = '" + outletCode + "'";
                DebugLog.d(this.TAG, "getCategoryItems: " + selection);
                cursor = this.mAppContext.getContentResolver().query(provider.CONTENT_URI, DataContentTable.projection, selection, null, null);
                if (cursor != null && !TextUtils.isEmpty((CharSequence)(data = DataContentTable.getDataFromCursor(cursor))) && (content = (SectionsResponseDetailsSectionsContent)(gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm").create()).fromJson(data, SectionsResponseDetailsSectionsContent.class)) != null && content.categoryItems != null) {
                    ArrayList<CategoryItem> filteredItems = new ArrayList<CategoryItem>();
                    for (CategoryItem item : content.categoryItems) {
                        if (!item.categoryCode.equalsIgnoreCase(categoryCode)) continue;
                        filteredItems.add(item);
                    }
                    ArrayList<CategoryItem> arrayList = filteredItems;
                    return arrayList;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (cursor != null && !cursor.isClosed()) {
                        cursor.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<CategoryItem> getCategoryItemsByGuest(String outletCode, String categoryCode) {
        if (this.mAppContext != null) {
            Cursor cursor = null;
            try {
                Gson gson;
                SectionsResponseDetailsSectionsContent content;
                String data;
                if (TextUtils.isEmpty((CharSequence)outletCode)) {
                    outletCode = "0";
                }
                String versionNumber = "0";
                try {
                    versionNumber = Integer.toString(ContentManager.getContentVersionNumber());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                DataContentProvider provider = new DataContentProvider(this.mAppContext);
                String selection = "type = '" + DataType.CONTENT_SECTIONS_ITEMS_BY_GUEST.toString() + "' AND " + "langCode" + " = '" + LanguagesManager.getSelectedLanguageCode() + "' AND " + "version" + " = '" + versionNumber + "' AND " + "propertyCode" + " = '" + ContentManager.getPropertyCode() + "' AND " + "params" + " = '" + outletCode + "'";
                DebugLog.d(this.TAG, "getCategoryItems: " + selection);
                cursor = this.mAppContext.getContentResolver().query(provider.CONTENT_URI, DataContentTable.projection, selection, null, null);
                if (cursor != null && !TextUtils.isEmpty((CharSequence)(data = DataContentTable.getDataFromCursor(cursor))) && (content = (SectionsResponseDetailsSectionsContent)(gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm").create()).fromJson(data, SectionsResponseDetailsSectionsContent.class)) != null && content.categoryItems != null) {
                    ArrayList<CategoryItem> filteredItems = new ArrayList<CategoryItem>();
                    for (CategoryItem item : content.categoryItems) {
                        if (!item.categoryCode.equalsIgnoreCase(categoryCode)) continue;
                        filteredItems.add(item);
                    }
                    ArrayList<CategoryItem> arrayList = filteredItems;
                    return arrayList;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (cursor != null && !cursor.isClosed()) {
                        cursor.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Section> getAllSections() {
        if (this.mAppContext != null) {
            Cursor cursor = null;
            try {
                String versionNumber = "0";
                try {
                    versionNumber = Integer.toString(ContentManager.getContentVersionNumber());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                DataContentProvider provider = new DataContentProvider(this.mAppContext);
                String selection = "type = '" + DataType.CONTENT_SECTIONS_ITEMS.toString() + "' AND " + "langCode" + " = '" + LanguagesManager.getSelectedLanguageCode() + "' AND " + "version" + " = '" + versionNumber + "' AND " + "propertyCode" + " = '" + ContentManager.getPropertyCode() + "'";
                DebugLog.d(this.TAG, "getOutletSections: " + selection);
                cursor = this.mAppContext.getContentResolver().query(provider.CONTENT_URI, DataContentTable.projection, selection, null, null);
                if (cursor != null) {
                    Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm").create();
                    ArrayList<Section> results = new ArrayList<Section>();
                    while (cursor.moveToNext()) {
                        SectionsResponseDetailsSectionsContent content;
                        String data = DataContentTable.getData(cursor);
                        if (TextUtils.isEmpty((CharSequence)data) || (content = (SectionsResponseDetailsSectionsContent)gson.fromJson(data, SectionsResponseDetailsSectionsContent.class)) == null || content.sections == null || content.sections.size() <= 0) continue;
                        results.addAll(content.sections);
                    }
                    if (results.size() > 0) {
                        Collections.sort(results, new SectionsComparator());
                        ArrayList<Section> arrayList = results;
                        return arrayList;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (cursor != null && !cursor.isClosed()) {
                        cursor.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Section> getAllSectionsByGuest() {
        if (this.mAppContext != null) {
            Cursor cursor = null;
            try {
                String versionNumber = "0";
                try {
                    versionNumber = Integer.toString(ContentManager.getContentVersionNumber());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                DataContentProvider provider = new DataContentProvider(this.mAppContext);
                String selection = "type = '" + DataType.CONTENT_SECTIONS_ITEMS_BY_GUEST.toString() + "' AND " + "langCode" + " = '" + LanguagesManager.getSelectedLanguageCode() + "' AND " + "version" + " = '" + versionNumber + "' AND " + "propertyCode" + " = '" + ContentManager.getPropertyCode() + "'";
                DebugLog.d(this.TAG, "getOutletSections: " + selection);
                cursor = this.mAppContext.getContentResolver().query(provider.CONTENT_URI, DataContentTable.projection, selection, null, null);
                if (cursor != null) {
                    Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm").create();
                    ArrayList<Section> results = new ArrayList<Section>();
                    while (cursor.moveToNext()) {
                        SectionsResponseDetailsSectionsContent content;
                        String data = DataContentTable.getData(cursor);
                        if (TextUtils.isEmpty((CharSequence)data) || (content = (SectionsResponseDetailsSectionsContent)gson.fromJson(data, SectionsResponseDetailsSectionsContent.class)) == null || content.sections == null || content.sections.size() <= 0) continue;
                        results.addAll(content.sections);
                    }
                    if (results.size() > 0) {
                        Collections.sort(results, new SectionsComparator());
                        ArrayList<Section> arrayList = results;
                        return arrayList;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (cursor != null && !cursor.isClosed()) {
                        cursor.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<CategoryItem> getAllCategoryItems() {
        if (this.mAppContext != null) {
            Cursor cursor = null;
            try {
                String versionNumber = "0";
                try {
                    versionNumber = Integer.toString(ContentManager.getContentVersionNumber());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                DataContentProvider provider = new DataContentProvider(this.mAppContext);
                String selection = "type = '" + DataType.CONTENT_SECTIONS_ITEMS.toString() + "' AND " + "langCode" + " = '" + LanguagesManager.getSelectedLanguageCode() + "' AND " + "version" + " = '" + versionNumber + "' AND " + "propertyCode" + " = '" + ContentManager.getPropertyCode() + "'";
                DebugLog.d(this.TAG, "getOutletSections: " + selection);
                cursor = this.mAppContext.getContentResolver().query(provider.CONTENT_URI, DataContentTable.projection, selection, null, null);
                if (cursor != null) {
                    Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm").create();
                    ArrayList<CategoryItem> results = new ArrayList<CategoryItem>();
                    DebugLog.d(this.TAG, "cursor getCount: " + cursor.getCount());
                    while (cursor.moveToNext()) {
                        SectionsResponseDetailsSectionsContent content;
                        String data = DataContentTable.getData(cursor);
                        if (TextUtils.isEmpty((CharSequence)data) || (content = (SectionsResponseDetailsSectionsContent)gson.fromJson(data, SectionsResponseDetailsSectionsContent.class)) == null || content.categoryItems == null || content.categoryItems.size() <= 0) continue;
                        results.addAll(content.categoryItems);
                    }
                    if (results.size() > 0) {
                        Collections.sort(results, new CategoryItemsComparator());
                        ArrayList<CategoryItem> arrayList = results;
                        return arrayList;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (cursor != null && !cursor.isClosed()) {
                        cursor.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<CategoryItem> getAllCategoryItemsByGuest() {
        if (this.mAppContext != null) {
            Cursor cursor = null;
            try {
                String versionNumber = "0";
                try {
                    versionNumber = Integer.toString(ContentManager.getContentVersionNumber());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                DataContentProvider provider = new DataContentProvider(this.mAppContext);
                String selection = "type = '" + DataType.CONTENT_SECTIONS_ITEMS_BY_GUEST.toString() + "' AND " + "langCode" + " = '" + LanguagesManager.getSelectedLanguageCode() + "' AND " + "version" + " = '" + versionNumber + "' AND " + "propertyCode" + " = '" + ContentManager.getPropertyCode() + "'";
                DebugLog.d(this.TAG, "getOutletSections: " + selection);
                cursor = this.mAppContext.getContentResolver().query(provider.CONTENT_URI, DataContentTable.projection, selection, null, null);
                if (cursor != null) {
                    Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm").create();
                    ArrayList<CategoryItem> results = new ArrayList<CategoryItem>();
                    DebugLog.d(this.TAG, "cursor getCount: " + cursor.getCount());
                    while (cursor.moveToNext()) {
                        SectionsResponseDetailsSectionsContent content;
                        String data = DataContentTable.getData(cursor);
                        if (TextUtils.isEmpty((CharSequence)data) || (content = (SectionsResponseDetailsSectionsContent)gson.fromJson(data, SectionsResponseDetailsSectionsContent.class)) == null || content.categoryItems == null || content.categoryItems.size() <= 0) continue;
                        results.addAll(content.categoryItems);
                    }
                    if (results.size() > 0) {
                        Collections.sort(results, new CategoryItemsComparator());
                        ArrayList<CategoryItem> arrayList = results;
                        return arrayList;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (cursor != null && !cursor.isClosed()) {
                        cursor.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return null;
    }

    public ArrayList<Section> getOutletSections(String outletCode) {
        return this.getOutletSections(outletCode, LanguagesManager.getSelectedLanguageCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Section> getOutletSections(String outletCode, String langCode) {
        if (this.mAppContext != null) {
            Cursor cursor = null;
            try {
                Gson gson;
                SectionsResponseDetailsSectionsContent content;
                String data;
                if (TextUtils.isEmpty((CharSequence)outletCode)) {
                    outletCode = "0";
                }
                String versionNumber = "0";
                try {
                    versionNumber = Integer.toString(ContentManager.getContentVersionNumber());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                DataContentProvider provider = new DataContentProvider(this.mAppContext);
                String selection = "type = '" + DataType.CONTENT_SECTIONS_ITEMS.toString() + "' AND " + "langCode" + " = '" + langCode + "' AND " + "version" + " = '" + versionNumber + "' AND " + "propertyCode" + " = '" + ContentManager.getPropertyCode() + "' AND " + "params" + " = '" + outletCode + "'";
                DebugLog.d(this.TAG, "getOutletSections: " + selection);
                cursor = this.mAppContext.getContentResolver().query(provider.CONTENT_URI, DataContentTable.projection, selection, null, null);
                if (cursor != null && !TextUtils.isEmpty((CharSequence)(data = DataContentTable.getDataFromCursor(cursor))) && (content = (SectionsResponseDetailsSectionsContent)(gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm").create()).fromJson(data, SectionsResponseDetailsSectionsContent.class)) != null) {
                    ArrayList<Section> arrayList = content.sections;
                    return arrayList;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (cursor != null && !cursor.isClosed()) {
                        cursor.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Section> getGuestSections(String langCode) {
        if (this.mAppContext != null) {
            Cursor cursor = null;
            try {
                Gson gson;
                SectionsResponseDetailsSectionsContent content;
                String data;
                String versionNumber = "0";
                try {
                    versionNumber = Integer.toString(ContentManager.getContentVersionNumber());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                DataContentProvider provider = new DataContentProvider(this.mAppContext);
                String selection = "type = '" + DataType.CONTENT_SECTIONS_ITEMS_BY_GUEST.toString() + "' AND " + "langCode" + " = '" + langCode + "' AND " + "version" + " = '" + versionNumber + "' AND " + "propertyCode" + " = '" + ContentManager.getPropertyCode() + "'";
                DebugLog.d(this.TAG, "getGuestSections: " + selection);
                cursor = this.mAppContext.getContentResolver().query(provider.CONTENT_URI, DataContentTable.projection, selection, null, null);
                if (cursor != null && !TextUtils.isEmpty((CharSequence)(data = DataContentTable.getDataFromCursor(cursor))) && (content = (SectionsResponseDetailsSectionsContent)(gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm").create()).fromJson(data, SectionsResponseDetailsSectionsContent.class)) != null) {
                    ArrayList<Section> arrayList = content.sections;
                    return arrayList;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (cursor != null && !cursor.isClosed()) {
                        cursor.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return null;
    }

    public void insertOutlets(String propertyCode, String langCode, int version, OutletsResponseDetailsOutletsContent content) {
        DataContentProvider provider = new DataContentProvider(this.mAppContext);
        String selection = "type = '" + DataType.CONTENT_OUTLETS.toString() + "' AND " + "langCode" + " = '" + langCode + "' AND " + "version" + " = '" + Integer.toString(version) + "' AND " + "propertyCode" + " = '" + propertyCode + "'";
        this.mAppContext.getContentResolver().delete(provider.CONTENT_URI, selection, null);
        this.mAppContext.getContentResolver().insert(provider.CONTENT_URI, DataContentTable.getContentValues(propertyCode, langCode, version, DataType.CONTENT_OUTLETS.toString(), null, content.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Outlet> getOutlets() {
        if (this.mAppContext != null) {
            Cursor cursor = null;
            try {
                Gson gson;
                OutletsResponseDetailsOutletsContent content;
                String data;
                String versionNumber = "0";
                try {
                    versionNumber = Integer.toString(ContentManager.getContentVersionNumber());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                DataContentProvider provider = new DataContentProvider(this.mAppContext);
                String selection = "type = '" + DataType.CONTENT_OUTLETS.toString() + "' AND " + "langCode" + " = '" + LanguagesManager.getSelectedLanguageCode() + "' AND " + "version" + " = '" + versionNumber + "' AND " + "propertyCode" + " = '" + ContentManager.getPropertyCode() + "'";
                cursor = this.mAppContext.getContentResolver().query(provider.CONTENT_URI, DataContentTable.projection, selection, null, null);
                if (cursor != null && !TextUtils.isEmpty((CharSequence)(data = DataContentTable.getDataFromCursor(cursor))) && (content = (OutletsResponseDetailsOutletsContent)(gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm").create()).fromJson(data, OutletsResponseDetailsOutletsContent.class)) != null && content.outlets.size() > 0) {
                    for (Outlet o : content.outlets) {
                        o.outletSettings = this.getOutletSettings(o.code);
                    }
                    ArrayList<Outlet> arrayList = content.outlets;
                    return arrayList;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (cursor != null && !cursor.isClosed()) {
                        cursor.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return null;
    }

    public void insertOutletSettings(String propertyCode, int version, String outletCode, OutletSettings settings) {
        DataContentProvider provider = new DataContentProvider(this.mAppContext);
        String selection = "type = '" + DataType.CONTENT_OUTLET_SETTINGS.toString() + "' AND " + "version" + " = '" + Integer.toString(version) + "' AND " + "propertyCode" + " = '" + propertyCode + "' AND " + "params" + " = '" + outletCode + "'";
        this.mAppContext.getContentResolver().delete(provider.CONTENT_URI, selection, null);
        this.mAppContext.getContentResolver().insert(provider.CONTENT_URI, DataContentTable.getContentValues(propertyCode, null, version, DataType.CONTENT_OUTLET_SETTINGS.toString(), outletCode, settings.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutletSettings getOutletSettings(String outletCode) {
        if (this.mAppContext != null) {
            Cursor cursor = null;
            try {
                String data;
                String versionNumber = "0";
                try {
                    versionNumber = Integer.toString(ContentManager.getContentVersionNumber());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                DataContentProvider provider = new DataContentProvider(this.mAppContext);
                String selection = "type = '" + DataType.CONTENT_OUTLET_SETTINGS.toString() + "' AND " + "version" + " = '" + versionNumber + "' AND " + "propertyCode" + " = '" + ContentManager.getPropertyCode() + "' AND " + "params" + " = '" + outletCode + "'";
                cursor = this.mAppContext.getContentResolver().query(provider.CONTENT_URI, DataContentTable.projection, selection, null, null);
                if (cursor != null && !TextUtils.isEmpty((CharSequence)(data = DataContentTable.getDataFromCursor(cursor)))) {
                    Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm").create();
                    OutletSettings outletSettings = (OutletSettings)gson.fromJson(data, OutletSettings.class);
                    return outletSettings;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (cursor != null && !cursor.isClosed()) {
                        cursor.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return null;
    }

    public void insertDeliveryAreas(String propertyCode, String langCode, int version, String outletCode, OutletDeliveryLocationsResponseDetailsLocationsContent deliveryAreas) {
        if (deliveryAreas != null && deliveryAreas.deliveryLocationAreas != null && deliveryAreas.deliveryLocationAreas.size() > 0) {
            for (DeliveryLocationArea area : deliveryAreas.deliveryLocationAreas) {
                if (area == null || area.deliveryLocations == null || area.deliveryLocations.size() <= 0) continue;
                for (DeliveryLocation location : area.deliveryLocations) {
                    location.areaCode = area.code;
                }
            }
            DataContentProvider provider = new DataContentProvider(this.mAppContext);
            String selection = "type = '" + DataType.CONTENT_DELIVERY_AREAS.toString() + "' AND " + "langCode" + " = '" + langCode + "' AND " + "version" + " = '" + Integer.toString(version) + "' AND " + "propertyCode" + " = '" + propertyCode + "' AND " + "params" + " = '" + outletCode + "'";
            this.mAppContext.getContentResolver().delete(provider.CONTENT_URI, selection, null);
            this.mAppContext.getContentResolver().insert(provider.CONTENT_URI, DataContentTable.getContentValues(propertyCode, langCode, version, DataType.CONTENT_DELIVERY_AREAS.toString(), outletCode, deliveryAreas.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<DeliveryLocationArea> getOutletDeliveryAreas(String outletCode) {
        if (this.mAppContext != null) {
            Cursor cursor = null;
            try {
                Gson gson;
                OutletDeliveryLocationsResponseDetailsLocationsContent content;
                String data;
                String versionNumber = "0";
                try {
                    versionNumber = Integer.toString(ContentManager.getContentVersionNumber());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                DataContentProvider provider = new DataContentProvider(this.mAppContext);
                String selection = "type = '" + DataType.CONTENT_DELIVERY_AREAS.toString() + "' AND " + "langCode" + " = '" + LanguagesManager.getSelectedLanguageCode() + "' AND " + "version" + " = '" + versionNumber + "' AND " + "propertyCode" + " = '" + ContentManager.getPropertyCode() + "' AND " + "params" + " = '" + outletCode + "'";
                cursor = this.mAppContext.getContentResolver().query(provider.CONTENT_URI, DataContentTable.projection, selection, null, null);
                if (cursor != null && !TextUtils.isEmpty((CharSequence)(data = DataContentTable.getDataFromCursor(cursor))) && (content = (OutletDeliveryLocationsResponseDetailsLocationsContent)(gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm").create()).fromJson(data, OutletDeliveryLocationsResponseDetailsLocationsContent.class)) != null) {
                    ArrayList<DeliveryLocationArea> arrayList = content.deliveryLocationAreas;
                    return arrayList;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (cursor != null && !cursor.isClosed()) {
                        cursor.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return null;
    }

    public void clearCart(String outletCode) {
        DataContentProvider provider = new DataContentProvider(this.mAppContext);
        String selection = "type = '" + DataType.SHOPPING_CART.toString() + "'";
        if (outletCode != null) {
            selection = selection + " AND params = '" + outletCode + "'";
        }
        this.mAppContext.getContentResolver().delete(provider.CONTENT_URI, selection, null);
    }

    public void saveCart(String propertyCode, String langCode, int version, String outletCode, ShoppingCart content) {
        DataContentProvider provider = new DataContentProvider(this.mAppContext);
        String selection = "type = '" + DataType.SHOPPING_CART.toString() + "' AND " + "params" + " = '" + outletCode + "'";
        this.mAppContext.getContentResolver().delete(provider.CONTENT_URI, selection, null);
        if (content != null) {
            this.mAppContext.getContentResolver().insert(provider.CONTENT_URI, DataContentTable.getContentValues(propertyCode, langCode, version, DataType.SHOPPING_CART.toString(), outletCode, content.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ShoppingCart> getAllCarts() {
        if (this.mAppContext != null) {
            Cursor cursor = null;
            try {
                DataContentProvider provider = new DataContentProvider(this.mAppContext);
                String selection = "type = '" + DataType.SHOPPING_CART.toString() + "'";
                cursor = this.mAppContext.getContentResolver().query(provider.CONTENT_URI, DataContentTable.projection, selection, null, null);
                if (cursor != null) {
                    ArrayList<ShoppingCart> results = new ArrayList<ShoppingCart>();
                    while (cursor.moveToNext()) {
                        String data = DataContentTable.getData(cursor);
                        if (TextUtils.isEmpty((CharSequence)data)) continue;
                        Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm").create();
                        ShoppingCart cart = (ShoppingCart)gson.fromJson(data, ShoppingCart.class);
                        results.add(cart);
                    }
                    ArrayList<ShoppingCart> arrayList = results;
                    return arrayList;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (cursor != null && !cursor.isClosed()) {
                        cursor.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return null;
    }

    public void addAssetRegistration(RegisterAssetResponseDetailsAssetContent content) {
        DataContentProvider provider = new DataContentProvider(this.mAppContext);
        String selection = "type = '" + DataType.GV_ADD_ASSET_DETAILS.toString() + "'";
        this.mAppContext.getContentResolver().delete(provider.CONTENT_URI, selection, null);
        this.mAppContext.getContentResolver().insert(provider.CONTENT_URI, DataContentTable.getContentValues(ContentManager.getPropertyCode(), LanguagesManager.getSelectedLanguageCode(), ContentManager.getContentVersionNumber(), DataType.GV_ADD_ASSET_DETAILS.toString(), null, content.toString()));
    }

    public void deleteAssetRegistration() {
        DataContentProvider provider = new DataContentProvider(this.mAppContext);
        String selection = "type = '" + DataType.GV_ADD_ASSET_DETAILS.toString() + "'";
        this.mAppContext.getContentResolver().delete(provider.CONTENT_URI, selection, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisterAssetResponseDetailsAssetContent getAssetRegistration() {
        if (this.mAppContext != null) {
            Cursor cursor = null;
            try {
                String data;
                DataContentProvider provider = new DataContentProvider(this.mAppContext);
                String selection = "type = '" + DataType.GV_ADD_ASSET_DETAILS.toString() + "'";
                cursor = this.mAppContext.getContentResolver().query(provider.CONTENT_URI, DataContentTable.projection, selection, null, null);
                if (cursor != null && !TextUtils.isEmpty((CharSequence)(data = DataContentTable.getDataFromCursor(cursor)))) {
                    Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm").create();
                    RegisterAssetResponseDetailsAssetContent registerAssetResponseDetailsAssetContent = (RegisterAssetResponseDetailsAssetContent)gson.fromJson(data, RegisterAssetResponseDetailsAssetContent.class);
                    return registerAssetResponseDetailsAssetContent;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (cursor != null && !cursor.isClosed()) {
                        cursor.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return null;
    }

    public void saveGuestConversations(ConversationsResponseDetailsContent content) {
        DataContentProvider provider = new DataContentProvider(this.mAppContext);
        String selection = "type = '" + DataType.GUEST_CONVERSATIONS.toString() + "'";
        this.mAppContext.getContentResolver().delete(provider.CONTENT_URI, selection, null);
        this.mAppContext.getContentResolver().insert(provider.CONTENT_URI, DataContentTable.getContentValues(ContentManager.getPropertyCode(), LanguagesManager.getSelectedLanguageCode(), ContentManager.getContentVersionNumber(), DataType.GUEST_CONVERSATIONS.toString(), null, content.toString()));
    }

    public void deleteGuestConversations() {
        DataContentProvider provider = new DataContentProvider(this.mAppContext);
        String selection = "type = '" + DataType.GUEST_CONVERSATIONS.toString() + "'";
        this.mAppContext.getContentResolver().delete(provider.CONTENT_URI, selection, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Conversation> getGuestConversations() {
        if (this.mAppContext != null) {
            Cursor cursor = null;
            try {
                Gson gson;
                ConversationsResponseDetailsContent content;
                String data;
                DataContentProvider provider = new DataContentProvider(this.mAppContext);
                String selection = "type = '" + DataType.GUEST_CONVERSATIONS.toString() + "'";
                cursor = this.mAppContext.getContentResolver().query(provider.CONTENT_URI, DataContentTable.projection, selection, null, null);
                if (cursor != null && !TextUtils.isEmpty((CharSequence)(data = DataContentTable.getDataFromCursor(cursor))) && (content = (ConversationsResponseDetailsContent)(gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm").create()).fromJson(data, ConversationsResponseDetailsContent.class)) != null) {
                    ArrayList<Conversation> arrayList = content.conversations;
                    return arrayList;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (cursor != null && !cursor.isClosed()) {
                        cursor.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return null;
    }

    public void saveGuestOrderHistory(OrderHistoryResponseDetailsGetOrdersContent content) {
        DataContentProvider provider = new DataContentProvider(this.mAppContext);
        String selection = "type = '" + DataType.GUEST_ORDER_HISTORY.toString() + "' AND " + "propertyCode" + " = '" + ContentManager.getPropertyCode() + "'";
        this.mAppContext.getContentResolver().delete(provider.CONTENT_URI, selection, null);
        this.mAppContext.getContentResolver().insert(provider.CONTENT_URI, DataContentTable.getContentValues(ContentManager.getPropertyCode(), LanguagesManager.getSelectedLanguageCode(), ContentManager.getContentVersionNumber(), DataType.GUEST_ORDER_HISTORY.toString(), null, content.toString()));
    }

    public void saveNonVerifiedGuestOrderHistory(OrderHistoryResponseDetailsGetOrdersContent content) {
        DataContentProvider provider = new DataContentProvider(this.mAppContext);
        String selection = "type = '" + DataType.NON_VERIFIED_GUEST_ORDER_HISTORY.toString() + "' AND " + "propertyCode" + " = '" + ContentManager.getPropertyCode() + "'";
        this.mAppContext.getContentResolver().delete(provider.CONTENT_URI, selection, null);
        if (content != null) {
            this.mAppContext.getContentResolver().insert(provider.CONTENT_URI, DataContentTable.getContentValues(ContentManager.getPropertyCode(), LanguagesManager.getSelectedLanguageCode(), ContentManager.getContentVersionNumber(), DataType.NON_VERIFIED_GUEST_ORDER_HISTORY.toString(), null, content.toString()));
        }
    }

    public ArrayList<OrderHistoryItem> getGuestOrderHistory() {
        ArrayList<OrderHistoryItem> guestOrderHistory = this.getGuestOrderHistory(DataType.GUEST_ORDER_HISTORY);
        ArrayList<OrderHistoryItem> nonVerifiedGuestOrderHistory = this.getNonVerifiedGuestOrderHistory();
        if (guestOrderHistory == null) {
            guestOrderHistory = new ArrayList();
        }
        if (nonVerifiedGuestOrderHistory == null) {
            nonVerifiedGuestOrderHistory = new ArrayList();
        }
        guestOrderHistory.addAll(nonVerifiedGuestOrderHistory);
        return guestOrderHistory;
    }

    public ArrayList<OrderHistoryItem> getNonVerifiedGuestOrderHistory() {
        return this.getGuestOrderHistory(DataType.NON_VERIFIED_GUEST_ORDER_HISTORY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<OrderHistoryItem> getGuestOrderHistory(DataType type) {
        if (this.mAppContext != null) {
            Cursor cursor = null;
            try {
                Gson gson;
                OrderHistoryResponseDetailsGetOrdersContent content;
                String data;
                DataContentProvider provider = new DataContentProvider(this.mAppContext);
                String selection = "type = '" + type.toString() + "' AND " + "propertyCode" + " = '" + ContentManager.getPropertyCode() + "'";
                cursor = this.mAppContext.getContentResolver().query(provider.CONTENT_URI, DataContentTable.projection, selection, null, null);
                if (cursor != null && !TextUtils.isEmpty((CharSequence)(data = DataContentTable.getDataFromCursor(cursor))) && (content = (OrderHistoryResponseDetailsGetOrdersContent)(gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm").create()).fromJson(data, OrderHistoryResponseDetailsGetOrdersContent.class)) != null) {
                    ArrayList<OrderHistoryItem> arrayList = content.orders;
                    return arrayList;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (cursor != null && !cursor.isClosed()) {
                        cursor.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return null;
    }

    public void saveNonVerifiedGuestFields(String propertyCode, String langCode, int version, String outletCode, ArrayList<NonVerifiedGuestField> content) {
        if (content != null) {
            NonVerifiedGuestFieldsContainer container = new NonVerifiedGuestFieldsContainer(outletCode, content);
            DataContentProvider provider = new DataContentProvider(this.mAppContext);
            String selection = "type = '" + DataType.NON_VERIFIED_GUEST_FIELDS.toString() + "' AND " + "params" + " = '" + outletCode + "'";
            this.mAppContext.getContentResolver().delete(provider.CONTENT_URI, selection, null);
            this.mAppContext.getContentResolver().insert(provider.CONTENT_URI, DataContentTable.getContentValues(propertyCode, langCode, version, DataType.NON_VERIFIED_GUEST_FIELDS.toString(), outletCode, container.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ArrayList<NonVerifiedGuestField>> getAllNonVerifiedGuestFields() {
        if (this.mAppContext != null) {
            Cursor cursor = null;
            try {
                DataContentProvider provider = new DataContentProvider(this.mAppContext);
                String selection = "type = '" + DataType.NON_VERIFIED_GUEST_FIELDS.toString() + "'";
                cursor = this.mAppContext.getContentResolver().query(provider.CONTENT_URI, DataContentTable.projection, selection, null, null);
                if (cursor != null) {
                    HashMap<String, ArrayList<NonVerifiedGuestField>> results = new HashMap<String, ArrayList<NonVerifiedGuestField>>();
                    while (cursor.moveToNext()) {
                        Gson gson;
                        NonVerifiedGuestFieldsContainer container;
                        String data = DataContentTable.getData(cursor);
                        if (data == null || (container = (NonVerifiedGuestFieldsContainer)(gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm").create()).fromJson(data, NonVerifiedGuestFieldsContainer.class)) == null || container.outletCode == null) continue;
                        results.put(container.outletCode, container.content);
                    }
                    HashMap<String, ArrayList<NonVerifiedGuestField>> hashMap = results;
                    return hashMap;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (cursor != null && !cursor.isClosed()) {
                        cursor.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getContentVersionNumber() {
        if (this.mAppContext != null) {
            Cursor cursor = null;
            try {
                DataContentProvider provider = new DataContentProvider(this.mAppContext);
                String selection = "type = '" + DataType.CONTENT_VERSION.toString() + "' AND " + "propertyCode" + " = '" + ContentManager.getPropertyCode() + "'";
                DebugLog.d(this.TAG, "getContentVersionNumber: " + selection);
                cursor = this.mAppContext.getContentResolver().query(provider.CONTENT_URI, DataContentTable.projection, selection, null, null);
                if (cursor != null) {
                    int n = Integer.parseInt(DataContentTable.getDataFromCursor(cursor));
                    return n;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (cursor != null && !cursor.isClosed()) {
                        cursor.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return 0;
    }

    public void setContentVersionNumber(int value) {
        DataContentProvider provider = new DataContentProvider(this.mAppContext);
        String selection = "type = '" + DataType.CONTENT_VERSION.toString() + "' AND " + "propertyCode" + " = '" + ContentManager.getPropertyCode() + "'";
        this.mAppContext.getContentResolver().delete(provider.CONTENT_URI, selection, null);
        this.mAppContext.getContentResolver().insert(provider.CONTENT_URI, DataContentTable.getContentValues(ContentManager.getPropertyCode(), null, value, DataType.CONTENT_VERSION.toString(), null, Integer.toString(value)));
    }

    private class NonVerifiedGuestFieldsContainer
    extends BaseObject {
        @SerializedName(value="outletCode")
        String outletCode;
        @SerializedName(value="content")
        ArrayList<NonVerifiedGuestField> content;

        NonVerifiedGuestFieldsContainer(String outletCode, ArrayList<NonVerifiedGuestField> content) {
            this.outletCode = outletCode;
            this.content = content;
        }
    }

    public static enum DataType {
        STATIC_CONTENT,
        CART_SETTINGS,
        CMS_SETTINGS,
        PROPERTY_SETTINGS,
        LANGUAGE_SETTINGS,
        CONTENT_HOMEPAGE,
        CONTENT_SECTIONS_ITEMS,
        CONTENT_OUTLETS,
        CONTENT_OUTLET_SETTINGS,
        CONTENT_DELIVERY_AREAS,
        AIRPORTS_DATA,
        FORECAST_DATA,
        SHOPPING_CART,
        GUEST_PROFILE,
        USER_DETAILS,
        GV_USER_DETAILS,
        GV_ROOM_DETAILS,
        GV_ADD_ASSET_DETAILS,
        GUEST_CONVERSATIONS,
        GUEST_ORDER_HISTORY,
        CONTENT_HOMEPAGE_BY_GUEST,
        CONTENT_SECTIONS_ITEMS_BY_GUEST,
        NON_VERIFIED_GUEST_FIELDS,
        NON_VERIFIED_GUEST_ORDER_HISTORY,
        CONTENT_VERSION;

    }
}

