/*
 * Decompiled with CFR 0.152.
 */
package com.irisvalet.android.apps.mobilevalethelper.database.contentproviders;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import android.text.TextUtils;
import com.irisvalet.android.apps.mobilevalethelper.database.DatabaseHelper;
import com.irisvalet.android.apps.mobilevalethelper.database.tables.DataContentTable;
import com.irisvalet.android.apps.mobilevalethelper.utils.DebugLog;
import java.util.Arrays;
import java.util.HashSet;

public class DataContentProvider
extends ContentProvider {
    protected static DatabaseHelper database;
    protected static SQLiteDatabase sqlDB;
    protected Context mContext;
    protected static String AUTHORITY;
    protected static String BASE_PATH;
    protected static String CONTENT_TYPE_PATH;
    protected static String CONTENT_ITEM_TYPE_PATH;
    protected static String TABLE;
    protected static String COLUMN_ID;
    protected static String[] COLUMNS;
    protected static final int LIST_VALUES = 10;
    protected static final int LIST_VALUES_IDS = 20;
    public static final UriMatcher sURIMatcher;
    public Uri CONTENT_URI = Uri.parse((String)("content://" + AUTHORITY + "/" + BASE_PATH));
    protected String CONTENT_TYPE = "vnd.android.cursor.dir/" + CONTENT_TYPE_PATH;
    protected String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/" + CONTENT_ITEM_TYPE_PATH;

    public DataContentProvider(Context context) {
        this.mContext = context;
    }

    public DataContentProvider() {
    }

    public boolean onCreate() {
        AUTHORITY = this.getContext().getPackageName() + ".library.config_values.provider";
        database = new DatabaseHelper(this.getContext());
        sqlDB = database.getWritableDatabase();
        sURIMatcher.addURI(AUTHORITY, BASE_PATH, 10);
        sURIMatcher.addURI(AUTHORITY, BASE_PATH + "/#", 20);
        return false;
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        SQLiteQueryBuilder queryBuilder = new SQLiteQueryBuilder();
        this.checkColumns(projection);
        queryBuilder.setTables(TABLE);
        int uriType = sURIMatcher.match(uri);
        switch (uriType) {
            case 10: {
                break;
            }
            case 20: {
                queryBuilder.appendWhere((CharSequence)(COLUMN_ID + "= " + uri.getLastPathSegment()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown URI: " + uri);
            }
        }
        Cursor cursor = null;
        try {
            SQLiteDatabase db = database.getWritableDatabase();
            cursor = queryBuilder.query(db, projection, selection, selectionArgs, null, null, sortOrder);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cursor;
    }

    protected void checkColumns(String[] projection) {
        if (projection != null) {
            HashSet<String> requestColumns = new HashSet<String>(Arrays.asList(projection));
            HashSet<String> availableColumns = new HashSet<String>(Arrays.asList(COLUMNS));
            if (!availableColumns.containsAll(requestColumns)) {
                StringBuilder strProjection = new StringBuilder("[");
                StringBuilder strColumns = new StringBuilder("[");
                for (String aProjection : projection) {
                    strProjection.append(aProjection).append(", ");
                }
                strProjection.append("]");
                for (String COLUMN : COLUMNS) {
                    strColumns.append(COLUMN).append(", ");
                }
                strColumns.append("]");
                DebugLog.d("checkColumns", "projection = " + strProjection);
                DebugLog.d("checkColumns", "COLUMNS = " + strColumns);
                throw new IllegalArgumentException("Unknown columns in projection");
            }
        }
    }

    public String getType(Uri uri) {
        return null;
    }

    public Uri insert(Uri uri, ContentValues values) {
        int uriType = sURIMatcher.match(uri);
        long id = 0L;
        try {
            switch (uriType) {
                case 10: {
                    id = sqlDB.insert(TABLE, null, values);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown URI: " + uri);
                }
            }
            if (this.mContext != null) {
                this.mContext.getContentResolver().notifyChange(uri, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Uri.parse((String)(BASE_PATH + "/" + id));
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        int uriType = sURIMatcher.match(uri);
        int rowsDeleted = 0;
        try {
            switch (uriType) {
                case 10: {
                    rowsDeleted = sqlDB.delete(TABLE, selection, selectionArgs);
                    break;
                }
                case 20: {
                    String id = uri.getLastPathSegment();
                    if (TextUtils.isEmpty((CharSequence)selection)) {
                        rowsDeleted = sqlDB.delete(TABLE, COLUMN_ID + "=" + id, null);
                        break;
                    }
                    rowsDeleted = sqlDB.delete(TABLE, COLUMN_ID + "=" + id + " and " + selection, selectionArgs);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown URI: " + uri);
                }
            }
            if (this.mContext != null) {
                this.mContext.getContentResolver().notifyChange(uri, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rowsDeleted;
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        int uriType = sURIMatcher.match(uri);
        int rowsUpdated = 0;
        try {
            switch (uriType) {
                case 10: {
                    rowsUpdated = sqlDB.update(TABLE, values, selection, selectionArgs);
                    break;
                }
                case 20: {
                    String id = uri.getLastPathSegment();
                    if (TextUtils.isEmpty((CharSequence)selection)) {
                        rowsUpdated = sqlDB.update(TABLE, values, COLUMN_ID + "=" + id, null);
                        break;
                    }
                    rowsUpdated = sqlDB.update(TABLE, values, COLUMN_ID + "=" + id + " and " + selection, selectionArgs);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown URI: " + uri);
                }
            }
            if (this.mContext != null) {
                this.mContext.getContentResolver().notifyChange(uri, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rowsUpdated;
    }

    static {
        BASE_PATH = "data_values";
        CONTENT_TYPE_PATH = "data_values";
        CONTENT_ITEM_TYPE_PATH = "data_value";
        TABLE = "DataContentTable";
        COLUMN_ID = "id";
        COLUMNS = DataContentTable.projection;
        sURIMatcher = new UriMatcher(-1);
    }
}

