/*
 * Decompiled with CFR 0.152.
 */
package com.irisvalet.android.apps.mobilevalethelper.database.tables;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.irisvalet.android.apps.mobilevalethelper.utils.DebugLog;
import java.util.Date;
import java.util.UUID;

public class DataContentTable {
    public static final String TABLE = "DataContentTable";
    public static final String COLUMN_ID = "id";
    public static final String COLUMN_LANGUAGE_CODE = "langCode";
    public static final String COLUMN_VERSION = "version";
    public static final String COLUMN_PROPERTY_CODE = "propertyCode";
    public static final String COLUMN_TYPE = "type";
    public static final String COLUMN_PARAMS = "params";
    private static final String COLUMN_DATA = "data";
    private static final String COLUMN_DATE_CHANGED = "dateChanged";
    public static final String[] projection = new String[]{"id", "langCode", "version", "propertyCode", "type", "params", "data", "dateChanged"};
    private static final String DATABASE_CREATE = "CREATE TABLE IF NOT EXISTS DataContentTable (id text not null, langCode text, version text, propertyCode text, type text, params text, data text, dateChanged text  );";

    public static void onCreate(SQLiteDatabase database) {
        database.execSQL(DATABASE_CREATE);
    }

    public static void onUpgrade(SQLiteDatabase database, int oldVersion, int newVersion) {
        DebugLog.i(DataContentTable.class.getName(), "Upgrading database from version " + oldVersion + " to " + newVersion);
        DataContentTable.upgradeTable(database, TABLE);
        DataContentTable.onCreate(database);
    }

    private static void upgradeTable(SQLiteDatabase database, String table) {
        database.execSQL("DROP TABLE IF EXISTS " + table);
    }

    public static ContentValues getContentValues(String propertyCode, String langCode, int version, String type, String params, String data) {
        ContentValues values = null;
        values = new ContentValues();
        try {
            values.put(COLUMN_ID, UUID.randomUUID().toString());
            values.put(COLUMN_LANGUAGE_CODE, langCode);
            try {
                values.put(COLUMN_VERSION, Integer.toString(version));
            }
            catch (Exception e) {
                values.put(COLUMN_VERSION, "0");
            }
            values.put(COLUMN_PROPERTY_CODE, propertyCode);
            values.put(COLUMN_TYPE, type);
            values.put(COLUMN_PARAMS, params);
            values.put(COLUMN_DATA, data);
            values.put(COLUMN_DATE_CHANGED, new Date().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return values;
    }

    public static String getDataFromCursor(Cursor cursor) {
        if (cursor.moveToFirst()) {
            return cursor.getString(6);
        }
        return null;
    }

    public static String getData(Cursor cursor) {
        if (cursor != null) {
            return cursor.getString(6);
        }
        return null;
    }
}

