/*
 * Decompiled with CFR 0.152.
 */
package com.irisvalet.android.apps.mobilevalethelper.object;

import android.text.TextUtils;
import com.google.gson.annotations.SerializedName;
import com.irisvalet.android.apps.mobilevalethelper.object.Attribute;
import com.irisvalet.android.apps.mobilevalethelper.object.AvailabilitySummary;
import com.irisvalet.android.apps.mobilevalethelper.object.BaseObject;
import com.irisvalet.android.apps.mobilevalethelper.object.CategoryItemButton;
import com.irisvalet.android.apps.mobilevalethelper.object.ItemImage;
import com.irisvalet.android.apps.mobilevalethelper.object.Modifier;
import com.irisvalet.android.apps.mobilevalethelper.object.ModifierOption;
import com.irisvalet.android.apps.mobilevalethelper.object.SubModifier;
import java.util.ArrayList;

public class CategoryItem
extends BaseObject {
    @SerializedName(value="code")
    public String code = null;
    @SerializedName(value="price")
    public float price = 0.0f;
    @SerializedName(value="fromPrice")
    public float fromPrice = 0.0f;
    @SerializedName(value="imageUrl")
    public String imageUrl = null;
    @SerializedName(value="directContentParameter")
    public String directContentParameter = null;
    @SerializedName(value="type")
    public String type = null;
    @SerializedName(value="name")
    public String name = null;
    @SerializedName(value="internalName")
    public String internalName;
    @SerializedName(value="shortDescription")
    public String shortDescription = null;
    @SerializedName(value="longDescription")
    public String longDescription = null;
    @SerializedName(value="propertyCode")
    public String propertyCode;
    @SerializedName(value="outletCode")
    public String outletCode = null;
    @SerializedName(value="sectionCode")
    public String sectionCode = null;
    @SerializedName(value="categoryCode")
    public String categoryCode = null;
    @SerializedName(value="itemCode")
    public String itemCode = null;
    @SerializedName(value="printEnabled")
    public boolean printEnabled = false;
    @SerializedName(value="emailSharingEnable")
    public boolean emailSharingEnable = false;
    @SerializedName(value="qrCodeEnabled")
    public boolean qrCodeEnabled = false;
    @SerializedName(value="promo")
    public boolean promo = false;
    @SerializedName(value="directContentType")
    public String directContentType = null;
    @SerializedName(value="attributes")
    public ArrayList<Attribute> attributes = null;
    @SerializedName(value="availabilitySummary")
    public AvailabilitySummary availabilitySummary = null;
    @SerializedName(value="categoryName")
    public String categoryName;
    @SerializedName(value="relatedCategoryItemCodes")
    public ArrayList<String> relatedCategoryItemCodes = null;
    @SerializedName(value="modifiers")
    public ArrayList<Modifier> modifiers = null;
    @SerializedName(value="itemImages")
    public ArrayList<ItemImage> itemImages = null;
    @SerializedName(value="posItemCode")
    public String posItemCode;
    @SerializedName(value="isInStock")
    public boolean isInStock = false;
    @SerializedName(value="spaItemCode")
    public String spaItemCode;
    @SerializedName(value="sosItemCode")
    public String sosItemCode;
    @SerializedName(value="templateTag")
    public String templateTag = null;
    @SerializedName(value="position")
    public int position = 0;
    @SerializedName(value="cartCounter")
    public int cartCounter = 0;
    @SerializedName(value="buttons")
    public ArrayList<CategoryItemButton> buttons = null;

    public CategoryItem() {
    }

    public CategoryItem(CategoryItem item) {
        this.code = item.code;
        this.price = item.price;
        this.imageUrl = item.imageUrl;
        this.directContentParameter = item.directContentParameter;
        this.type = item.type;
        this.name = item.name;
        this.internalName = item.internalName;
        this.shortDescription = item.shortDescription;
        this.longDescription = item.longDescription;
        this.categoryCode = item.categoryCode;
        this.sectionCode = item.sectionCode;
        this.outletCode = item.outletCode;
        this.propertyCode = item.propertyCode;
        this.itemCode = item.itemCode;
        this.printEnabled = item.printEnabled;
        this.emailSharingEnable = item.emailSharingEnable;
        this.qrCodeEnabled = item.qrCodeEnabled;
        this.promo = item.promo;
        this.directContentType = item.directContentType;
        this.categoryName = item.categoryName;
        this.posItemCode = item.posItemCode;
        this.isInStock = item.isInStock;
        this.spaItemCode = item.spaItemCode;
        this.sosItemCode = item.sosItemCode;
        this.fromPrice = item.fromPrice;
        this.templateTag = item.templateTag;
        this.position = item.position;
        this.cartCounter = item.cartCounter;
        this.availabilitySummary = item.availabilitySummary;
        if (item.buttons != null && item.buttons.size() > 0) {
            this.buttons = new ArrayList();
            for (CategoryItemButton button : item.buttons) {
                CategoryItemButton newButton = new CategoryItemButton(button);
                this.buttons.add(newButton);
            }
        }
        if (item.attributes != null && item.attributes.size() > 0) {
            this.attributes = new ArrayList();
            for (Attribute att : item.attributes) {
                Attribute newAtt = new Attribute(att);
                this.attributes.add(newAtt);
            }
        }
        if (item.relatedCategoryItemCodes != null && item.relatedCategoryItemCodes.size() > 0) {
            this.relatedCategoryItemCodes = new ArrayList();
            this.relatedCategoryItemCodes.addAll(item.relatedCategoryItemCodes);
        }
        if (item.modifiers != null && item.modifiers.size() > 0) {
            this.modifiers = new ArrayList();
            for (Modifier modifier : item.modifiers) {
                Modifier newModifier = new Modifier(modifier);
                this.modifiers.add(newModifier);
            }
        }
        if (item.itemImages != null && item.itemImages.size() > 0) {
            this.itemImages = new ArrayList();
            for (ItemImage itemImage : item.itemImages) {
                ItemImage newItemImage = new ItemImage(itemImage);
                this.itemImages.add(newItemImage);
            }
        }
    }

    public float getPrice() {
        if (this.modifiers == null || this.modifiers.size() == 0) {
            return this.price;
        }
        float modifiersPrice = 0.0f;
        if (this.isSingleSelectRequiredNonZeroModifiers()) {
            boolean modifierOptionsSelected = false;
            for (Modifier m : this.modifiers) {
                if (m.modifierOptions == null || m.modifierOptions.size() <= 0) continue;
                for (ModifierOption mo : m.modifierOptions) {
                    if (mo.subModifiers != null && mo.subModifiers.size() > 0) {
                        for (SubModifier subModifier : mo.subModifiers) {
                            if (subModifier.modifierOptions == null || subModifier.modifierOptions.size() <= 0) continue;
                            for (ModifierOption subModifierOption : subModifier.modifierOptions) {
                                if (subModifierOption.quantity <= 0) continue;
                                modifierOptionsSelected = true;
                                modifiersPrice += subModifierOption.price * (float)subModifierOption.quantity;
                            }
                        }
                    }
                    if (mo.quantity <= 0) continue;
                    modifierOptionsSelected = true;
                    modifiersPrice += mo.price * (float)mo.quantity;
                }
            }
            if (modifierOptionsSelected) {
                return modifiersPrice;
            }
            return this.price;
        }
        for (Modifier m : this.modifiers) {
            if (m.modifierOptions == null || m.modifierOptions.size() <= 0) continue;
            for (ModifierOption mo : m.modifierOptions) {
                if (mo.subModifiers != null && mo.subModifiers.size() > 0) {
                    for (SubModifier subModifier : mo.subModifiers) {
                        if (subModifier.modifierOptions == null || subModifier.modifierOptions.size() <= 0) continue;
                        for (ModifierOption subModifierOption : subModifier.modifierOptions) {
                            if (subModifierOption.quantity <= 0) continue;
                            modifiersPrice += subModifierOption.price * (float)subModifierOption.quantity;
                        }
                    }
                }
                if (mo.quantity <= 0) continue;
                modifiersPrice += mo.price * (float)mo.quantity;
            }
        }
        return this.price + modifiersPrice;
    }

    public float getBasePrice() {
        if (this.isSingleSelectRequiredNonZeroModifiers()) {
            return this.fromPrice();
        }
        return this.price;
    }

    public boolean isFromPrice() {
        return this.isSingleSelectRequiredNonZeroModifiers();
    }

    private boolean isSingleSelectRequiredNonZeroModifiers() {
        int singleSelectRequiredModifiersFound = 0;
        if (this.modifiers != null && this.modifiers.size() > 0) {
            for (Modifier m : this.modifiers) {
                if (!m.isRequired || m.type == null || !m.type.toLowerCase().equals("select")) continue;
                boolean singleSelectRequiredModifierFound = true;
                for (ModifierOption mo : m.modifierOptions) {
                    if (mo.price != 0.0f) continue;
                    singleSelectRequiredModifierFound = false;
                    break;
                }
                if (singleSelectRequiredModifierFound) {
                    ++singleSelectRequiredModifiersFound;
                }
                if (singleSelectRequiredModifiersFound <= 1) continue;
                return false;
            }
        }
        return singleSelectRequiredModifiersFound == 1;
    }

    public String getImageUrl() {
        if (!TextUtils.isEmpty((CharSequence)this.imageUrl)) {
            return this.imageUrl;
        }
        if (this.itemImages != null && this.itemImages.size() > 0) {
            return this.itemImages.get((int)0).url;
        }
        return null;
    }

    public float fromPrice() {
        if (this.isSingleSelectRequiredNonZeroModifiers()) {
            for (Modifier m : this.modifiers) {
                if (m.type == null || !m.type.toLowerCase().equals("select") || m.modifierOptions == null || m.modifierOptions.size() <= 0) continue;
                this.fromPrice = 0.0f;
                for (ModifierOption mo : m.modifierOptions) {
                    this.fromPrice = this.fromPrice == 0.0f ? mo.price : Math.min(this.fromPrice, mo.price);
                }
                return this.fromPrice;
            }
        }
        return this.price;
    }
}

