/*
 * Decompiled with CFR 0.152.
 */
package com.irisvalet.android.apps.mobilevalethelper.object;

import com.google.gson.annotations.SerializedName;
import com.irisvalet.android.apps.mobilevalethelper.object.HotelMessage;
import com.irisvalet.android.apps.mobilevalethelper.object.OrderHistoryItem;
import com.irisvalet.android.apps.mobilevalethelper.utils.TranslationUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.TimeZone;

public class Conversation {
    @SerializedName(value="code")
    public String code = null;
    @SerializedName(value="subject")
    public String subject = null;
    @SerializedName(value="outletCode")
    public String outletCode = null;
    @SerializedName(value="orderCode")
    public String orderCode = null;
    @SerializedName(value="outletName")
    public String outletName = null;
    @SerializedName(value="propertyCode")
    public String propertyCode = null;
    @SerializedName(value="roomNumber")
    public String roomNumber = null;
    @SerializedName(value="guestFirstName")
    public String guestFirstName = null;
    @SerializedName(value="guestLastName")
    public String guestLastName = null;
    @SerializedName(value="guestLanguageCode")
    public String guestLanguageCode = null;
    @SerializedName(value="conversationStatus")
    public String conversationStatus = null;
    @SerializedName(value="conversationType")
    public String conversationType = null;
    @SerializedName(value="messages")
    public ArrayList<HotelMessage> messages = null;
    public boolean selected;
    public OrderHistoryItem orderDetails;

    public Conversation() {
    }

    public Conversation(String name) {
        this.outletName = name;
    }

    public int getUnreadMessages() {
        int unread = 0;
        if (this.messages != null && this.messages.size() > 0) {
            for (HotelMessage m : this.messages) {
                if (m.messageType == null || m.messageType.equals("guest") || m.isRead) continue;
                ++unread;
            }
        }
        return unread;
    }

    public long getEpochDatetime() {
        long value = 0L;
        if (this.messages != null && this.messages.size() > 0 && this.messages.get(0) != null && this.messages.get((int)0).createDate != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS", Locale.getDefault());
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            try {
                value = sdf.parse(this.messages.get((int)0).createDate).getTime();
            }
            catch (ParseException e) {
                SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.getDefault());
                sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
                try {
                    value = sdf1.parse(this.messages.get((int)0).createDate).getTime();
                }
                catch (ParseException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return value;
    }

    public String getDatetime() {
        String value = "";
        if (this.messages != null && this.messages.size() > 0 && this.messages.get(0) != null && this.messages.get((int)0).createDate != null) {
            value = this.messages.get((int)0).createDate;
        }
        return value;
    }

    public String getHumanReadableTime() {
        String value = "";
        if (this.messages != null && this.messages.size() > 0 && this.messages.get(0) != null && this.messages.get((int)0).createDate != null) {
            value = this.messages.get(0).getHumanReadableTime();
        }
        return value;
    }

    public String getSnippet() {
        String value = "";
        if (this.messages != null && this.messages.size() > 0 && this.messages.get(0) != null && this.messages.get((int)0).content != null) {
            value = TranslationUtils.parseTokenizedValues(this.messages.get((int)0).content);
        }
        return value;
    }
}

