/*
 * Decompiled with CFR 0.152.
 */
package com.irisvalet.android.apps.mobilevalethelper.object;

import com.google.gson.annotations.SerializedName;
import com.irisvalet.android.apps.mobilevalethelper.PropertyManager;
import com.irisvalet.android.apps.mobilevalethelper.utils.TranslationUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class HotelMessage {
    @SerializedName(value="createDate")
    public String createDate = null;
    @SerializedName(value="code")
    public String code = null;
    @SerializedName(value="isRead")
    public boolean isRead = false;
    @SerializedName(value="serviceCenterName")
    public String serviceCenterName = null;
    @SerializedName(value="messageType")
    public String messageType = null;
    @SerializedName(value="content")
    public String content = null;
    @SerializedName(value="firstName")
    public String firstName = null;
    @SerializedName(value="lastName")
    public String lastName = null;
    @SerializedName(value="languageCode")
    public String languageCode = null;
    @SerializedName(value="isTranslated")
    public boolean isTranslated = false;
    @SerializedName(value="conversationId")
    public int conversationId = 0;
    private static final String TODAY_TIME_FORMAT = "hh:mmaa dd MMM";
    private static final String TODAY_DATE_FORMAT = "yyyy-MM-dd";

    public String getHumanReadableTime() {
        String value = "";
        if (this.createDate != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS", Locale.getDefault());
            SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.getDefault());
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            sdf1.setTimeZone(TimeZone.getTimeZone("UTC"));
            SimpleDateFormat timeFormat = new SimpleDateFormat(TODAY_TIME_FORMAT, Locale.getDefault());
            SimpleDateFormat dateFormat = new SimpleDateFormat(TODAY_DATE_FORMAT, Locale.getDefault());
            String tz = PropertyManager.getPropertyTimeZone();
            if (tz != null) {
                timeFormat.setTimeZone(TimeZone.getTimeZone(tz));
                dateFormat.setTimeZone(TimeZone.getTimeZone(tz));
            }
            Date date = null;
            try {
                date = sdf.parse(this.createDate);
            }
            catch (ParseException e) {
                try {
                    date = sdf1.parse(this.createDate);
                }
                catch (ParseException e1) {
                    e1.printStackTrace();
                }
            }
            if (date != null) {
                Calendar calendarNow = Calendar.getInstance();
                Calendar calendarMessage = Calendar.getInstance();
                calendarNow.setTimeInMillis(System.currentTimeMillis());
                calendarMessage.setTimeInMillis(date.getTime());
                value = calendarNow.get(1) == calendarMessage.get(1) && calendarNow.get(2) == calendarMessage.get(2) && calendarNow.get(5) == calendarMessage.get(5) ? timeFormat.format(date) : (calendarNow.get(1) == calendarMessage.get(1) && calendarNow.get(2) == calendarMessage.get(2) && calendarNow.get(5) == calendarMessage.get(5) + 1 ? TranslationUtils.getTranslatedString("valet_shared_label.yesterday") : dateFormat.format(date));
            }
        }
        return value;
    }

    public String getMessageHumanReadableTime() {
        String value = "";
        if (this.createDate != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS", Locale.getDefault());
            SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.getDefault());
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            sdf1.setTimeZone(TimeZone.getTimeZone("UTC"));
            SimpleDateFormat timeFormat = new SimpleDateFormat(TODAY_TIME_FORMAT, Locale.getDefault());
            String tz = PropertyManager.getPropertyTimeZone();
            if (tz != null) {
                timeFormat.setTimeZone(TimeZone.getTimeZone(tz));
            }
            Date date = null;
            try {
                date = sdf.parse(this.createDate);
            }
            catch (ParseException e) {
                try {
                    date = sdf1.parse(this.createDate);
                }
                catch (ParseException e1) {
                    e1.printStackTrace();
                }
            }
            if (date != null) {
                value = timeFormat.format(date);
            }
        }
        return value;
    }
}

