/*
 * Decompiled with CFR 0.152.
 */
package com.irisvalet.android.apps.mobilevalethelper.object;

import com.google.gson.annotations.SerializedName;
import com.irisvalet.android.apps.mobilevalethelper.object.BaseObject;
import com.irisvalet.android.apps.mobilevalethelper.object.ModifierOption;
import com.irisvalet.android.apps.mobilevalethelper.object.SubModifier;
import java.util.ArrayList;

public class Modifier
extends BaseObject {
    @SerializedName(value="name")
    public String name = null;
    @SerializedName(value="code")
    public String code = null;
    @SerializedName(value="parentModifierOptionCode")
    public String parentModifierOptionCode = null;
    @SerializedName(value="type")
    public String type = null;
    @SerializedName(value="isRequired")
    public boolean isRequired = false;
    @SerializedName(value="sortOrder")
    public int sortOrder = 0;
    @SerializedName(value="maximumQuantity")
    public int maximumQuantity = 0;
    @SerializedName(value="modifierOptions")
    public ArrayList<ModifierOption> modifierOptions = null;
    public String value = null;
    public boolean isMissing = false;

    public Modifier() {
    }

    public Modifier(Modifier item) {
        this.name = item.name;
        this.code = item.code;
        this.parentModifierOptionCode = item.parentModifierOptionCode;
        this.type = item.type;
        this.isRequired = item.isRequired;
        this.value = item.value;
        this.isMissing = false;
        this.sortOrder = item.sortOrder;
        this.maximumQuantity = item.maximumQuantity;
        if (item.modifierOptions != null && item.modifierOptions.size() > 0) {
            this.modifierOptions = new ArrayList();
            for (ModifierOption option : item.modifierOptions) {
                ModifierOption newOption = new ModifierOption(option);
                this.modifierOptions.add(newOption);
            }
        }
    }

    public boolean checkMaxQuantityOptions() {
        if (this.maximumQuantity == 0) {
            return true;
        }
        if (this.modifierOptions == null || this.modifierOptions.size() == 0) {
            return false;
        }
        int optionsSelected = 0;
        int subModifiersSelected = 0;
        for (ModifierOption mo : this.modifierOptions) {
            if (mo.subModifiers != null && mo.subModifiers.size() > 0) {
                block1: for (SubModifier sm : mo.subModifiers) {
                    if (sm.modifierOptions == null || sm.modifierOptions.size() <= 0) continue;
                    for (ModifierOption smo : sm.modifierOptions) {
                        if (smo.quantity <= 0) continue;
                        ++subModifiersSelected;
                        continue block1;
                    }
                }
            }
            optionsSelected += mo.quantity;
        }
        return optionsSelected + subModifiersSelected < this.maximumQuantity;
    }
}

