/*
 * Decompiled with CFR 0.152.
 */
package com.irisvalet.android.apps.mobilevalethelper.object;

import android.content.Context;
import com.google.gson.annotations.SerializedName;
import com.irisvalet.android.apps.mobilevalethelper.PropertyManager;
import com.irisvalet.android.apps.mobilevalethelper.object.BaseObject;
import com.irisvalet.android.apps.mobilevalethelper.object.OrderHistoryExtraCharges;
import com.irisvalet.android.apps.mobilevalethelper.object.OrderItem;
import com.irisvalet.android.apps.mobilevalethelper.utils.TranslationUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class OrderHistoryItem
extends BaseObject {
    @SerializedName(value="id")
    public String id = null;
    @SerializedName(value="code")
    public String code = null;
    @SerializedName(value="outletCode")
    public String outletCode = null;
    @SerializedName(value="outletName")
    public String outletName = "";
    @SerializedName(value="serviceCharge")
    public float serviceCharge;
    @SerializedName(value="tax")
    public float tax;
    @SerializedName(value="deliveryCharge")
    public float deliveryCharge;
    @SerializedName(value="total")
    public float total = 0.0f;
    @SerializedName(value="deliveryDateTimeUtc")
    public String deliveryDateTimeUtc = null;
    @SerializedName(value="createdDateTimeUtc")
    public String createdDateTimeUtc = null;
    @SerializedName(value="guestComment")
    public String guestComment = null;
    @SerializedName(value="deliveryLocation")
    public String deliveryLocation = null;
    @SerializedName(value="status")
    public String status = null;
    @SerializedName(value="items")
    public ArrayList<OrderItem> items = null;
    @SerializedName(value="extraCharges")
    public ArrayList<OrderHistoryExtraCharges> extraCharges = null;
    @SerializedName(value="paid")
    public float paid = 0.0f;

    public String getHumanReadableCreatedTime(Context context, boolean isShortVersion) {
        return this.getHumanReadableTime(context, this.createdDateTimeUtc, isShortVersion);
    }

    public String getHumanReadableDeliveryTime(Context context, boolean isShortVersion) {
        return this.getHumanReadableTime(context, this.deliveryDateTimeUtc, isShortVersion);
    }

    private String getHumanReadableTime(Context context, String timeString, boolean isShortVersion) {
        String value = "";
        if (timeString != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS", Locale.getDefault());
            SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.getDefault());
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            sdf1.setTimeZone(TimeZone.getTimeZone("UTC"));
            SimpleDateFormat timeFormat = new SimpleDateFormat("hh:mmaa", Locale.getDefault());
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
            String tz = PropertyManager.getPropertyTimeZone();
            if (tz != null) {
                timeFormat.setTimeZone(TimeZone.getTimeZone(tz));
                dateFormat.setTimeZone(TimeZone.getTimeZone(tz));
            }
            Date date = null;
            try {
                date = sdf.parse(timeString);
            }
            catch (ParseException e) {
                try {
                    date = sdf1.parse(timeString);
                }
                catch (ParseException e1) {
                    date = new Date();
                }
            }
            if (date != null) {
                value = timeFormat.format(date);
            }
            if (isShortVersion) {
                Calendar calendarNow = Calendar.getInstance();
                Calendar calendarMessage = Calendar.getInstance();
                calendarNow.setTimeInMillis(System.currentTimeMillis());
                calendarMessage.setTimeInMillis(date.getTime());
                value = calendarNow.get(1) == calendarMessage.get(1) && calendarNow.get(2) == calendarMessage.get(2) && calendarNow.get(5) == calendarMessage.get(5) ? timeFormat.format(date) : (calendarNow.get(1) == calendarMessage.get(1) && calendarNow.get(2) == calendarMessage.get(2) && calendarNow.get(5) == calendarMessage.get(5) + 1 ? TranslationUtils.getTranslatedString("valet_shared_label.yesterday") : dateFormat.format(date));
            }
        }
        return value;
    }
}

