/*
 * Decompiled with CFR 0.152.
 */
package com.irisvalet.android.apps.mobilevalethelper.object;

import com.google.gson.annotations.SerializedName;
import com.irisvalet.android.apps.mobilevalethelper.object.BaseObject;
import com.irisvalet.android.apps.mobilevalethelper.object.CategoryItem;
import com.irisvalet.android.apps.mobilevalethelper.object.Modifier;
import com.irisvalet.android.apps.mobilevalethelper.object.ModifierOption;
import java.util.ArrayList;
import java.util.UUID;

public class ShoppingCartItem
extends BaseObject {
    @SerializedName(value="id")
    public String id = UUID.randomUUID().toString();
    @SerializedName(value="item")
    public CategoryItem item = null;
    @SerializedName(value="price")
    public float price = 0.0f;
    @SerializedName(value="quantity")
    public int quantity = 0;
    @SerializedName(value="comments")
    public String comments = "";
    public boolean selectedToRemove = false;
    private ArrayList<ModifierOption> selectedModifierOptions;

    private int getSelectedModifierOptionsSize() {
        if (this.selectedModifierOptions == null) {
            return 0;
        }
        return this.selectedModifierOptions.size();
    }

    public ShoppingCartItem(String sectionCode, CategoryItem item, int quantity, String comments) {
        this.item = new CategoryItem(item);
        this.item.sectionCode = sectionCode;
        this.quantity = quantity;
        this.comments = comments;
        this.createSelectedModifiersOptions(item);
    }

    public ShoppingCartItem(ShoppingCartItem item) {
        this.item = new CategoryItem(item.item);
        this.price = item.price;
        this.quantity = item.quantity;
        this.selectedToRemove = false;
        this.comments = item.comments;
        this.createSelectedModifiersOptions(item.item);
    }

    private void createSelectedModifiersOptions(CategoryItem item) {
        if (item.modifiers != null && item.modifiers.size() > 0) {
            this.selectedModifierOptions = new ArrayList();
            for (Modifier m : item.modifiers) {
                if (m.modifierOptions == null || m.modifierOptions.size() <= 0) continue;
                for (ModifierOption mo : m.modifierOptions) {
                    if (mo.quantity <= 0) continue;
                    this.selectedModifierOptions.add(mo);
                }
            }
            if (this.selectedModifierOptions.size() == 0) {
                this.selectedModifierOptions = null;
            }
        }
    }
}

