/*
 * Decompiled with CFR 0.152.
 */
package com.irisvalet.android.apps.mobilevalethelper.object;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.annotations.SerializedName;
import com.irisvalet.android.apps.mobilevalethelper.object.BaseObject;
import com.irisvalet.android.apps.mobilevalethelper.object.Modifier;
import com.irisvalet.android.apps.mobilevalethelper.object.ModifierOption;
import java.util.ArrayList;

public class SubModifier
extends BaseObject
implements Parcelable {
    @SerializedName(value="name")
    public String name = null;
    @SerializedName(value="code")
    public String code = null;
    @SerializedName(value="type")
    public String type = null;
    @SerializedName(value="isRequired")
    public boolean isRequired = false;
    @SerializedName(value="maximumQuantity")
    public int maximumQuantity = 0;
    @SerializedName(value="modifierOptions")
    public ArrayList<ModifierOption> modifierOptions = null;
    public String value = null;
    public boolean expanded = false;
    public static final Parcelable.Creator<SubModifier> CREATOR = new Parcelable.Creator<SubModifier>(){

        public SubModifier createFromParcel(Parcel in) {
            return new SubModifier(in);
        }

        public SubModifier[] newArray(int size) {
            return new SubModifier[size];
        }
    };

    public SubModifier() {
    }

    public SubModifier(SubModifier item) {
        this.name = item.name;
        this.code = item.code;
        this.type = item.type;
        this.isRequired = item.isRequired;
        this.value = item.value;
        this.expanded = false;
        this.maximumQuantity = item.maximumQuantity;
        if (item.modifierOptions != null && item.modifierOptions.size() > 0) {
            this.modifierOptions = new ArrayList();
            for (ModifierOption option : item.modifierOptions) {
                ModifierOption newOption = new ModifierOption(option);
                this.modifierOptions.add(newOption);
            }
        }
    }

    protected SubModifier(Parcel in) {
        this.name = in.readString();
        this.code = in.readString();
        this.type = in.readString();
        this.isRequired = in.readByte() != 0;
        this.maximumQuantity = in.readInt();
        this.modifierOptions = in.createTypedArrayList(ModifierOption.CREATOR);
        this.value = in.readString();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.name);
        dest.writeString(this.code);
        dest.writeString(this.type);
        dest.writeByte((byte)(this.isRequired ? 1 : 0));
        dest.writeInt(this.maximumQuantity);
        dest.writeTypedList(this.modifierOptions);
        dest.writeString(this.value);
    }

    public int describeContents() {
        return 0;
    }

    public boolean checkMaxQuantityOptions(Modifier modifier) {
        if (this.optionAlreadySelected()) {
            return true;
        }
        if (!modifier.checkMaxQuantityOptions()) {
            return false;
        }
        if (this.maximumQuantity == 0) {
            return true;
        }
        if (this.modifierOptions == null || this.modifierOptions.size() == 0) {
            return false;
        }
        int optionsSelected = 0;
        for (ModifierOption mo : this.modifierOptions) {
            optionsSelected += mo.quantity;
        }
        return optionsSelected < this.maximumQuantity;
    }

    private boolean optionAlreadySelected() {
        if (this.modifierOptions != null && this.modifierOptions.size() > 0) {
            for (ModifierOption option : this.modifierOptions) {
                if (option.quantity <= 0) continue;
                return true;
            }
        }
        return false;
    }
}

