/*
 * Decompiled with CFR 0.152.
 */
package com.irisvalet.android.apps.mobilevalethelper.service;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.irisvalet.android.apps.mobilevalethelper.CartManager;
import com.irisvalet.android.apps.mobilevalethelper.ContentManager;
import com.irisvalet.android.apps.mobilevalethelper.GuestManager;
import com.irisvalet.android.apps.mobilevalethelper.LanguagesManager;
import com.irisvalet.android.apps.mobilevalethelper.ServiceManager;
import com.irisvalet.android.apps.mobilevalethelper.api.ApiClient;
import com.irisvalet.android.apps.mobilevalethelper.api.ApiInterface;
import com.irisvalet.android.apps.mobilevalethelper.exception.SessionExpiredException;
import com.irisvalet.android.apps.mobilevalethelper.service.BaseIntentService;
import com.irisvalet.android.apps.mobilevalethelper.service.ContentVisibilityByRoom;
import com.irisvalet.android.apps.mobilevalethelper.service.api_calls.AssetAPICalls;
import com.irisvalet.android.apps.mobilevalethelper.service.api_calls.CartAPICalls;
import com.irisvalet.android.apps.mobilevalethelper.service.api_calls.ConversationsAPICalls;
import com.irisvalet.android.apps.mobilevalethelper.service.api_calls.GuestProfileAPICalls;
import com.irisvalet.android.apps.mobilevalethelper.service.api_calls.OrderHistoryAPICall;
import com.irisvalet.android.apps.mobilevalethelper.service.api_calls.SectionEncryptedURL;
import com.irisvalet.android.apps.mobilevalethelper.service.api_calls.ServiceRequestAPICalls;
import com.irisvalet.android.apps.mobilevalethelper.service.api_calls.SessionInitialise;
import com.irisvalet.android.apps.mobilevalethelper.utils.DebugLog;
import com.irisvalet.android.apps.mobilevalethelper.utils.TranslationUtils;
import retrofit2.Retrofit;

public class AssetApiIntentService
extends BaseIntentService {
    private static ApiInterface apiService = null;
    private static String propertyCode = null;
    private static String deviceID = null;
    private static String room = null;
    private static String pin = null;
    static int guestId = 0;
    private static String outletCode = null;
    static String sectionCode = null;
    static String comments = null;
    private static boolean serviceInProgress = false;
    static String messageCode = null;
    static String conversationCode = null;
    static String messageContent = null;

    public AssetApiIntentService() {
        super("AssetApiIntentService");
    }

    @Override
    public void onCreate() {
        super.onCreate();
    }

    @Override
    protected void onHandleIntent(Intent workIntent) {
        Retrofit client;
        if (serviceInProgress) {
            return;
        }
        if (this.mContext == null) {
            this.mContext = this.getApplicationContext();
        }
        if (this.mContext == null || workIntent == null || !this.isOnline()) {
            GuestManager.onConnectionFailed();
            return;
        }
        propertyCode = ContentManager.getPropertyCode();
        if (propertyCode == null) {
            new Exception("Property code missing").printStackTrace();
            return;
        }
        String action = workIntent.getStringExtra("ACTION");
        deviceID = workIntent.getStringExtra("DEVICE_ID");
        room = workIntent.getStringExtra("ROOM");
        pin = workIntent.getStringExtra("PIN");
        messageCode = workIntent.getStringExtra("MESSAGE_CODE");
        conversationCode = workIntent.getStringExtra("CONVERSATION_CODE");
        messageContent = workIntent.getStringExtra("MESSAGE_CONTENT");
        outletCode = workIntent.getStringExtra("OUTLET_CODE");
        sectionCode = workIntent.getStringExtra("SECTION_CODE");
        comments = workIntent.getStringExtra("GUEST_COMMENTS");
        guestId = workIntent.getIntExtra("GUEST_ID", 0);
        String sessionToken = ContentManager.getContentSessionToken();
        if (apiService == null && (client = ApiClient.getClient()) != null) {
            apiService = (ApiInterface)client.create(ApiInterface.class);
        }
        serviceInProgress = true;
        if (sessionToken == null || action.equals("initializeSessionByAssetKey")) {
            SessionInitialise.initializeSession(this.mContext, apiService, propertyCode, LanguagesManager.getSelectedLanguageCode());
        }
        if ((sessionToken = ContentManager.getContentSessionToken()) != null) {
            this.runAPICall(sessionToken, action);
        } else {
            GuestManager.onConnectionFailed();
        }
        serviceInProgress = false;
    }

    private void runAPICall(String sessionToken, String action) {
        DebugLog.d(this.TAG, "runAPICall " + action + ": " + sessionToken);
        if (TextUtils.isEmpty((CharSequence)action)) {
            return;
        }
        switch (action) {
            case "pairDeviceToRoom": {
                try {
                    AssetAPICalls.runPairAssetToRoom((Context)this, apiService, sessionToken, propertyCode, room, deviceID, pin);
                }
                catch (SessionExpiredException e) {
                    e.printStackTrace();
                    if (SessionInitialise.initializeSession(this.mContext, apiService, propertyCode, LanguagesManager.getSelectedLanguageCode())) {
                        sessionToken = ContentManager.getContentSessionToken();
                        try {
                            AssetAPICalls.runPairAssetToRoom((Context)this, apiService, sessionToken, propertyCode, room, deviceID, pin);
                        }
                        catch (SessionExpiredException e1) {
                            e1.printStackTrace();
                        }
                        break;
                    }
                    GuestManager.onDevicePairingFailed("Device pairing failed");
                }
                break;
            }
            case "runGetGuestProfile": {
                try {
                    sessionToken = ContentManager.getContentSessionToken();
                    GuestProfileAPICalls.runGetGuestProfile(this.mContext, apiService, sessionToken);
                }
                catch (SessionExpiredException e) {
                    e.printStackTrace();
                    if (!SessionInitialise.initializeSession(this.mContext, apiService, propertyCode, LanguagesManager.getSelectedLanguageCode())) break;
                    sessionToken = ContentManager.getContentSessionToken();
                    try {
                        GuestProfileAPICalls.runGetGuestProfile(this.mContext, apiService, sessionToken);
                    }
                    catch (SessionExpiredException e1) {
                        e1.printStackTrace();
                    }
                }
                break;
            }
            case "getConversations": {
                int unreadMessages = 0;
                try {
                    unreadMessages = ConversationsAPICalls.getConversations(this.mContext, apiService, sessionToken);
                }
                catch (SessionExpiredException e) {
                    e.printStackTrace();
                    if (SessionInitialise.initializeSession(this.mContext, apiService, propertyCode, LanguagesManager.getSelectedLanguageCode())) {
                        sessionToken = ContentManager.getContentSessionToken();
                        try {
                            unreadMessages = ConversationsAPICalls.getConversations(this.mContext, apiService, sessionToken);
                        }
                        catch (SessionExpiredException e1) {
                            e1.printStackTrace();
                            GuestManager.onConnectionFailed();
                        }
                    }
                    GuestManager.onGuestConversationsFailed("initializeSessionTokenByAsset Error");
                }
                GuestManager.onGuestConversationsSuccess(unreadMessages);
                break;
            }
            case "sendMessage": {
                try {
                    ConversationsAPICalls.sendMessage(this.mContext, apiService, sessionToken, conversationCode, messageContent);
                }
                catch (SessionExpiredException e) {
                    e.printStackTrace();
                    if (SessionInitialise.initializeSession(this.mContext, apiService, propertyCode, LanguagesManager.getSelectedLanguageCode())) {
                        sessionToken = ContentManager.getContentSessionToken();
                        try {
                            ConversationsAPICalls.sendMessage(this.mContext, apiService, sessionToken, conversationCode, messageContent);
                        }
                        catch (SessionExpiredException e1) {
                            e1.printStackTrace();
                            GuestManager.onConnectionFailed();
                        }
                        break;
                    }
                    GuestManager.onSendMessageFailed("initializeSessionTokenByAsset Error");
                }
                break;
            }
            case "createConversation": {
                try {
                    ConversationsAPICalls.createConversation(this.mContext, apiService, sessionToken, outletCode, messageContent);
                }
                catch (SessionExpiredException e) {
                    e.printStackTrace();
                    if (SessionInitialise.initializeSession(this.mContext, apiService, propertyCode, LanguagesManager.getSelectedLanguageCode())) {
                        sessionToken = ContentManager.getContentSessionToken();
                        try {
                            ConversationsAPICalls.createConversation(this.mContext, apiService, sessionToken, outletCode, messageContent);
                        }
                        catch (SessionExpiredException e1) {
                            e1.printStackTrace();
                            GuestManager.onConnectionFailed();
                        }
                        break;
                    }
                    GuestManager.onCreateConversationFailed("initializeSessionTokenByAsset Error");
                }
                break;
            }
            case "markMessageAsRead": {
                try {
                    ConversationsAPICalls.markMessageAsRead(this.mContext, apiService, sessionToken, messageCode);
                }
                catch (SessionExpiredException e) {
                    e.printStackTrace();
                    if (!SessionInitialise.initializeSession(this.mContext, apiService, propertyCode, LanguagesManager.getSelectedLanguageCode())) break;
                    sessionToken = ContentManager.getContentSessionToken();
                    try {
                        ConversationsAPICalls.markMessageAsRead(this.mContext, apiService, sessionToken, messageCode);
                    }
                    catch (SessionExpiredException e1) {
                        e1.printStackTrace();
                        GuestManager.onConnectionFailed();
                    }
                }
                break;
            }
            case "addItemsToBasket": {
                try {
                    CartAPICalls.runAddItemsToBasket(this.mContext, apiService, sessionToken, outletCode);
                }
                catch (SessionExpiredException e) {
                    e.printStackTrace();
                    if (SessionInitialise.initializeSession(this.mContext, apiService, propertyCode, LanguagesManager.getSelectedLanguageCode())) {
                        sessionToken = ContentManager.getContentSessionToken();
                        try {
                            CartAPICalls.runAddItemsToBasket(this.mContext, apiService, sessionToken, outletCode);
                        }
                        catch (SessionExpiredException e1) {
                            e1.printStackTrace();
                            GuestManager.onConnectionFailed();
                        }
                        break;
                    }
                    CartManager.onPostBasketFailed(this.mContext, outletCode, "Unknown error");
                }
                break;
            }
            case "placeGuestOrder": {
                try {
                    CartAPICalls.placeGuestOrder(this.mContext, apiService, sessionToken, outletCode, false);
                }
                catch (SessionExpiredException e) {
                    e.printStackTrace();
                    if (SessionInitialise.initializeSession(this.mContext, apiService, propertyCode, LanguagesManager.getSelectedLanguageCode())) {
                        sessionToken = ContentManager.getContentSessionToken();
                        try {
                            CartAPICalls.placeGuestOrder(this.mContext, apiService, sessionToken, outletCode, false);
                        }
                        catch (SessionExpiredException e1) {
                            e1.printStackTrace();
                            GuestManager.onConnectionFailed();
                        }
                        break;
                    }
                    CartManager.onPostBasketFailed(this.mContext, outletCode, "Unknown error");
                }
                break;
            }
            case "placeGuestServiceRequest": {
                try {
                    ServiceRequestAPICalls.placeGuestServiceRequest(this.mContext, apiService, sessionToken, outletCode, comments);
                }
                catch (SessionExpiredException e) {
                    e.printStackTrace();
                    if (SessionInitialise.initializeSession(this.mContext, apiService, propertyCode, LanguagesManager.getSelectedLanguageCode())) {
                        sessionToken = ContentManager.getContentSessionToken();
                        try {
                            ServiceRequestAPICalls.placeGuestServiceRequest(this.mContext, apiService, sessionToken, outletCode, comments);
                        }
                        catch (SessionExpiredException e1) {
                            e1.printStackTrace();
                            GuestManager.onConnectionFailed();
                        }
                        break;
                    }
                    ServiceManager.onPostServiceRequestFailed(this.mContext, TranslationUtils.getTranslatedString("valet_shared_label.error_occured"));
                }
                break;
            }
            case "getOrderHistory": {
                try {
                    OrderHistoryAPICall.getOrderHistory(this.mContext, apiService, sessionToken);
                }
                catch (SessionExpiredException e) {
                    e.printStackTrace();
                    if (SessionInitialise.initializeSession(this.mContext, apiService, propertyCode, LanguagesManager.getSelectedLanguageCode())) {
                        sessionToken = ContentManager.getContentSessionToken();
                        try {
                            OrderHistoryAPICall.getOrderHistory(this.mContext, apiService, sessionToken);
                        }
                        catch (SessionExpiredException e1) {
                            e1.printStackTrace();
                            GuestManager.onConnectionFailed();
                        }
                        break;
                    }
                    GuestManager.onGuestOrderHistoryFailed("initializeSessionTokenByAsset Error");
                }
                break;
            }
            case "getSectionEncryptedURL": {
                try {
                    SectionEncryptedURL.getSectionEncryptedURL(this.mContext, apiService, sectionCode, sessionToken);
                }
                catch (SessionExpiredException e) {
                    e.printStackTrace();
                    if (SessionInitialise.initializeSession(this.mContext, apiService, propertyCode, LanguagesManager.getSelectedLanguageCode())) {
                        sessionToken = ContentManager.getContentSessionToken();
                        try {
                            SectionEncryptedURL.getSectionEncryptedURL(this.mContext, apiService, sectionCode, sessionToken);
                        }
                        catch (SessionExpiredException e1) {
                            e1.printStackTrace();
                            GuestManager.onConnectionFailed();
                        }
                        break;
                    }
                    GuestManager.onSectionEncryptedURLFailed("initializeSessionTokenByAsset Error");
                }
                break;
            }
            case "getGuestContent": {
                if (guestId <= 0 || !ContentVisibilityByRoom.downloadContentByRoom(this.mContext, apiService, propertyCode, LanguagesManager.getSelectedLanguageCode(), ContentManager.getContentVersionNumber(), guestId)) break;
                GuestManager.onContentReady();
            }
        }
        serviceInProgress = false;
    }
}

