/*
 * Decompiled with CFR 0.152.
 */
package com.irisvalet.android.apps.mobilevalethelper.service;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.text.TextUtils;
import androidx.core.app.NotificationCompat;
import com.irisvalet.android.apps.mobilevalethelper.ContentManager;
import com.irisvalet.android.apps.mobilevalethelper.GuestManager;
import com.irisvalet.android.apps.mobilevalethelper.LanguagesManager;
import com.irisvalet.android.apps.mobilevalethelper.R;
import com.irisvalet.android.apps.mobilevalethelper.api.ApiClient;
import com.irisvalet.android.apps.mobilevalethelper.api.ApiInterface;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.ContentVersionResponse;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.GuestProfileResponseDetailsProfileContent;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.HomePageResponse;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.OutletDeliveryLocationsResponse;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.OutletDeliveryLocationsResponseDetailsLocationsContent;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.OutletSettingsResponse;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.OutletsResponse;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.SectionsResponse;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.StaticContentResponse;
import com.irisvalet.android.apps.mobilevalethelper.exception.SessionExpiredException;
import com.irisvalet.android.apps.mobilevalethelper.object.DeliveryLocationArea;
import com.irisvalet.android.apps.mobilevalethelper.object.Outlet;
import com.irisvalet.android.apps.mobilevalethelper.object.OutletSettings;
import com.irisvalet.android.apps.mobilevalethelper.service.BaseIntentService;
import com.irisvalet.android.apps.mobilevalethelper.service.ContentVisibilityByRoom;
import com.irisvalet.android.apps.mobilevalethelper.service.api_calls.ResponseHandler;
import com.irisvalet.android.apps.mobilevalethelper.service.api_calls.SessionInitialise;
import com.irisvalet.android.apps.mobilevalethelper.service.api_calls.SettingsAPICalls;
import com.irisvalet.android.apps.mobilevalethelper.utils.DatabaseBackupUtils;
import com.irisvalet.android.apps.mobilevalethelper.utils.DebugLog;
import com.irisvalet.android.apps.mobilevalethelper.utils.TranslationUtils;
import java.io.IOException;
import java.util.ArrayList;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.Retrofit;

public class ContentIntentService
extends BaseIntentService {
    private static ApiInterface apiService = null;
    private static String action = null;
    private static String propertyCode = null;
    private static String outletCode = null;
    private static boolean downloadDataInProgress = false;
    private static boolean updateLanguageInProgress = false;
    private int storedVersion = 0;
    private int liveVersion = 0;
    private boolean draftVersion = false;

    public ContentIntentService() {
        super("ContentIntentService");
    }

    @Override
    public void onCreate() {
        super.onCreate();
        if (Build.VERSION.SDK_INT >= 26) {
            String CHANNEL_ID = "my_channel_01";
            NotificationChannel channel = new NotificationChannel(CHANNEL_ID, (CharSequence)"iRiS Content update", 2);
            channel.setSound(null, null);
            channel.enableLights(false);
            channel.enableVibration(false);
            try {
                ((NotificationManager)this.getSystemService("notification")).createNotificationChannel(channel);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Notification notification = new NotificationCompat.Builder((Context)this, CHANNEL_ID).setContentTitle((CharSequence)"Content update Service").setSmallIcon(R.drawable.ic_stat_autorenew).setBadgeIconType(R.drawable.ic_stat_autorenew).setOnlyAlertOnce(true).setContentText((CharSequence)"Content update in progress...").build();
            this.startForeground(1, notification);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void onHandleIntent(Intent workIntent) {
        DebugLog.d(this.TAG, "onHandleIntent");
        if (this.mContext == null) {
            this.mContext = this.getApplicationContext();
        }
        if (workIntent == null || !this.isOnline()) {
            GuestManager.onConnectionFailed();
            return;
        }
        ContentIntentService.action = workIntent.getStringExtra("ACTION");
        ContentIntentService.propertyCode = ContentManager.getPropertyCode();
        if (ContentIntentService.propertyCode == null) {
            try {
                throw new Exception("Property code missing");
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        languageCode = workIntent.getStringExtra("LANGUAGE_CODE");
        if (languageCode == null) {
            languageCode = LanguagesManager.getSelectedLanguageCode();
        }
        ContentIntentService.outletCode = workIntent.getStringExtra("OUTLET_CODE");
        if (TextUtils.isEmpty((CharSequence)ContentManager.getAppToken())) {
            GuestManager.onAppTokenMissing();
            return;
        }
        if (ContentIntentService.apiService == null && (client = ApiClient.getClient()) != null) {
            ContentIntentService.apiService = (ApiInterface)client.create(ApiInterface.class);
        }
        if (ContentIntentService.apiService == null) {
            GuestManager.onConnectionFailed();
            return;
        }
        DebugLog.d(this.TAG, "ContentIntentService runAPICall for property " + ContentIntentService.propertyCode + ", action = " + ContentIntentService.action);
        var3_4 = ContentIntentService.action;
        var4_5 = -1;
        switch (var3_4.hashCode()) {
            case -929520179: {
                if (!var3_4.equals("SessionInitialise")) break;
                var4_5 = 0;
                break;
            }
            case -69388848: {
                if (!var3_4.equals("getOutlets")) break;
                var4_5 = 1;
                break;
            }
            case 1609877494: {
                if (!var3_4.equals("getOutletContent")) break;
                var4_5 = 2;
                break;
            }
            case -1424695124: {
                if (!var3_4.equals("doUpdateLanguage")) break;
                var4_5 = 3;
            }
        }
        switch (var4_5) {
            case 0: 
            case 1: {
                if (ContentIntentService.downloadDataInProgress) ** GOTO lbl106
                ContentIntentService.downloadDataInProgress = true;
                if (ContentManager.getContentSessionToken() == null && !SessionInitialise.initializeSession(this.mContext, ContentIntentService.apiService, ContentIntentService.propertyCode, languageCode)) {
                    ContentIntentService.downloadDataInProgress = false;
                    GuestManager.onConnectionFailed();
                    return;
                }
                DebugLog.d(this.TAG, "action: " + ContentIntentService.action + ": " + ContentManager.getContentSessionToken());
                getVersion = false;
                try {
                    getVersion = this.getContentVersion();
                }
                catch (SessionExpiredException e) {
                    e.printStackTrace();
                    if (!SessionInitialise.initializeSession(this.mContext, ContentIntentService.apiService, ContentIntentService.propertyCode, languageCode)) ** GOTO lbl67
                    try {
                        getVersion = this.getContentVersion();
                    }
                    catch (SessionExpiredException e1) {
                        e1.printStackTrace();
                    }
                }
lbl67:
                // 4 sources

                if (!getVersion) {
                    GuestManager.onContentFailed("Failed to getVersion");
                    ContentIntentService.downloadDataInProgress = false;
                    return;
                }
                if (this.draftVersion || this.storedVersion == 0 || this.storedVersion != this.liveVersion) {
                    DebugLog.d(this.TAG, "storedVersion != latestVersion");
                    if (!SettingsAPICalls.getSettings(this.mContext, ContentIntentService.apiService, ContentIntentService.propertyCode, languageCode, this.liveVersion)) {
                        GuestManager.onContentFailed("Failed to download Settings");
                        return;
                    }
                    languageToDownload = LanguagesManager.getDefaultLanguage();
                    selectedLanguage = LanguagesManager.getSelectedLanguage();
                    if (selectedLanguage != null) {
                        languageToDownload = selectedLanguage;
                    }
                    if (languageToDownload != null) {
                        if (!SessionInitialise.initializeSession(this.mContext, ContentIntentService.apiService, ContentIntentService.propertyCode, languageToDownload.code)) {
                            GuestManager.onContentFailed("Failed to initializeSession");
                            return;
                        }
                        TranslationUtils.mStaticContentData.clear();
                        ContentManager.mStandardSectionsMap.clear();
                        ContentManager.mGuestSectionsMap.clear();
                        ContentManager.mOutletsMap.clear();
                        ContentManager.mSectionsByCodeMap.clear();
                        ContentManager.mCategoryItemsByCodeMap.clear();
                        ContentManager.mHomePageContentData.clear();
                        ContentManager.mHomePageContentByGuestData.clear();
                        ContentManager.mCategoryItemsMap.clear();
                        ContentManager.mOutletDeliveryLocationAreasMap.clear();
                        if (!this.downloadContentForLanguage(languageToDownload.code)) {
                            GuestManager.onContentFailed("Failed to download content for default language");
                            ContentIntentService.downloadDataInProgress = false;
                            return;
                        }
                        ContentManager.setContentVersionNumber(this.liveVersion);
                        ContentManager.deleteContentForOldVersion(this.liveVersion);
                        DatabaseBackupUtils.backupDatabaseToSD(this.mContext, ContentIntentService.propertyCode);
                        GuestManager.onContentReady();
                        ContentIntentService.downloadDataInProgress = false;
                        return;
                    }
                } else {
                    GuestManager.onContentVersionValid();
                }
lbl106:
                // 3 sources

                ContentIntentService.downloadDataInProgress = false;
                break;
            }
            case 2: {
                if (ContentIntentService.downloadDataInProgress) break;
                ContentIntentService.downloadDataInProgress = true;
                if (ContentIntentService.outletCode == null) ** GOTO lbl131
                if (ContentManager.getContentSessionToken() == null && !SessionInitialise.initializeSession(this.mContext, ContentIntentService.apiService, ContentIntentService.propertyCode, languageCode)) {
                    ContentIntentService.downloadDataInProgress = false;
                    return;
                }
                DebugLog.d(this.TAG, "action: " + ContentIntentService.action + ": " + ContentManager.getContentSessionToken());
                getVersion = false;
                try {
                    getVersion = this.getContentVersion();
                }
                catch (SessionExpiredException e) {
                    e.printStackTrace();
                    if (!SessionInitialise.initializeSession(this.mContext, ContentIntentService.apiService, ContentIntentService.propertyCode, languageCode)) ** GOTO lbl128
                    try {
                        getVersion = this.getContentVersion();
                    }
                    catch (SessionExpiredException e1) {
                        e1.printStackTrace();
                    }
                }
lbl128:
                // 4 sources

                if (getVersion) {
                    this.getOutletContent(LanguagesManager.getSelectedLanguageCode(), ContentIntentService.outletCode);
                }
lbl131:
                // 4 sources

                ContentIntentService.downloadDataInProgress = false;
                break;
            }
            case 3: {
                if (ContentIntentService.updateLanguageInProgress) break;
                ContentIntentService.updateLanguageInProgress = true;
                ContentManager.resetContentSessionToken();
                if (!SessionInitialise.initializeSession(this.mContext, ContentIntentService.apiService, ContentIntentService.propertyCode, languageCode)) {
                    ContentIntentService.updateLanguageInProgress = false;
                    return;
                }
                DebugLog.d(this.TAG, "action: " + ContentIntentService.action + ": " + ContentManager.getContentSessionToken());
                getVersion = false;
                try {
                    getVersion = this.getContentVersion();
                }
                catch (SessionExpiredException e) {
                    e.printStackTrace();
                    if (!SessionInitialise.initializeSession(this.mContext, ContentIntentService.apiService, ContentIntentService.propertyCode, languageCode)) ** GOTO lbl153
                    try {
                        getVersion = this.getContentVersion();
                    }
                    catch (SessionExpiredException e1) {
                        e1.printStackTrace();
                    }
                }
lbl153:
                // 4 sources

                if (getVersion && this.downloadContentForLanguage(languageCode)) {
                    LanguagesManager.setSelectedLanguage(LanguagesManager.getLanguage(languageCode));
                    LanguagesManager.onUpdateLanguageSettingsSucceeded();
                } else {
                    LanguagesManager.onUpdateLanguageSettingsFailed();
                }
                ContentIntentService.updateLanguageInProgress = false;
                break;
            }
            default: {
                DebugLog.e(this.TAG, "Missing action parameter");
            }
        }
    }

    private boolean downloadContentForLanguage(String languageCode) {
        GuestManager.onDownloadProgressUpdate("Downloading Language Content in " + languageCode);
        if (TextUtils.isEmpty((CharSequence)languageCode)) {
            return false;
        }
        if (ContentManager.getContentSessionToken() == null && !SessionInitialise.initializeSession(this.mContext, apiService, propertyCode, languageCode)) {
            return false;
        }
        GuestManager.onDownloadProgressUpdate("Downloading Static content in " + languageCode);
        if (!this.getStaticContent(languageCode)) {
            return false;
        }
        GuestManager.onDownloadProgressUpdate("Downloading Homepage content in " + languageCode);
        if (!this.getHomePageItems(languageCode)) {
            return false;
        }
        GuestManager.onDownloadProgressUpdate("Downloading Standard Sections content in " + languageCode);
        if (!this.getSectionsCategoriesItems(languageCode)) {
            return false;
        }
        GuestProfileResponseDetailsProfileContent profileContent = ContentManager.getGuestProfile();
        if (profileContent != null && profileContent.guestId > 0 && !ContentVisibilityByRoom.downloadContentByRoom(this.mContext, apiService, propertyCode, languageCode, this.liveVersion, profileContent.guestId)) {
            return false;
        }
        if (action.equals("SessionInitialise") || action.equals("doUpdateLanguage") || action.equals("getOutlets")) {
            return this.getOutlets(languageCode);
        }
        if (outletCode != null && action.equals("getOutletContent")) {
            return this.getOutletContent(languageCode, outletCode);
        }
        return false;
    }

    private boolean getContentVersion() throws SessionExpiredException {
        block7: {
            Retrofit client;
            if (apiService == null && (client = ApiClient.getClient()) != null) {
                apiService = (ApiInterface)client.create(ApiInterface.class);
            }
            if (apiService == null) {
                GuestManager.onConnectionFailed();
                return false;
            }
            try {
                ContentVersionResponse response;
                Call<ContentVersionResponse> call = apiService.getContentVersion(GuestManager.getEnvPath(), ContentManager.getContentSessionToken());
                Response r = call.execute();
                DebugLog.d(this.TAG, "getContentVersion (" + r.code() + ") " + ContentManager.getContentSessionToken());
                if (!ResponseHandler.checkResponse((Context)this, r) || (response = (ContentVersionResponse)r.body()) == null || response.responses == null || response.responses.size() <= 0 || response.responses.get(0) == null || response.responses.get((int)0).getContentVersion == null || response.responses.get((int)0).getContentVersion.content == null) break block7;
                this.storedVersion = ContentManager.getContentVersionNumber();
                try {
                    this.draftVersion = response.responses.get((int)0).getContentVersion.content.liveVersion.equals("draft");
                    if (!this.draftVersion) {
                        this.liveVersion = Integer.parseInt(response.responses.get((int)0).getContentVersion.content.liveVersion);
                        ContentManager.setGXPCurrentVersion(this.liveVersion);
                    }
                    ContentManager.setDraftVersion(this.draftVersion);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                DebugLog.d(this.TAG, "draftVersion = " + this.draftVersion);
                DebugLog.d(this.TAG, "liveVersion = " + this.liveVersion);
                DebugLog.d(this.TAG, "storedVersion = " + this.storedVersion);
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        DebugLog.e(this.TAG, "getContentVersion response.errorBody(): Error");
        GuestManager.onContentFailed("Error");
        return false;
    }

    private boolean getStaticContent(String languageCode) {
        Retrofit client;
        if (apiService == null && (client = ApiClient.getClient()) != null) {
            apiService = (ApiInterface)client.create(ApiInterface.class);
        }
        if (apiService == null) {
            GuestManager.onConnectionFailed();
            return false;
        }
        DebugLog.d(this.TAG, "getStaticContent");
        try {
            String sessionToken = ContentManager.getContentSessionToken();
            Call<StaticContentResponse> call = apiService.getStaticContentMessages(GuestManager.getEnvPath(), sessionToken);
            Response r = call.execute();
            if (ResponseHandler.checkResponse((Context)this, r)) {
                StaticContentResponse response = (StaticContentResponse)r.body();
                if (response != null && response.responses != null && response.responses.size() > 0 && response.responses.get(0) != null && response.responses.get((int)0).getStaticContent != null && response.responses.get((int)0).getStaticContent.succeeded && response.responses.get((int)0).getStaticContent.content != null && response.responses.get((int)0).getStaticContent.content.messagesDictionary != null) {
                    ContentManager.setStaticContent(languageCode, this.liveVersion, response.responses.get((int)0).getStaticContent.content.messagesDictionary);
                    return true;
                }
                DebugLog.e(this.TAG, "runGetStaticContent Error");
                GuestManager.onContentFailed("Error");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            GuestManager.onContentFailed(e.getMessage());
        }
        return false;
    }

    private boolean getHomePageItems(String languageCode) {
        Retrofit client;
        if (apiService == null && (client = ApiClient.getClient()) != null) {
            apiService = (ApiInterface)client.create(ApiInterface.class);
        }
        if (apiService == null) {
            GuestManager.onConnectionFailed();
            return false;
        }
        DebugLog.d(this.TAG, "getHomePageItems");
        try {
            HomePageResponse response;
            Call<HomePageResponse> call = apiService.getHomepage(GuestManager.getEnvPath(), ContentManager.getContentSessionToken());
            Response r = call.execute();
            if (ResponseHandler.checkResponse((Context)this, r) && (response = (HomePageResponse)r.body()) != null && response.responses != null && response.responses.size() > 0 && response.responses.get(0) != null && response.responses.get((int)0).getHomepage != null && response.responses.get((int)0).getHomepage.succeeded && response.responses.get((int)0).getHomepage.content != null) {
                ContentManager.setHomePageContent(languageCode, this.liveVersion, response.responses.get((int)0).getHomepage.content);
                GuestManager.onHomePageContentReady();
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DebugLog.e(this.TAG, "getHomePageItems Error");
        GuestManager.onContentFailed("Error");
        return false;
    }

    private boolean getSectionsCategoriesItems(String languageCode) {
        Retrofit client;
        if (apiService == null && (client = ApiClient.getClient()) != null) {
            apiService = (ApiInterface)client.create(ApiInterface.class);
        }
        if (apiService == null) {
            GuestManager.onConnectionFailed();
            return false;
        }
        DebugLog.d(this.TAG, "getSectionsCategoriesItems");
        try {
            SectionsResponse response;
            Call<SectionsResponse> call = apiService.getSectionsCategoriesItems(GuestManager.getEnvPath(), ContentManager.getContentSessionToken());
            Response r = call.execute();
            if (ResponseHandler.checkResponse((Context)this, r) && (response = (SectionsResponse)r.body()) != null && response.responses != null && response.responses.size() > 0 && response.responses.get(0) != null && response.responses.get((int)0).getSectionsCategoriesItems != null && response.responses.get((int)0).getSectionsCategoriesItems.content != null && response.responses.get((int)0).getSectionsCategoriesItems.content.sections != null && response.responses.get((int)0).getSectionsCategoriesItems.content.sections.size() > 0) {
                ContentManager.setSectionsCategoryItems(languageCode, this.liveVersion, "0", response.responses.get((int)0).getSectionsCategoriesItems.content, 0);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DebugLog.e(this.TAG, "getSectionsCategoriesItems response.errorBody(): Error");
        GuestManager.onContentFailed("Error");
        return false;
    }

    private boolean getOutlets(String languageCode) {
        Retrofit client;
        DebugLog.d(this.TAG, "getOutlets");
        if (apiService == null && (client = ApiClient.getClient()) != null) {
            apiService = (ApiInterface)client.create(ApiInterface.class);
        }
        if (apiService == null) {
            GuestManager.onConnectionFailed();
            return false;
        }
        DebugLog.d(this.TAG, "getOutlets");
        GuestManager.onDownloadProgressUpdate("Downloading Outlet content in " + languageCode);
        try {
            Call<OutletsResponse> call = apiService.getOutlets(GuestManager.getEnvPath(), ContentManager.getContentSessionToken());
            Response r = call.execute();
            if (ResponseHandler.checkResponse((Context)this, r)) {
                OutletsResponse response = (OutletsResponse)r.body();
                DebugLog.d(this.TAG, "getOutlets onResponse");
                if (response != null && response.responses != null && response.responses.size() > 0 && response.responses.get(0) != null && response.responses.get((int)0).getOutlets != null && response.responses.get((int)0).getOutlets.succeeded && response.responses.get((int)0).getOutlets.content != null && response.responses.get((int)0).getOutlets.content.outlets != null && response.responses.get((int)0).getOutlets.content.outlets.size() >= 0) {
                    boolean result = true;
                    for (Outlet o : response.responses.get((int)0).getOutlets.content.outlets) {
                        DebugLog.d(this.TAG, "getOutlets onResponse - Storing Outlet " + o.name + " code: " + o.code);
                        o.versionNumber = this.liveVersion;
                        o.propertyCode = propertyCode;
                        if (o.outletSettings == null) {
                            o.outletSettings = ContentManager.getOutletSettings(o.code);
                        }
                        if (o.outletSettings == null) {
                            o.outletSettings = this.getOutletSettings(o.code);
                        }
                        if (o.outletSettings != null) {
                            ContentManager.setOutletSettings(ContentManager.getPropertyCode(), this.liveVersion, o.code, o.outletSettings);
                        }
                        if (o.deliveryLocationAreas == null) {
                            o.deliveryLocationAreas = ContentManager.getOutletDeliveryAreas(o.code);
                        }
                        if (o.deliveryLocationAreas == null) {
                            o.deliveryLocationAreas = this.getOutletDeliveryAreas(o.code);
                        }
                        if (o.deliveryLocationAreas != null) {
                            OutletDeliveryLocationsResponseDetailsLocationsContent content = new OutletDeliveryLocationsResponseDetailsLocationsContent();
                            content.deliveryLocationAreas = o.deliveryLocationAreas;
                            o.deliveryLocationAreas = content.deliveryLocationAreas;
                            ContentManager.setOutletDeliveryAreas(propertyCode, languageCode, this.liveVersion, o.code, content);
                        }
                        GuestManager.onDownloadProgressUpdate("Downloading Outlet content for outlet " + o.name + " in " + languageCode);
                        result = result && this.getOutletContent(languageCode, o.code);
                    }
                    ContentManager.setOutlets(languageCode, this.liveVersion, response.responses.get((int)0).getOutlets.content);
                    return result;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DebugLog.e(this.TAG, "getOutlets Error");
        GuestManager.onContentFailed("Error");
        return false;
    }

    private OutletSettings getOutletSettings(String outletCode) {
        Retrofit client;
        DebugLog.d(this.TAG, "getOutletSettings outletCode: " + outletCode);
        if (apiService == null && (client = ApiClient.getClient()) != null) {
            apiService = (ApiInterface)client.create(ApiInterface.class);
        }
        if (apiService == null) {
            GuestManager.onConnectionFailed();
            return null;
        }
        DebugLog.d(this.TAG, "getOutlets");
        try {
            OutletSettingsResponse response;
            Call<OutletSettingsResponse> call = apiService.getOutletSettings(GuestManager.getEnvPath(), outletCode, ContentManager.getContentSessionToken());
            Response r = call.execute();
            if (ResponseHandler.checkResponse((Context)this, r) && (response = (OutletSettingsResponse)r.body()) != null && response.responses != null && response.responses.size() > 0 && response.responses.get(0) != null && response.responses.get((int)0).getOutletSettings != null && response.responses.get((int)0).getOutletSettings.succeeded && response.responses.get((int)0).getOutletSettings.content != null && response.responses.get((int)0).getOutletSettings.content.outletSettings != null && response.responses.get((int)0).getOutletSettings.content.outletSettings.size() > 0) {
                return response.responses.get((int)0).getOutletSettings.content.outletSettings.get(0);
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            DebugLog.e(this.TAG, "getOutletSettings Error");
            return null;
        }
    }

    private ArrayList<DeliveryLocationArea> getOutletDeliveryAreas(String outletCode) {
        Retrofit client;
        if (apiService == null && (client = ApiClient.getClient()) != null) {
            apiService = (ApiInterface)client.create(ApiInterface.class);
        }
        if (apiService == null) {
            GuestManager.onConnectionFailed();
            return null;
        }
        DebugLog.d(this.TAG, "getOutletDeliveryLocations");
        try {
            OutletDeliveryLocationsResponse response;
            Call<OutletDeliveryLocationsResponse> call = apiService.getOutletDeliveryLocations(GuestManager.getEnvPath(), outletCode, outletCode, ContentManager.getContentSessionToken());
            Response r = call.execute();
            if (ResponseHandler.checkResponse((Context)this, r) && (response = (OutletDeliveryLocationsResponse)r.body()) != null && response.responses != null && response.responses.size() > 0 && response.responses.get(0) != null && response.responses.get((int)0).getOutlets != null && response.responses.get((int)0).getOutlets.succeeded && response.responses.get((int)0).getOutlets.content != null && response.responses.get((int)0).getOutlets.content.deliveryLocationAreas != null && response.responses.get((int)0).getOutlets.content.deliveryLocationAreas.size() > 0 && response.responses.get((int)0).getOutlets.content.deliveryLocationAreas.get(0) != null) {
                return response.responses.get((int)0).getOutlets.content.deliveryLocationAreas;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DebugLog.e(this.TAG, "getOutletDeliveryLocations Error");
        return null;
    }

    private boolean getOutletContent(String languageCode, String outletCode) {
        Retrofit client;
        if (apiService == null && (client = ApiClient.getClient()) != null) {
            apiService = (ApiInterface)client.create(ApiInterface.class);
        }
        if (apiService == null) {
            GuestManager.onConnectionFailed();
            return false;
        }
        DebugLog.d(this.TAG, "getOutletContent outletCode: " + outletCode);
        try {
            SectionsResponse response;
            Call<SectionsResponse> call = apiService.getOutletContent(GuestManager.getEnvPath(), outletCode, outletCode, ContentManager.getContentSessionToken());
            Response r = call.execute();
            if (ResponseHandler.checkResponse((Context)this, r) && (response = (SectionsResponse)r.body()) != null && response.responses != null && response.responses.size() > 0 && response.responses.get(0) != null && response.responses.get((int)0).getOutletSectionsCategoriesItems != null && response.responses.get((int)0).getOutletSectionsCategoriesItems.succeeded && response.responses.get((int)0).getOutletSectionsCategoriesItems.content != null) {
                ContentManager.setSectionsCategoryItems(languageCode, this.liveVersion, outletCode, response.responses.get((int)0).getOutletSectionsCategoriesItems.content, 0);
                GuestManager.onOutletContentReady();
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

