/*
 * Decompiled with CFR 0.152.
 */
package com.irisvalet.android.apps.mobilevalethelper.service;

import android.content.Context;
import com.irisvalet.android.apps.mobilevalethelper.ContentManager;
import com.irisvalet.android.apps.mobilevalethelper.GuestManager;
import com.irisvalet.android.apps.mobilevalethelper.api.ApiClient;
import com.irisvalet.android.apps.mobilevalethelper.api.ApiInterface;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.HomePageResponse;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.SectionsResponse;
import com.irisvalet.android.apps.mobilevalethelper.exception.SessionExpiredException;
import com.irisvalet.android.apps.mobilevalethelper.service.api_calls.ResponseHandler;
import com.irisvalet.android.apps.mobilevalethelper.service.api_calls.SessionInitialise;
import com.irisvalet.android.apps.mobilevalethelper.utils.DebugLog;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.Retrofit;

public class ContentVisibilityByRoom {
    private static final String TAG = "ContentVisibilityByRoom";

    static boolean downloadContentByRoom(Context context, ApiInterface apiService, String propertyCode, String languageCode, int versionNumber, int guestId) {
        block13: {
            block12: {
                try {
                    GuestManager.onDownloadProgressUpdate("Downloading Homepage By Room content in " + languageCode);
                    if (!ContentVisibilityByRoom.getHomepageByGuest(context, apiService, ContentManager.getContentSessionToken(), languageCode, versionNumber, guestId)) {
                        return false;
                    }
                }
                catch (SessionExpiredException e) {
                    e.printStackTrace();
                    if (!SessionInitialise.initializeSession(context, apiService, propertyCode, languageCode)) break block12;
                    try {
                        if (!ContentVisibilityByRoom.getHomepageByGuest(context, apiService, ContentManager.getContentSessionToken(), languageCode, versionNumber, guestId)) {
                            return false;
                        }
                    }
                    catch (SessionExpiredException e1) {
                        e1.printStackTrace();
                        return false;
                    }
                }
            }
            try {
                GuestManager.onDownloadProgressUpdate("Downloading Sections By Room content in " + languageCode);
                if (!ContentVisibilityByRoom.getSectionsByRoom(context, apiService, ContentManager.getContentSessionToken(), languageCode, versionNumber, guestId)) {
                    return false;
                }
            }
            catch (SessionExpiredException e) {
                e.printStackTrace();
                if (!SessionInitialise.initializeSession(context, apiService, propertyCode, languageCode)) break block13;
                try {
                    if (!ContentVisibilityByRoom.getSectionsByRoom(context, apiService, ContentManager.getContentSessionToken(), languageCode, versionNumber, guestId)) {
                        return false;
                    }
                }
                catch (SessionExpiredException e1) {
                    e1.printStackTrace();
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean getSectionsByRoom(Context context, ApiInterface apiService, String sessionToken, String languageCode, int versionNumber, int guestId) throws SessionExpiredException {
        Retrofit client;
        if (apiService == null && (client = ApiClient.getClient()) != null) {
            apiService = (ApiInterface)client.create(ApiInterface.class);
        }
        if (apiService == null) {
            GuestManager.onConnectionFailed();
            return false;
        }
        DebugLog.d(TAG, "getSectionVisibilityByRoom guestId: " + guestId);
        try {
            SectionsResponse response;
            Call<SectionsResponse> call = apiService.getSectionsCategoriesItemsByGuest(GuestManager.getEnvPath(), Integer.toString(guestId), sessionToken, Integer.toString(guestId));
            Response r = call.execute();
            if (ResponseHandler.checkResponse(context, r) && (response = (SectionsResponse)r.body()) != null && response.responses != null && response.responses.size() > 0 && response.responses.get(0) != null && response.responses.get((int)0).getSectionsCategoriesItemsByGuest != null && response.responses.get((int)0).getSectionsCategoriesItemsByGuest.succeeded && response.responses.get((int)0).getSectionsCategoriesItemsByGuest.content != null) {
                ContentManager.setSectionsCategoryItems(languageCode, versionNumber, null, response.responses.get((int)0).getSectionsCategoriesItemsByGuest.content, guestId);
                return true;
            }
        }
        catch (Exception e) {
            if (e instanceof SessionExpiredException) {
                throw (SessionExpiredException)e;
            }
            e.printStackTrace();
        }
        return false;
    }

    private static boolean getHomepageByGuest(Context context, ApiInterface apiService, String sessionToken, String languageCode, int versionNumber, int guestId) throws SessionExpiredException {
        try {
            HomePageResponse response;
            Retrofit client;
            if (apiService == null && (client = ApiClient.getClient()) != null) {
                apiService = (ApiInterface)client.create(ApiInterface.class);
            }
            if (apiService == null) {
                GuestManager.onConnectionFailed();
                return false;
            }
            Call<HomePageResponse> call = apiService.getHomepageByGuest(GuestManager.getEnvPath(), Integer.toString(guestId), sessionToken, Integer.toString(guestId));
            Response r = call.execute();
            if (ResponseHandler.checkResponse(context, r) && (response = (HomePageResponse)r.body()) != null && response.responses != null && response.responses.size() > 0 && response.responses.get(0) != null && response.responses.get((int)0).getHomepageByGuest != null && response.responses.get((int)0).getHomepageByGuest.succeeded && response.responses.get((int)0).getHomepageByGuest.content != null) {
                ContentManager.setHomePageContentByGuest(languageCode, versionNumber, response.responses.get((int)0).getHomepageByGuest.content);
                return true;
            }
        }
        catch (Exception e) {
            if (e instanceof SessionExpiredException) {
                throw (SessionExpiredException)e;
            }
            e.printStackTrace();
        }
        return false;
    }
}

