/*
 * Decompiled with CFR 0.152.
 */
package com.irisvalet.android.apps.mobilevalethelper.service;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.irisvalet.android.apps.mobilevalethelper.ContentManager;
import com.irisvalet.android.apps.mobilevalethelper.GuestManager;
import com.irisvalet.android.apps.mobilevalethelper.api.ApiClient;
import com.irisvalet.android.apps.mobilevalethelper.api.ApiInterface;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.ForecastResponse;
import com.irisvalet.android.apps.mobilevalethelper.service.BaseIntentService;
import com.irisvalet.android.apps.mobilevalethelper.service.api_calls.ResponseHandler;
import com.irisvalet.android.apps.mobilevalethelper.utils.DebugLog;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.Retrofit;

public class GeneralApiIntentService
extends BaseIntentService {
    static ApiInterface apiService = null;
    static String propertyCode = null;
    static String baseURL = null;
    static String action = null;

    public GeneralApiIntentService() {
        super("GeneralApiIntentService");
    }

    @Override
    public void onCreate() {
        super.onCreate();
    }

    @Override
    protected void onHandleIntent(Intent workIntent) {
        if (workIntent == null || !this.isOnline()) {
            this.broadcastIntent(this, "com.irisvalet.android.apps.nativemobilevalet.broadcastreceiver.to.activity", 100, 0);
            DebugLog.d(this.TAG, "BROADCAST_TO_ACTIVITY_NO_INTERNET_CONNECTION");
            return;
        }
        if (this.mContext == null) {
            this.mContext = this.getApplicationContext();
        }
        if ((propertyCode = ContentManager.getPropertyCode()) == null) {
            try {
                throw new Exception("Property code missing");
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        baseURL = GuestManager.getBaseURL();
        action = workIntent.getStringExtra("ACTION");
        if (this.mContext != null && !TextUtils.isEmpty((CharSequence)ContentManager.getAppToken())) {
            this.runAPICall();
        } else {
            this.broadcastIntent(this, "com.irisvalet.android.apps.nativemobilevalet.broadcastreceiver.to.activity", 99, 0);
        }
    }

    private void runAPICall() {
        DebugLog.d(this.TAG, "GeneralApiIntentService runAPICall for property " + propertyCode);
        if (action != null && !action.isEmpty()) {
            DebugLog.d(this.TAG, "request = " + action);
            switch (action) {
                case "getForecast": {
                    this.runGetForecast();
                }
            }
        }
    }

    private void runGetForecast() {
        Retrofit client;
        if (apiService == null && (client = ApiClient.getClient()) != null) {
            apiService = (ApiInterface)client.create(ApiInterface.class);
        }
        if (apiService == null) {
            this.broadcastIntent(this, "com.irisvalet.android.apps.nativemobilevalet.broadcastreceiver.to.activity", 100, 0);
            return;
        }
        try {
            ForecastResponse response;
            Call<ForecastResponse> call = apiService.getForecast(GuestManager.getEnvPath(), ContentManager.getContentSessionToken());
            Response r = call.clone().execute();
            DebugLog.d(this.TAG, "runGetForecast (" + r.code() + ") " + ContentManager.getContentSessionToken());
            if (ResponseHandler.checkResponse((Context)this, r) && (response = (ForecastResponse)call.execute().body()) != null && response.responses != null && response.responses.size() > 0 && response.responses.get(0) != null && response.responses.get((int)0).getForecast != null && response.responses.get((int)0).getForecast.content != null && response.responses.get((int)0).getForecast.content.forecast != null && response.responses.get((int)0).getForecast.content.forecast.size() > 0) {
                ContentManager.saveForecast(response.responses.get((int)0).getForecast.content);
                GuestManager.onWeatherUpdated();
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GuestManager.onWeatherDataFailed();
    }
}

