/*
 * Decompiled with CFR 0.152.
 */
package com.irisvalet.android.apps.mobilevalethelper.service;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.irisvalet.android.apps.mobilevalethelper.ContentManager;
import com.irisvalet.android.apps.mobilevalethelper.GuestManager;
import com.irisvalet.android.apps.mobilevalethelper.LanguagesManager;
import com.irisvalet.android.apps.mobilevalethelper.api.ApiClient;
import com.irisvalet.android.apps.mobilevalethelper.api.ApiInterface;
import com.irisvalet.android.apps.mobilevalethelper.api.Requests.CheckInGuestDetails;
import com.irisvalet.android.apps.mobilevalethelper.api.Requests.CheckoutGuestDetails;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.CheckInResponse;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.CheckoutResponse;
import com.irisvalet.android.apps.mobilevalethelper.exception.SessionExpiredException;
import com.irisvalet.android.apps.mobilevalethelper.service.BaseIntentService;
import com.irisvalet.android.apps.mobilevalethelper.service.ContentVisibilityByRoom;
import com.irisvalet.android.apps.mobilevalethelper.service.api_calls.CartAPICalls;
import com.irisvalet.android.apps.mobilevalethelper.service.api_calls.ConversationsAPICalls;
import com.irisvalet.android.apps.mobilevalethelper.service.api_calls.GuestProfileAPICalls;
import com.irisvalet.android.apps.mobilevalethelper.service.api_calls.LoginByRoomAPICall;
import com.irisvalet.android.apps.mobilevalethelper.service.api_calls.OrderHistoryAPICall;
import com.irisvalet.android.apps.mobilevalethelper.service.api_calls.ResponseHandler;
import com.irisvalet.android.apps.mobilevalethelper.service.api_calls.SectionEncryptedURL;
import com.irisvalet.android.apps.mobilevalethelper.service.api_calls.ServiceRequestAPICalls;
import com.irisvalet.android.apps.mobilevalethelper.service.api_calls.SessionInitialise;
import com.irisvalet.android.apps.mobilevalethelper.utils.DebugLog;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.Retrofit;

public class GuestApiIntentService
extends BaseIntentService {
    static ApiInterface apiService = null;
    static String propertyCode = null;
    static String action = null;
    static int guestId = 0;
    static String lastName = null;
    static String bookingReference = null;
    static String roomNumber = null;
    static String outletCode = null;
    static String sectionCode = null;
    static String comments = null;
    private static boolean serviceInProgress = false;
    static String messageCode = null;
    static String conversationCode = null;
    static String messageContent = null;

    public GuestApiIntentService() {
        super("GuestApiIntentService");
    }

    @Override
    public void onCreate() {
        super.onCreate();
    }

    @Override
    protected void onHandleIntent(Intent workIntent) {
        Retrofit client;
        if (serviceInProgress) {
            return;
        }
        if (this.mContext == null) {
            this.mContext = this.getApplicationContext();
        }
        if (this.mContext == null || workIntent == null || !this.isOnline()) {
            GuestManager.onConnectionFailed();
            return;
        }
        propertyCode = ContentManager.getPropertyCode();
        if (propertyCode == null) {
            new Exception("Property code missing").printStackTrace();
            return;
        }
        action = workIntent.getStringExtra("ACTION");
        propertyCode = ContentManager.getPropertyCode();
        lastName = workIntent.getStringExtra("LAST_NAME");
        bookingReference = workIntent.getStringExtra("RESERVATION_NUMBER");
        roomNumber = workIntent.getStringExtra("ROOM");
        messageCode = workIntent.getStringExtra("MESSAGE_CODE");
        conversationCode = workIntent.getStringExtra("CONVERSATION_CODE");
        messageContent = workIntent.getStringExtra("MESSAGE_CONTENT");
        outletCode = workIntent.getStringExtra("OUTLET_CODE");
        sectionCode = workIntent.getStringExtra("SECTION_CODE");
        comments = workIntent.getStringExtra("GUEST_COMMENTS");
        guestId = workIntent.getIntExtra("GUEST_ID", 0);
        if (lastName != null) {
            lastName = lastName.trim();
        }
        if (roomNumber != null) {
            roomNumber = roomNumber.trim();
        }
        if (bookingReference != null) {
            bookingReference = bookingReference.trim();
        }
        String sessionToken = ContentManager.getContentSessionToken();
        if (apiService == null && (client = ApiClient.getClient()) != null) {
            apiService = (ApiInterface)client.create(ApiInterface.class);
        }
        if (apiService == null) {
            GuestManager.onConnectionFailed();
            return;
        }
        serviceInProgress = true;
        if (sessionToken == null) {
            SessionInitialise.initializeSession(this.mContext, apiService, propertyCode, LanguagesManager.getSelectedLanguageCode());
        }
        if ((sessionToken = ContentManager.getContentSessionToken()) != null) {
            this.runAPICall(sessionToken, action);
        } else {
            GuestManager.onConnectionFailed();
        }
        serviceInProgress = false;
    }

    /*
     * Unable to fully structure code
     */
    private void runAPICall(String sessionToken, String action) {
        DebugLog.d(this.TAG, "runAPICall " + action + ": " + sessionToken);
        if (TextUtils.isEmpty((CharSequence)action)) {
            return;
        }
        var3_3 = action;
        var4_4 = -1;
        switch (var3_3.hashCode()) {
            case -1033789218: {
                if (!var3_3.equals("guestLoginRequest")) break;
                var4_4 = 0;
                break;
            }
            case -387746579: {
                if (!var3_3.equals("runCheckInRequest")) break;
                var4_4 = 1;
                break;
            }
            case 1316427870: {
                if (!var3_3.equals("runCheckoutRequest")) break;
                var4_4 = 2;
                break;
            }
            case -61736676: {
                if (!var3_3.equals("runGetGuestProfile")) break;
                var4_4 = 3;
                break;
            }
            case 352153754: {
                if (!var3_3.equals("getConversations")) break;
                var4_4 = 4;
                break;
            }
            case 691453791: {
                if (!var3_3.equals("sendMessage")) break;
                var4_4 = 5;
                break;
            }
            case -1562822753: {
                if (!var3_3.equals("createConversation")) break;
                var4_4 = 6;
                break;
            }
            case -268609022: {
                if (!var3_3.equals("markMessageAsRead")) break;
                var4_4 = 7;
                break;
            }
            case 614055136: {
                if (!var3_3.equals("addItemsToBasket")) break;
                var4_4 = 8;
                break;
            }
            case -1098143555: {
                if (!var3_3.equals("placeGuestOrder")) break;
                var4_4 = 9;
                break;
            }
            case 339790219: {
                if (!var3_3.equals("placeGuestServiceRequest")) break;
                var4_4 = 10;
                break;
            }
            case -851487780: {
                if (!var3_3.equals("getOrderHistory")) break;
                var4_4 = 11;
                break;
            }
            case -1922692774: {
                if (!var3_3.equals("getSectionEncryptedURL")) break;
                var4_4 = 12;
                break;
            }
            case 799108599: {
                if (!var3_3.equals("getGuestContent")) break;
                var4_4 = 13;
            }
        }
        switch (var4_4) {
            case 0: {
                loginSuccess = false;
                try {
                    loginSuccess = LoginByRoomAPICall.runLoginByRoom(this.mContext, GuestApiIntentService.apiService, sessionToken, GuestApiIntentService.lastName, GuestApiIntentService.roomNumber);
                }
                catch (SessionExpiredException e) {
                    e.printStackTrace();
                    if (!SessionInitialise.initializeSession(this.mContext, GuestApiIntentService.apiService, GuestApiIntentService.propertyCode, LanguagesManager.getSelectedLanguageCode())) ** GOTO lbl76
                    try {
                        loginSuccess = LoginByRoomAPICall.runLoginByRoom(this.mContext, GuestApiIntentService.apiService, sessionToken, GuestApiIntentService.lastName, GuestApiIntentService.roomNumber);
                    }
                    catch (SessionExpiredException e1) {
                        e1.printStackTrace();
                    }
                }
lbl76:
                // 4 sources

                if (loginSuccess && (profileContent = ContentManager.getGuestProfile()) != null && profileContent.guestId > 0) {
                    ContentVisibilityByRoom.downloadContentByRoom(this.mContext, GuestApiIntentService.apiService, ContentManager.getPropertyCode(), LanguagesManager.getSelectedLanguageCode(), ContentManager.getContentVersionNumber(), profileContent.guestId);
                    GuestManager.onGuestSignedInSuccess();
                    return;
                }
                GuestManager.onGuestSignedInFailed("Failed to sign in");
                break;
            }
            case 1: {
                try {
                    this.runCheckInGuest(sessionToken);
                }
                catch (SessionExpiredException e) {
                    e.printStackTrace();
                    if (!SessionInitialise.initializeSession(this.mContext, GuestApiIntentService.apiService, GuestApiIntentService.propertyCode, LanguagesManager.getSelectedLanguageCode())) break;
                    try {
                        sessionToken = ContentManager.getContentSessionToken();
                        this.runCheckInGuest(sessionToken);
                    }
                    catch (SessionExpiredException e3) {
                        e3.printStackTrace();
                    }
                }
                break;
            }
            case 2: {
                try {
                    this.runCheckoutGuest(sessionToken);
                }
                catch (SessionExpiredException e) {
                    e.printStackTrace();
                    if (!SessionInitialise.initializeSession(this.mContext, GuestApiIntentService.apiService, GuestApiIntentService.propertyCode, LanguagesManager.getSelectedLanguageCode())) break;
                    try {
                        sessionToken = ContentManager.getContentSessionToken();
                        this.runCheckoutGuest(sessionToken);
                    }
                    catch (SessionExpiredException e3) {
                        e3.printStackTrace();
                    }
                }
                break;
            }
            case 3: {
                try {
                    GuestProfileAPICalls.runGetGuestProfile(this.mContext, GuestApiIntentService.apiService, sessionToken);
                }
                catch (SessionExpiredException e) {
                    e.printStackTrace();
                    SessionInitialise.initializeSession(this.mContext, GuestApiIntentService.apiService, GuestApiIntentService.propertyCode, LanguagesManager.getSelectedLanguageCode());
                }
                break;
            }
            case 4: {
                unreadMessages = 0;
                try {
                    unreadMessages = ConversationsAPICalls.getConversations(this.mContext, GuestApiIntentService.apiService, sessionToken);
                }
                catch (SessionExpiredException e) {
                    e.printStackTrace();
                    if (!SessionInitialise.initializeSession(this.mContext, GuestApiIntentService.apiService, GuestApiIntentService.propertyCode, LanguagesManager.getSelectedLanguageCode())) ** GOTO lbl139
                    try {
                        sessionToken = ContentManager.getContentSessionToken();
                        unreadMessages = ConversationsAPICalls.getConversations(this.mContext, GuestApiIntentService.apiService, sessionToken);
                    }
                    catch (SessionExpiredException e3) {
                        e3.printStackTrace();
                    }
                }
lbl139:
                // 4 sources

                GuestManager.onGuestConversationsSuccess(unreadMessages);
                break;
            }
            case 5: {
                try {
                    ConversationsAPICalls.sendMessage(this.mContext, GuestApiIntentService.apiService, sessionToken, GuestApiIntentService.conversationCode, GuestApiIntentService.messageContent);
                }
                catch (SessionExpiredException e) {
                    e.printStackTrace();
                    if (!SessionInitialise.initializeSession(this.mContext, GuestApiIntentService.apiService, GuestApiIntentService.propertyCode, LanguagesManager.getSelectedLanguageCode())) break;
                    try {
                        sessionToken = ContentManager.getContentSessionToken();
                        ConversationsAPICalls.sendMessage(this.mContext, GuestApiIntentService.apiService, sessionToken, GuestApiIntentService.conversationCode, GuestApiIntentService.messageContent);
                    }
                    catch (SessionExpiredException e3) {
                        e3.printStackTrace();
                    }
                }
                break;
            }
            case 6: {
                try {
                    ConversationsAPICalls.createConversation(this.mContext, GuestApiIntentService.apiService, sessionToken, GuestApiIntentService.outletCode, GuestApiIntentService.messageContent);
                }
                catch (SessionExpiredException e) {
                    e.printStackTrace();
                    if (!SessionInitialise.initializeSession(this.mContext, GuestApiIntentService.apiService, GuestApiIntentService.propertyCode, LanguagesManager.getSelectedLanguageCode())) break;
                    try {
                        sessionToken = ContentManager.getContentSessionToken();
                        ConversationsAPICalls.createConversation(this.mContext, GuestApiIntentService.apiService, sessionToken, GuestApiIntentService.outletCode, GuestApiIntentService.messageContent);
                    }
                    catch (SessionExpiredException e3) {
                        e3.printStackTrace();
                    }
                }
                break;
            }
            case 7: {
                try {
                    ConversationsAPICalls.markMessageAsRead(this.mContext, GuestApiIntentService.apiService, sessionToken, GuestApiIntentService.messageCode);
                }
                catch (SessionExpiredException e) {
                    e.printStackTrace();
                    if (!SessionInitialise.initializeSession(this.mContext, GuestApiIntentService.apiService, GuestApiIntentService.propertyCode, LanguagesManager.getSelectedLanguageCode())) break;
                    try {
                        sessionToken = ContentManager.getContentSessionToken();
                        ConversationsAPICalls.markMessageAsRead(this.mContext, GuestApiIntentService.apiService, sessionToken, GuestApiIntentService.messageCode);
                    }
                    catch (SessionExpiredException e3) {
                        e3.printStackTrace();
                    }
                }
                break;
            }
            case 8: {
                try {
                    CartAPICalls.runAddItemsToBasket(this.mContext, GuestApiIntentService.apiService, sessionToken, GuestApiIntentService.outletCode);
                }
                catch (SessionExpiredException e) {
                    e.printStackTrace();
                    if (!SessionInitialise.initializeSession(this.mContext, GuestApiIntentService.apiService, GuestApiIntentService.propertyCode, LanguagesManager.getSelectedLanguageCode())) break;
                    try {
                        sessionToken = ContentManager.getContentSessionToken();
                        CartAPICalls.runAddItemsToBasket(this.mContext, GuestApiIntentService.apiService, sessionToken, GuestApiIntentService.outletCode);
                    }
                    catch (SessionExpiredException e3) {
                        e3.printStackTrace();
                    }
                }
                break;
            }
            case 9: {
                try {
                    CartAPICalls.placeGuestOrder(this.mContext, GuestApiIntentService.apiService, sessionToken, GuestApiIntentService.outletCode, false);
                }
                catch (SessionExpiredException e) {
                    e.printStackTrace();
                    if (!SessionInitialise.initializeSession(this.mContext, GuestApiIntentService.apiService, GuestApiIntentService.propertyCode, LanguagesManager.getSelectedLanguageCode())) break;
                    try {
                        sessionToken = ContentManager.getContentSessionToken();
                        CartAPICalls.placeGuestOrder(this.mContext, GuestApiIntentService.apiService, sessionToken, GuestApiIntentService.outletCode, false);
                    }
                    catch (SessionExpiredException e3) {
                        e3.printStackTrace();
                    }
                }
                break;
            }
            case 10: {
                try {
                    ServiceRequestAPICalls.placeGuestServiceRequest(this.mContext, GuestApiIntentService.apiService, sessionToken, GuestApiIntentService.outletCode, GuestApiIntentService.comments);
                }
                catch (SessionExpiredException e) {
                    e.printStackTrace();
                    if (!SessionInitialise.initializeSession(this.mContext, GuestApiIntentService.apiService, GuestApiIntentService.propertyCode, LanguagesManager.getSelectedLanguageCode())) break;
                    try {
                        sessionToken = ContentManager.getContentSessionToken();
                        ServiceRequestAPICalls.placeGuestServiceRequest(this.mContext, GuestApiIntentService.apiService, sessionToken, GuestApiIntentService.outletCode, GuestApiIntentService.comments);
                    }
                    catch (SessionExpiredException e3) {
                        e3.printStackTrace();
                    }
                }
                break;
            }
            case 11: {
                try {
                    OrderHistoryAPICall.getOrderHistory(this.mContext, GuestApiIntentService.apiService, sessionToken);
                }
                catch (SessionExpiredException e) {
                    e.printStackTrace();
                    if (!SessionInitialise.initializeSession(this.mContext, GuestApiIntentService.apiService, GuestApiIntentService.propertyCode, LanguagesManager.getSelectedLanguageCode())) break;
                    try {
                        sessionToken = ContentManager.getContentSessionToken();
                        OrderHistoryAPICall.getOrderHistory(this.mContext, GuestApiIntentService.apiService, sessionToken);
                    }
                    catch (SessionExpiredException e3) {
                        e3.printStackTrace();
                    }
                }
                break;
            }
            case 12: {
                try {
                    SectionEncryptedURL.getSectionEncryptedURL(this.mContext, GuestApiIntentService.apiService, GuestApiIntentService.sectionCode, sessionToken);
                }
                catch (SessionExpiredException e) {
                    e.printStackTrace();
                    if (!SessionInitialise.initializeSession(this.mContext, GuestApiIntentService.apiService, GuestApiIntentService.propertyCode, LanguagesManager.getSelectedLanguageCode())) break;
                    try {
                        sessionToken = ContentManager.getContentSessionToken();
                        SectionEncryptedURL.getSectionEncryptedURL(this.mContext, GuestApiIntentService.apiService, GuestApiIntentService.sectionCode, sessionToken);
                    }
                    catch (SessionExpiredException e3) {
                        e3.printStackTrace();
                    }
                }
                break;
            }
            case 13: {
                if (GuestApiIntentService.guestId <= 0 || !ContentVisibilityByRoom.downloadContentByRoom(this.mContext, GuestApiIntentService.apiService, GuestApiIntentService.propertyCode, LanguagesManager.getSelectedLanguageCode(), ContentManager.getContentVersionNumber(), GuestApiIntentService.guestId)) break;
                GuestManager.onContentReady();
            }
        }
    }

    private boolean runCheckInGuest(String sessionToken) throws SessionExpiredException {
        String strError;
        block13: {
            Retrofit client;
            if (apiService == null && (client = ApiClient.getClient()) != null) {
                apiService = (ApiInterface)client.create(ApiInterface.class);
            }
            if (apiService == null) {
                GuestManager.onConnectionFailed();
                return false;
            }
            CheckInGuestDetails checkInGuestDetails = new CheckInGuestDetails();
            checkInGuestDetails.lastName = lastName;
            checkInGuestDetails.bookingReference = bookingReference;
            checkInGuestDetails.sessionToken = sessionToken;
            DebugLog.d(this.TAG, "runCheckInGuest");
            strError = "Unknown error";
            try {
                Call<CheckInResponse> call = apiService.checkInGuest(GuestManager.getEnvPath(), checkInGuestDetails);
                Response r = call.execute();
                DebugLog.d(this.TAG, "runCheckInGuest (" + r.code() + ") " + ContentManager.getContentSessionToken());
                if (ResponseHandler.checkResponse((Context)this, r)) {
                    CheckInResponse response = (CheckInResponse)r.body();
                    if (response == null || response.responses == null || response.responses.size() <= 0 || response.responses.get(0) == null || response.responses.get((int)0).checkIn == null || !response.responses.get((int)0).checkIn.succeeded) break block13;
                    boolean guestLoggedIn = false;
                    try {
                        sessionToken = ContentManager.getContentSessionToken();
                        guestLoggedIn = GuestProfileAPICalls.runGetGuestProfile(this.mContext, apiService, sessionToken);
                    }
                    catch (SessionExpiredException e) {
                        e.printStackTrace();
                    }
                    if (guestLoggedIn) {
                        GuestManager.onCheckedInSuccess();
                        return true;
                    }
                    break block13;
                }
                try {
                    ResponseBody errorBody = r.errorBody();
                    if (errorBody != null) {
                        Gson gson = new Gson();
                        CheckInResponse errorResponse = (CheckInResponse)gson.fromJson(errorBody.string(), CheckInResponse.class);
                        if (errorResponse != null) {
                            DebugLog.e(this.TAG, "runCheckInGuest error" + errorResponse.toString());
                        }
                        if (errorResponse != null && errorResponse.responses != null && errorResponse.responses.size() > 0 && errorResponse.responses.get(0) != null && errorResponse.responses.get((int)0).checkIn != null && !errorResponse.responses.get((int)0).checkIn.succeeded) {
                            strError = errorResponse.responses.get((int)0).checkIn.areaError;
                            DebugLog.e(this.TAG, "runCheckInGuest error: " + strError);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        DebugLog.d(this.TAG, "runCheckInGuest unknown error");
        GuestManager.onCheckedInFailed(strError);
        return false;
    }

    private boolean runCheckoutGuest(String sessionToken) throws SessionExpiredException {
        String strError;
        block11: {
            Retrofit client;
            if (apiService == null && (client = ApiClient.getClient()) != null) {
                apiService = (ApiInterface)client.create(ApiInterface.class);
            }
            if (apiService == null) {
                GuestManager.onConnectionFailed();
                return false;
            }
            CheckoutGuestDetails checkoutGuestDetails = new CheckoutGuestDetails();
            checkoutGuestDetails.sessionToken = sessionToken;
            DebugLog.d(this.TAG, "runCheckoutGuest");
            strError = "Unknown error";
            try {
                Call<CheckoutResponse> call = apiService.checkoutGuest(GuestManager.getEnvPath(), checkoutGuestDetails);
                Response r = call.execute();
                DebugLog.d(this.TAG, "runCheckoutGuest (" + r.code() + ") " + ContentManager.getContentSessionToken());
                if (ResponseHandler.checkResponse((Context)this, r)) {
                    CheckoutResponse response = (CheckoutResponse)r.body();
                    if (response != null && response.responses != null && response.responses.size() > 0 && response.responses.get(0) != null && response.responses.get((int)0).checkOut != null && response.responses.get((int)0).checkOut.succeeded) {
                        GuestManager.onCheckoutSuccess();
                        return true;
                    }
                    break block11;
                }
                try {
                    ResponseBody errorBody = r.errorBody();
                    if (errorBody != null) {
                        Gson gson = new Gson();
                        CheckoutResponse errorResponse = (CheckoutResponse)gson.fromJson(errorBody.string(), CheckoutResponse.class);
                        if (errorResponse != null) {
                            DebugLog.e(this.TAG, "runCheckoutGuest error" + errorResponse.toString());
                        }
                        if (errorResponse != null && errorResponse.responses != null && errorResponse.responses.size() > 0 && errorResponse.responses.get(0) != null && errorResponse.responses.get((int)0).checkOut != null && !errorResponse.responses.get((int)0).checkOut.succeeded) {
                            strError = errorResponse.responses.get((int)0).checkOut.areaError;
                            DebugLog.e(this.TAG, "runCheckoutGuest error: " + strError);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        DebugLog.d(this.TAG, "runCheckoutGuest unknown error");
        GuestManager.onCheckoutFailed(strError);
        return false;
    }
}

