/*
 * Decompiled with CFR 0.152.
 */
package com.irisvalet.android.apps.mobilevalethelper.service;

import android.content.Intent;
import android.text.TextUtils;
import com.irisvalet.android.apps.mobilevalethelper.ContentManager;
import com.irisvalet.android.apps.mobilevalethelper.GuestManager;
import com.irisvalet.android.apps.mobilevalethelper.LanguagesManager;
import com.irisvalet.android.apps.mobilevalethelper.ServiceManager;
import com.irisvalet.android.apps.mobilevalethelper.api.ApiInterface;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.RegisterAssetResponseDetailsAssetContent;
import com.irisvalet.android.apps.mobilevalethelper.exception.SessionExpiredException;
import com.irisvalet.android.apps.mobilevalethelper.service.BaseIntentService;
import com.irisvalet.android.apps.mobilevalethelper.service.api_calls.CartAPICalls;
import com.irisvalet.android.apps.mobilevalethelper.service.api_calls.ServiceRequestAPICalls;
import com.irisvalet.android.apps.mobilevalethelper.service.api_calls.SessionInitialise;
import com.irisvalet.android.apps.mobilevalethelper.utils.DebugLog;
import com.irisvalet.android.apps.mobilevalethelper.utils.TranslationUtils;

public class NonGuestApiIntentService
extends BaseIntentService {
    static ApiInterface apiService = null;
    static String propertyCode = null;
    static String baseURL = null;
    static String action = null;
    static String outletCode = null;
    static String comments = null;
    private static boolean serviceInProgress = false;

    public NonGuestApiIntentService() {
        super("NonGuestApiIntentService");
    }

    @Override
    public void onCreate() {
        super.onCreate();
    }

    @Override
    protected void onHandleIntent(Intent workIntent) {
        DebugLog.d(this.TAG, "onHandleIntent");
        if (serviceInProgress) {
            return;
        }
        if (workIntent == null || !this.isOnline()) {
            DebugLog.d(this.TAG, "BROADCAST_TO_ACTIVITY_NO_INTERNET_CONNECTION");
            GuestManager.onConnectionFailed();
            return;
        }
        if (this.mContext == null) {
            this.mContext = this.getApplicationContext();
        }
        baseURL = GuestManager.getBaseURL();
        action = workIntent.getStringExtra("ACTION");
        DebugLog.d(this.TAG, "action: " + action);
        propertyCode = ContentManager.getPropertyCode();
        outletCode = workIntent.getStringExtra("OUTLET_CODE");
        comments = workIntent.getStringExtra("GUEST_COMMENTS");
        if (propertyCode == null) {
            try {
                throw new Exception("Property code missing");
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        String sessionToken = ContentManager.getContentSessionToken();
        serviceInProgress = true;
        if (sessionToken == null) {
            this.initializeSession();
        }
        if (this.mContext != null && !TextUtils.isEmpty((CharSequence)ContentManager.getAppToken())) {
            this.runAPICall(sessionToken, action);
        } else {
            GuestManager.onAppTokenMissing();
        }
        serviceInProgress = false;
    }

    private boolean initializeSession() {
        if (TextUtils.isEmpty((CharSequence)ContentManager.getAppToken())) {
            GuestManager.onAppTokenMissing();
            return false;
        }
        if (GuestManager.isGV()) {
            RegisterAssetResponseDetailsAssetContent assetContent = ContentManager.getAssetRegistration();
            if (assetContent != null && assetContent.assetKey != null && SessionInitialise.initializeSession(this.mContext, apiService, assetContent.assetKey, propertyCode)) {
                return true;
            }
        } else {
            return SessionInitialise.initializeSession(this.mContext, apiService, propertyCode, LanguagesManager.getSelectedLanguageCode());
        }
        GuestManager.onDevicePairingRevoked(null);
        return false;
    }

    private void runAPICall(String sessionToken, String action) {
        if (action != null && !action.isEmpty()) {
            switch (action) {
                case "addItemsToBasket": {
                    try {
                        CartAPICalls.runAddItemsToBasket(this.mContext, apiService, sessionToken, outletCode);
                    }
                    catch (SessionExpiredException e) {
                        e.printStackTrace();
                        if (!this.initializeSession()) break;
                        try {
                            sessionToken = ContentManager.getContentSessionToken();
                            CartAPICalls.runAddItemsToBasket(this.mContext, apiService, sessionToken, outletCode);
                        }
                        catch (SessionExpiredException e3) {
                            e3.printStackTrace();
                        }
                    }
                    break;
                }
                case "placeGuestOrder": {
                    try {
                        CartAPICalls.placeGuestOrder(this.mContext, apiService, sessionToken, outletCode, true);
                    }
                    catch (SessionExpiredException e) {
                        e.printStackTrace();
                        if (!this.initializeSession()) break;
                        try {
                            sessionToken = ContentManager.getContentSessionToken();
                            CartAPICalls.placeGuestOrder(this.mContext, apiService, sessionToken, outletCode, true);
                        }
                        catch (SessionExpiredException e3) {
                            e3.printStackTrace();
                        }
                    }
                    break;
                }
                case "placeGuestServiceRequest": {
                    try {
                        ServiceRequestAPICalls.placeGuestServiceRequest(this.mContext, apiService, sessionToken, outletCode, comments);
                        break;
                    }
                    catch (SessionExpiredException e) {
                        e.printStackTrace();
                        if (this.initializeSession()) {
                            sessionToken = ContentManager.getContentSessionToken();
                            try {
                                ServiceRequestAPICalls.placeGuestServiceRequest(this.mContext, apiService, sessionToken, outletCode, comments);
                            }
                            catch (SessionExpiredException e1) {
                                e1.printStackTrace();
                                GuestManager.onConnectionFailed();
                            }
                            break;
                        }
                        ServiceManager.onPostServiceRequestFailed(this.mContext, TranslationUtils.getTranslatedString("valet_shared_label.error_occured"));
                    }
                }
            }
        }
    }
}

