/*
 * Decompiled with CFR 0.152.
 */
package com.irisvalet.android.apps.mobilevalethelper.service.api_calls;

import android.content.Context;
import com.irisvalet.android.apps.mobilevalethelper.ContentManager;
import com.irisvalet.android.apps.mobilevalethelper.GuestManager;
import com.irisvalet.android.apps.mobilevalethelper.api.ApiClient;
import com.irisvalet.android.apps.mobilevalethelper.api.ApiInterface;
import com.irisvalet.android.apps.mobilevalethelper.api.Requests.AssetRegistrationRequestDetails;
import com.irisvalet.android.apps.mobilevalethelper.api.Requests.AssetRegistrationRequestDetailsAsset;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.RegisterAssetResponse;
import com.irisvalet.android.apps.mobilevalethelper.exception.SessionExpiredException;
import com.irisvalet.android.apps.mobilevalethelper.service.api_calls.ResponseHandler;
import com.irisvalet.android.apps.mobilevalethelper.utils.DebugLog;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.Retrofit;

public class AssetAPICalls {
    private static final String TAG = "AssetAPICalls";

    public static void runPairAssetToRoom(Context context, ApiInterface apiService, String sessionToken, String propertyCode, String room, String deviceID, String pin) throws SessionExpiredException {
        Retrofit client;
        if (apiService == null && (client = ApiClient.getClient()) != null) {
            apiService = (ApiInterface)client.create(ApiInterface.class);
        }
        if (apiService == null) {
            GuestManager.onConnectionFailed();
            return;
        }
        String error = "Error pairing device";
        try {
            AssetRegistrationRequestDetails request = new AssetRegistrationRequestDetails();
            request.sessionToken = sessionToken;
            request.assetManagementPin = pin;
            request.asset = new AssetRegistrationRequestDetailsAsset();
            request.asset.assetId = deviceID;
            request.asset.roomNumber = room;
            Call<RegisterAssetResponse> call = apiService.registerAsset(GuestManager.getEnvPath(), propertyCode, request);
            Response r = call.execute();
            DebugLog.d(TAG, "runPairAssetToRoom (" + r.code() + ") " + ContentManager.getContentSessionToken());
            if (ResponseHandler.checkResponse(context, r)) {
                RegisterAssetResponse response = (RegisterAssetResponse)r.body();
                if (response != null && response.responses != null && response.responses.size() > 0 && response.responses.get(0) != null && response.responses.get((int)0).addAsset != null && response.responses.get((int)0).addAsset.succeeded && response.responses.get((int)0).addAsset.content != null && response.responses.get((int)0).addAsset.content.propertyCode != null && response.responses.get((int)0).addAsset.content.assetKey != null && response.responses.get((int)0).addAsset.content.assetId != null && response.responses.get((int)0).addAsset.content.roomNumber != null) {
                    ContentManager.addAssetRegistration(response.responses.get((int)0).addAsset.content);
                    GuestManager.onDevicePairingSuccess(response.responses.get((int)0).addAsset.content.roomNumber);
                    return;
                }
            } else if (r.errorBody() != null) {
                error = r.errorBody().string();
            }
        }
        catch (SessionExpiredException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            error = e.getMessage();
        }
        DebugLog.e(TAG, "runPairDeviceToRoom response error: " + error);
        GuestManager.onDevicePairingFailed(error);
    }
}

