/*
 * Decompiled with CFR 0.152.
 */
package com.irisvalet.android.apps.mobilevalethelper.service.api_calls;

import android.content.Context;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.irisvalet.android.apps.mobilevalethelper.CartManager;
import com.irisvalet.android.apps.mobilevalethelper.ContentManager;
import com.irisvalet.android.apps.mobilevalethelper.GuestManager;
import com.irisvalet.android.apps.mobilevalethelper.ShoppingCart;
import com.irisvalet.android.apps.mobilevalethelper.api.ApiClient;
import com.irisvalet.android.apps.mobilevalethelper.api.ApiInterface;
import com.irisvalet.android.apps.mobilevalethelper.api.Requests.BasketRequestDetails;
import com.irisvalet.android.apps.mobilevalethelper.api.Requests.BasketRequestItem;
import com.irisvalet.android.apps.mobilevalethelper.api.Requests.BasketRequestItemOption;
import com.irisvalet.android.apps.mobilevalethelper.api.Requests.OrderRequestDetails;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.BasketContent;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.OutletAddItemsToBasketResponse;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.OutletGuestOrderResponse;
import com.irisvalet.android.apps.mobilevalethelper.exception.SessionExpiredException;
import com.irisvalet.android.apps.mobilevalethelper.object.Modifier;
import com.irisvalet.android.apps.mobilevalethelper.object.ModifierOption;
import com.irisvalet.android.apps.mobilevalethelper.object.NonVerifiedGuestField;
import com.irisvalet.android.apps.mobilevalethelper.object.ShoppingCartItem;
import com.irisvalet.android.apps.mobilevalethelper.object.SubModifier;
import com.irisvalet.android.apps.mobilevalethelper.object.UnavailableItem;
import com.irisvalet.android.apps.mobilevalethelper.service.api_calls.ResponseHandler;
import com.irisvalet.android.apps.mobilevalethelper.utils.DebugLog;
import com.irisvalet.android.apps.mobilevalethelper.utils.TranslationUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.Retrofit;

public class CartAPICalls {
    private static final String TAG = "CartAPICalls";

    public static void runAddItemsToBasket(Context context, ApiInterface apiService, String sessionToken, String outletCode) throws SessionExpiredException {
        block30: {
            Retrofit client;
            if (apiService == null && (client = ApiClient.getClient()) != null) {
                apiService = (ApiInterface)client.create(ApiInterface.class);
            }
            if (apiService == null) {
                GuestManager.onConnectionFailed();
                return;
            }
            ShoppingCart cart = CartManager.getCart(outletCode);
            BasketRequestDetails data = new BasketRequestDetails();
            data.sessionToken = sessionToken;
            int deliveryLocationOption = CartManager.getDeliveryLocationOption(outletCode);
            switch (deliveryLocationOption) {
                case 2: {
                    data.deliveryType = "Collection";
                    break;
                }
                case 3: {
                    data.deliveryType = "DeliveryLocation";
                    if (cart != null && CartManager.mDeliveryLocationMap.get(outletCode) != null) {
                        data.deliveryLocationCode = CartManager.mDeliveryLocationMap.get((Object)outletCode).code;
                        break;
                    }
                    CartManager.onPostBasketFailed(context, outletCode, "Select delivery location");
                    return;
                }
                default: {
                    data.deliveryType = "Room";
                }
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.getDefault());
            int deliveryTimeOption = CartManager.getDeliveryTimeOption(outletCode);
            switch (deliveryTimeOption) {
                case 11: {
                    data.deliverLater = "later";
                    if (CartManager.getDeliveryTime(outletCode) == null) break;
                    data.deliveryDateTime = dateFormat.format(CartManager.getDeliveryTime(outletCode));
                    break;
                }
                default: {
                    data.deliverLater = "Now";
                    data.deliveryDateTime = dateFormat.format(new Date());
                }
            }
            DebugLog.d(TAG, "data.deliveryDateTime: " + data.deliveryDateTime);
            data.isDeliveryDateTimeUtc = false;
            if (cart != null && cart.items != null) {
                data.items = new ArrayList();
                for (ShoppingCartItem item : cart.items) {
                    if (item.quantity <= 0 || item.item == null) continue;
                    BasketRequestItem basketItem = new BasketRequestItem();
                    basketItem.categoryItemCode = item.item.code;
                    basketItem.posItemCode = item.item.posItemCode;
                    basketItem.quantity = item.quantity;
                    basketItem.comments = item.comments;
                    basketItem.options = new ArrayList();
                    if (item.item.modifiers != null && item.item.modifiers.size() > 0) {
                        for (Modifier modifier : item.item.modifiers) {
                            if (modifier.type != null && modifier.type.toLowerCase().contains("text") && !TextUtils.isEmpty((CharSequence)modifier.value)) {
                                BasketRequestItemOption basketOption = new BasketRequestItemOption();
                                basketOption.modifierCode = modifier.code;
                                basketOption.optionCode = modifier.value;
                                basketItem.options.add(basketOption);
                                continue;
                            }
                            if (modifier.modifierOptions == null || modifier.modifierOptions.size() <= 0) continue;
                            for (ModifierOption option : modifier.modifierOptions) {
                                BasketRequestItemOption basketOption;
                                if (option.subModifiers != null && option.subModifiers.size() > 0) {
                                    boolean subModifierAdded = false;
                                    for (SubModifier sm : option.subModifiers) {
                                        if (sm.modifierOptions == null || sm.modifierOptions.size() <= 0) continue;
                                        for (ModifierOption smo : sm.modifierOptions) {
                                            if (smo.quantity <= 0) continue;
                                            subModifierAdded = true;
                                            for (int i = 0; i < smo.quantity; ++i) {
                                                BasketRequestItemOption basketSubOption = new BasketRequestItemOption();
                                                basketSubOption.modifierCode = sm.code;
                                                basketSubOption.optionCode = smo.code;
                                                basketSubOption.posItemCode = smo.posItemCode;
                                                basketItem.options.add(basketSubOption);
                                            }
                                        }
                                    }
                                    if (subModifierAdded) {
                                        basketOption = new BasketRequestItemOption();
                                        basketOption.modifierCode = modifier.code;
                                        basketOption.optionCode = option.code;
                                        basketOption.posItemCode = option.posItemCode;
                                        basketItem.options.add(basketOption);
                                    }
                                }
                                if (option.quantity <= 0) continue;
                                for (int i = 0; i < option.quantity; ++i) {
                                    basketOption = new BasketRequestItemOption();
                                    basketOption.modifierCode = modifier.code;
                                    basketOption.optionCode = option.code;
                                    basketOption.posItemCode = option.posItemCode;
                                    basketItem.options.add(basketOption);
                                }
                            }
                        }
                    }
                    data.items.add(basketItem);
                }
            }
            DebugLog.d(TAG, "runAddItemsToBasket outletCode: " + outletCode);
            DebugLog.d(TAG, "data: " + data.toString());
            try {
                Call<OutletAddItemsToBasketResponse> call = apiService.postOutletAddItemsToBasket(GuestManager.getEnvPath(), outletCode, outletCode, sessionToken, data);
                Response r = call.execute();
                DebugLog.d(TAG, "runAddItemsToBasket (" + r.code() + ") " + sessionToken);
                if (ResponseHandler.checkResponse(context, r)) {
                    OutletAddItemsToBasketResponse response = (OutletAddItemsToBasketResponse)r.body();
                    if (response != null && response.responses != null && response.responses.size() > 0 && response.responses.get(0) != null && response.responses.get((int)0).addItemsToBasketAsync != null && response.responses.get((int)0).addItemsToBasketAsync.succeeded && response.responses.get((int)0).addItemsToBasketAsync.content != null && response.responses.get((int)0).addItemsToBasketAsync.content.basketCode != null) {
                        BasketContent content = response.responses.get((int)0).addItemsToBasketAsync.content;
                        DebugLog.d(TAG, "addItemsToBasketAsync.content: " + content.toString());
                        CartManager.setBasketContent(outletCode, content);
                        CartManager.onAddToBasketSucceed(context);
                        return;
                    }
                    break block30;
                }
                if (r.errorBody() == null) break block30;
                String errorBody = r.errorBody().string();
                DebugLog.e(TAG, "runAddItemsToBasket error: " + errorBody);
                Gson gson = new Gson();
                try {
                    OutletAddItemsToBasketResponse errorResponse = (OutletAddItemsToBasketResponse)gson.fromJson(errorBody, OutletAddItemsToBasketResponse.class);
                    if (errorResponse != null) {
                        CartManager.onPostBasketFailed(context, outletCode, errorResponse.responses.get((int)0).addItemsToBasketAsync.areaError);
                        DebugLog.e(TAG, "runAddItemsToBasket error: " + errorResponse.responses.get((int)0).addItemsToBasketAsync.areaError);
                        return;
                    }
                }
                catch (JsonSyntaxException e) {
                    e.printStackTrace();
                }
            }
            catch (SessionExpiredException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        CartManager.onPostBasketFailed(context, outletCode, "Unknown error");
    }

    public static void placeGuestOrder(Context context, ApiInterface apiService, String sessionToken, String outletCode, boolean isNonVerifiedGuest) throws SessionExpiredException {
        block28: {
            try {
                String errorBody;
                ArrayList<NonVerifiedGuestField> fields;
                int noOfGuests;
                Retrofit client;
                if (apiService == null && (client = ApiClient.getClient()) != null) {
                    apiService = (ApiInterface)client.create(ApiInterface.class);
                }
                if (apiService == null) {
                    GuestManager.onConnectionFailed();
                    return;
                }
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.getDefault());
                Date deliveryTime = new Date();
                if (CartManager.getDeliveryTime(outletCode) != null) {
                    deliveryTime = CartManager.getDeliveryTime(outletCode);
                }
                OrderRequestDetails data = new OrderRequestDetails();
                data.sessionToken = sessionToken;
                data.basketCode = CartManager.getBasketContent((String)outletCode).basketCode;
                data.isDeliveryDateTimeUtc = false;
                data.deliveryDateTime = sdf.format(deliveryTime);
                data.comment = CartManager.getComments(outletCode);
                data.numberOfGuests = noOfGuests = CartManager.getNumberOfGuests(outletCode);
                data.orderFormDetailsDictionary = new JsonObject();
                data.orderFormDetailsDictionary.addProperty("NoOfGuests", (Number)noOfGuests);
                data.paymentType = CartManager.getPaymentType(outletCode);
                try {
                    ShoppingCart cart = CartManager.getCart(outletCode);
                    if (cart != null && CartManager.mDeliveryLocationMap.get(outletCode) != null) {
                        data.orderFormDetailsDictionary.addProperty("DeliveryLocationCode", CartManager.mDeliveryLocationMap.get((Object)outletCode).code);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (isNonVerifiedGuest && (fields = CartManager.getNonVerifiedGuestsFields(outletCode)) != null && fields.size() > 0) {
                    for (NonVerifiedGuestField field : fields) {
                        data.orderFormDetailsDictionary.addProperty(field.name, field.value);
                    }
                }
                DebugLog.d(TAG, "data: " + data.toString());
                Call<OutletGuestOrderResponse> call = !isNonVerifiedGuest ? apiService.postPlaceVerifiedGuestOrder(GuestManager.getEnvPath(), outletCode, outletCode, sessionToken, data) : apiService.postPlaceNonVerifiedGuestOrder(GuestManager.getEnvPath(), outletCode, outletCode, sessionToken, data);
                Response r = call.execute();
                DebugLog.d(TAG, "placeGuestOrder (" + r.code() + ") " + sessionToken);
                if (ResponseHandler.checkResponse(context, r)) {
                    OutletGuestOrderResponse response = (OutletGuestOrderResponse)r.body();
                    if (response != null && response.responses != null && response.responses.size() > 0 && response.responses.get(0) != null) {
                        if (!isNonVerifiedGuest) {
                            if (response.responses.get((int)0).placeVerifiedGuestOrderAsync != null && response.responses.get((int)0).placeVerifiedGuestOrderAsync.succeeded && response.responses.get((int)0).placeVerifiedGuestOrderAsync.content != null) {
                                CartManager.clearCart(outletCode);
                                CartManager.onPostBasketSucceed(context, outletCode, isNonVerifiedGuest, response.responses.get((int)0).placeVerifiedGuestOrderAsync.content);
                                return;
                            }
                        } else if (response.responses.get((int)0).placeNonVerifiedGuestOrderAsync != null && response.responses.get((int)0).placeNonVerifiedGuestOrderAsync.succeeded && response.responses.get((int)0).placeNonVerifiedGuestOrderAsync.content != null) {
                            String orderReference = response.responses.get((int)0).placeNonVerifiedGuestOrderAsync.content.posOrderReference;
                            if (orderReference == null || orderReference.isEmpty()) {
                                orderReference = response.responses.get((int)0).placeNonVerifiedGuestOrderAsync.content.gxpOrderReference;
                            }
                            ContentManager.saveNonVerifiedOrder(CartManager.getDefaultCart(), orderReference);
                            CartManager.clearCart(outletCode);
                            CartManager.onPostBasketSucceed(context, outletCode, isNonVerifiedGuest, response.responses.get((int)0).placeNonVerifiedGuestOrderAsync.content);
                            return;
                        }
                    }
                    break block28;
                }
                if (r.errorBody() == null || (errorBody = r.errorBody().string()) == null) break block28;
                DebugLog.e(TAG, "placeGuestOrder error: " + errorBody);
                Gson gson = new Gson();
                try {
                    OutletGuestOrderResponse errorResponse = (OutletGuestOrderResponse)gson.fromJson(errorBody, OutletGuestOrderResponse.class);
                    if (errorResponse == null) break block28;
                    String errorMessage = "Unknown error";
                    if (!isNonVerifiedGuest) {
                        if (errorResponse.responses != null && errorResponse.responses.size() > 0 && errorResponse.responses.get(0) != null && errorResponse.responses.get((int)0).placeVerifiedGuestOrderAsync != null && errorResponse.responses.get((int)0).placeVerifiedGuestOrderAsync.areaError != null) {
                            errorMessage = errorResponse.responses.get((int)0).placeVerifiedGuestOrderAsync.areaError;
                            if (errorResponse.responses.get((int)0).placeVerifiedGuestOrderAsync.areaError.equals("CartItemsUnavailable") && errorResponse.responses.get((int)0).placeVerifiedGuestOrderAsync.content != null && errorResponse.responses.get((int)0).placeVerifiedGuestOrderAsync.content.unavailableItems != null && errorResponse.responses.get((int)0).placeVerifiedGuestOrderAsync.content.unavailableItems.size() > 0) {
                                errorMessage = TranslationUtils.getTranslatedString("valet_product_label.item_availability_error");
                                errorMessage = errorMessage + "\n" + TranslationUtils.getTranslatedString("valet_product_label.item_unavailable");
                                for (UnavailableItem unavailableItem : errorResponse.responses.get((int)0).placeVerifiedGuestOrderAsync.content.unavailableItems) {
                                    errorMessage = errorMessage + "\n" + unavailableItem.name;
                                }
                            }
                        }
                    } else if (errorResponse.responses != null && errorResponse.responses.size() > 0 && errorResponse.responses.get(0) != null && errorResponse.responses.get((int)0).placeNonVerifiedGuestOrderAsync != null && errorResponse.responses.get((int)0).placeNonVerifiedGuestOrderAsync.areaError != null) {
                        errorMessage = errorResponse.responses.get((int)0).placeNonVerifiedGuestOrderAsync.areaError;
                        if (errorResponse.responses.get((int)0).placeNonVerifiedGuestOrderAsync.areaError.equals("CartItemsUnavailable") && errorResponse.responses.get((int)0).placeNonVerifiedGuestOrderAsync.content != null && errorResponse.responses.get((int)0).placeNonVerifiedGuestOrderAsync.content.unavailableItems != null && errorResponse.responses.get((int)0).placeNonVerifiedGuestOrderAsync.content.unavailableItems.size() > 0) {
                            errorMessage = TranslationUtils.getTranslatedString("valet_product_label.item_availability_error");
                            errorMessage = errorMessage + "\n" + TranslationUtils.getTranslatedString("valet_product_label.item_unavailable");
                            for (UnavailableItem unavailableItem : errorResponse.responses.get((int)0).placeNonVerifiedGuestOrderAsync.content.unavailableItems) {
                                errorMessage = errorMessage + "\n" + unavailableItem.name;
                            }
                        }
                    }
                    CartManager.onPostBasketFailed(context, outletCode, errorMessage);
                    return;
                }
                catch (JsonSyntaxException e) {
                    e.printStackTrace();
                }
            }
            catch (SessionExpiredException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        CartManager.onPostBasketFailed(context, outletCode, "Unknown error");
    }
}

