/*
 * Decompiled with CFR 0.152.
 */
package com.irisvalet.android.apps.mobilevalethelper.service.api_calls;

import android.content.Context;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.irisvalet.android.apps.mobilevalethelper.ContentManager;
import com.irisvalet.android.apps.mobilevalethelper.GuestManager;
import com.irisvalet.android.apps.mobilevalethelper.api.ApiClient;
import com.irisvalet.android.apps.mobilevalethelper.api.ApiInterface;
import com.irisvalet.android.apps.mobilevalethelper.api.Requests.CreateConversationRequest;
import com.irisvalet.android.apps.mobilevalethelper.api.Requests.CreateMessageRequest;
import com.irisvalet.android.apps.mobilevalethelper.api.Requests.CreateMessageRequestMessage;
import com.irisvalet.android.apps.mobilevalethelper.api.Requests.MessageRequestDetails;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.BaseAPIResponse;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.ConversationsResponse;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.ConversationsResponseDetailsContent;
import com.irisvalet.android.apps.mobilevalethelper.exception.SessionExpiredException;
import com.irisvalet.android.apps.mobilevalethelper.object.Conversation;
import com.irisvalet.android.apps.mobilevalethelper.object.OrderHistoryItem;
import com.irisvalet.android.apps.mobilevalethelper.service.api_calls.OrderHistoryAPICall;
import com.irisvalet.android.apps.mobilevalethelper.service.api_calls.ResponseHandler;
import com.irisvalet.android.apps.mobilevalethelper.utils.DebugLog;
import java.io.IOException;
import java.util.ArrayList;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.Retrofit;

public class ConversationsAPICalls {
    private static final String TAG = "ConversationsAPICalls";

    public static int getConversations(Context context, ApiInterface apiService, String sessionToken) throws SessionExpiredException {
        block11: {
            Retrofit client;
            if (apiService == null && (client = ApiClient.getClient()) != null) {
                apiService = (ApiInterface)client.create(ApiInterface.class);
            }
            if (apiService == null) {
                GuestManager.onConnectionFailed();
                return 0;
            }
            try {
                Call<ConversationsResponse> call = apiService.getConversations(GuestManager.getEnvPath(), sessionToken);
                Response r = call.execute();
                DebugLog.d(TAG, "getConversations (" + r.code() + ") " + sessionToken);
                if (ResponseHandler.checkResponse(context, r)) {
                    ConversationsResponse response = (ConversationsResponse)r.body();
                    if (response != null && response.responses != null && response.responses.size() > 0 && response.responses.get(0) != null && response.responses.get((int)0).getConversations != null && response.responses.get((int)0).getConversations.succeeded && response.responses.get((int)0).getConversations.content != null) {
                        ConversationsAPICalls.checkMessagesForOrdersContent(context, apiService, response.sessionToken, response.responses.get((int)0).getConversations.content.conversations);
                        if (response.responses.get((int)0).getConversations.content.checkForNewUnreadMessages()) {
                            GuestManager.onNewMessageNotification();
                        }
                        ContentManager.saveGuestConversations(response.responses.get((int)0).getConversations.content);
                        return ConversationsResponseDetailsContent.lastUnreadMessages;
                    }
                    break block11;
                }
                Gson gson = new Gson();
                ConversationsResponse errorBody = null;
                try {
                    errorBody = (ConversationsResponse)gson.fromJson(r.errorBody().string(), ConversationsResponse.class);
                }
                catch (JsonSyntaxException e) {
                    e.printStackTrace();
                }
                if (errorBody != null && errorBody.responses != null && errorBody.responses.get(0) != null && errorBody.responses.get((int)0).getConversations != null && !errorBody.responses.get((int)0).getConversations.succeeded && errorBody.responses.get((int)0).getConversations.areaError != null) {
                    String areaError = errorBody.responses.get((int)0).getConversations.areaError;
                    DebugLog.e(TAG, "getConversations response.errorBody(): " + areaError);
                    if (areaError.equals("GuestNotFound")) {
                        GuestManager.onGuestCheckedOut();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        GuestManager.onGuestConversationsFailed("GetGuestProfile Error");
        return 0;
    }

    private static void checkMessagesForOrdersContent(Context context, ApiInterface apiService, String sessionToken, ArrayList<Conversation> conversations) throws SessionExpiredException {
        if (conversations == null || conversations.size() == 0) {
            return;
        }
        ArrayList<OrderHistoryItem> orderHistoryItems = ContentManager.getGuestOrderHistory();
        boolean shouldFetchOrderHistory = false;
        ArrayList<String> orderCodes = new ArrayList<String>();
        for (Conversation conversation : conversations) {
            if (conversation == null || TextUtils.isEmpty((CharSequence)conversation.orderCode)) continue;
            orderCodes.add(conversation.orderCode);
        }
        if (orderCodes.size() > 0) {
            for (String orderCode : orderCodes) {
                boolean orderFound = false;
                if (orderHistoryItems != null && orderHistoryItems.size() > 0) {
                    for (OrderHistoryItem order : orderHistoryItems) {
                        orderFound = orderCode.equals(order.code);
                        if (!orderFound) continue;
                        break;
                    }
                }
                if (!(shouldFetchOrderHistory = !orderFound)) continue;
                break;
            }
        }
        if (shouldFetchOrderHistory) {
            OrderHistoryAPICall.getOrderHistory(context, apiService, sessionToken);
        }
    }

    public static void createConversation(Context context, ApiInterface apiService, String sessionToken, String outletCode, String messageContent) throws SessionExpiredException {
        block11: {
            Retrofit client;
            if (TextUtils.isEmpty((CharSequence)messageContent)) {
                GuestManager.onMessageFailed("No message Content");
                return;
            }
            if (apiService == null && (client = ApiClient.getClient()) != null) {
                apiService = (ApiInterface)client.create(ApiInterface.class);
            }
            if (apiService == null) {
                GuestManager.onMessageFailed("No Internet connection");
                return;
            }
            try {
                DebugLog.d(TAG, "createConversation");
                CreateConversationRequest data = new CreateConversationRequest();
                data.message = messageContent;
                data.sessionToken = sessionToken;
                data.outletCode = outletCode;
                Call<ConversationsResponse> call = apiService.createConversation(GuestManager.getEnvPath(), data);
                Response r = call.execute();
                DebugLog.d(TAG, "createConversation (" + r.code() + ") " + sessionToken);
                if (ResponseHandler.checkResponse(context, r)) {
                    ConversationsResponse response = (ConversationsResponse)r.body();
                    if (response != null && response.responses != null && response.responses.size() > 0 && response.responses.get(0) != null && response.responses.get((int)0).createConversation != null && response.responses.get((int)0).createConversation.succeeded && response.responses.get((int)0).createConversation.content != null && response.responses.get((int)0).createConversation.content.conversation != null) {
                        ConversationsAPICalls.getConversations(context, apiService, response.sessionToken);
                        GuestManager.onCreateConversationSuccess();
                        return;
                    }
                    break block11;
                }
                try {
                    ResponseBody errorBody = r.errorBody();
                    if (errorBody != null) {
                        Gson gson = new Gson();
                        ConversationsResponse response1 = (ConversationsResponse)gson.fromJson(errorBody.string(), ConversationsResponse.class);
                        if (response1 != null) {
                            GuestManager.onCreateConversationFailed(response1.responses.toString());
                        }
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        GuestManager.onCreateConversationFailed("createConversation Error");
    }

    public static void sendMessage(Context context, ApiInterface apiService, String sessionToken, String conversationCode, String messageContent) throws SessionExpiredException {
        block12: {
            Retrofit client;
            if (TextUtils.isEmpty((CharSequence)conversationCode)) {
                GuestManager.onMessageFailed("Code missing");
                return;
            }
            if (TextUtils.isEmpty((CharSequence)messageContent)) {
                GuestManager.onMessageFailed("No message Content");
                return;
            }
            if (apiService == null && (client = ApiClient.getClient()) != null) {
                apiService = (ApiInterface)client.create(ApiInterface.class);
            }
            if (apiService == null) {
                GuestManager.onMessageFailed("No Internet connection");
                return;
            }
            try {
                DebugLog.d(TAG, "sendMessage");
                CreateMessageRequest data = new CreateMessageRequest();
                data.sessionToken = sessionToken;
                data.message = new CreateMessageRequestMessage();
                data.message.content = messageContent;
                Call<ConversationsResponse> call = apiService.sendMessage(GuestManager.getEnvPath(), conversationCode, data);
                Response r = call.execute();
                DebugLog.d(TAG, "sendMessage (" + r.code() + ") " + sessionToken);
                if (ResponseHandler.checkResponse(context, r)) {
                    ConversationsResponse response = (ConversationsResponse)r.body();
                    if (response != null && response.responses != null && response.responses.size() > 0 && response.responses.get(0) != null && response.responses.get((int)0).addMessageToConversation != null && response.responses.get((int)0).addMessageToConversation.succeeded && response.responses.get((int)0).addMessageToConversation.content != null) {
                        ConversationsAPICalls.getConversations(context, apiService, response.sessionToken);
                        GuestManager.onSendMessageSuccess();
                        return;
                    }
                    break block12;
                }
                try {
                    ResponseBody errorBody = r.errorBody();
                    if (errorBody != null) {
                        Gson gson = new Gson();
                        ConversationsResponse response1 = (ConversationsResponse)gson.fromJson(errorBody.string(), ConversationsResponse.class);
                        if (response1 != null) {
                            GuestManager.onSendMessageFailed(response1.responses.get((int)0).addMessageToConversation.content.toString());
                        }
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        GuestManager.onSendMessageFailed("sendMessage Error");
    }

    public static void markMessageAsRead(Context context, ApiInterface apiService, String sessionToken, String messageCode) throws SessionExpiredException {
        Retrofit client;
        if (TextUtils.isEmpty((CharSequence)messageCode)) {
            GuestManager.onMessageFailed("Code missing");
            return;
        }
        if (apiService == null && (client = ApiClient.getClient()) != null) {
            apiService = (ApiInterface)client.create(ApiInterface.class);
        }
        if (apiService == null) {
            GuestManager.onMessageFailed("No Internet connection");
            return;
        }
        try {
            BaseAPIResponse response;
            MessageRequestDetails data = new MessageRequestDetails(sessionToken);
            Call<BaseAPIResponse> call = apiService.markMessageAsRead(GuestManager.getEnvPath(), messageCode, data);
            Response r = call.execute();
            DebugLog.d(TAG, "markMessageAsRead (" + r.code() + ") " + sessionToken);
            if (ResponseHandler.checkResponse(context, r) && (response = (BaseAPIResponse)r.body()) != null) {
                ConversationsAPICalls.getConversations(context, apiService, response.sessionToken);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

