/*
 * Decompiled with CFR 0.152.
 */
package com.irisvalet.android.apps.mobilevalethelper.service.api_calls;

import android.content.Context;
import com.google.gson.Gson;
import com.irisvalet.android.apps.mobilevalethelper.ContentManager;
import com.irisvalet.android.apps.mobilevalethelper.GuestManager;
import com.irisvalet.android.apps.mobilevalethelper.api.ApiClient;
import com.irisvalet.android.apps.mobilevalethelper.api.ApiInterface;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.GuestProfileResponse;
import com.irisvalet.android.apps.mobilevalethelper.exception.SessionExpiredException;
import com.irisvalet.android.apps.mobilevalethelper.object.User;
import com.irisvalet.android.apps.mobilevalethelper.service.api_calls.ResponseHandler;
import com.irisvalet.android.apps.mobilevalethelper.utils.DebugLog;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.Retrofit;

public class GuestProfileAPICalls {
    private static final String TAG = "GuestProfileAPICalls";

    public static boolean runGetGuestProfile(Context context, ApiInterface apiService, String sessionToken) throws SessionExpiredException {
        block16: {
            Retrofit client;
            if (apiService == null && (client = ApiClient.getClient()) != null) {
                apiService = (ApiInterface)client.create(ApiInterface.class);
            }
            if (apiService == null) {
                GuestManager.onConnectionFailed();
                return false;
            }
            try {
                Call<GuestProfileResponse> call = apiService.getGuestProfile(GuestManager.getEnvPath(), sessionToken);
                Response r = call.execute();
                DebugLog.d(TAG, "runGetGuestProfile (" + r.code() + ") " + sessionToken);
                if (ResponseHandler.checkResponse(context, r)) {
                    GuestProfileResponse response = (GuestProfileResponse)r.body();
                    if (response != null && response.responses != null && response.responses.size() > 0 && response.responses.get(0) != null && response.responses.get((int)0).getGuestProfile != null && response.responses.get((int)0).getGuestProfile.succeeded && response.responses.get((int)0).getGuestProfile.content != null) {
                        if (response.responses.get((int)0).getGuestProfile.content.reservationNumber != null && GuestManager.getUser() != null && GuestManager.getUser().reservationNumber != null && !GuestManager.getUser().reservationNumber.equals(response.responses.get((int)0).getGuestProfile.content.reservationNumber)) {
                            return false;
                        }
                        ContentManager.insertGuestProfile(response.responses.get((int)0).getGuestProfile.content);
                        GuestManager.setUser(new User(response.responses.get((int)0).getGuestProfile.content.title, response.responses.get((int)0).getGuestProfile.content.firstName, response.responses.get((int)0).getGuestProfile.content.lastName, response.responses.get((int)0).getGuestProfile.content.roomNumber, response.responses.get((int)0).getGuestProfile.content.languageCode));
                        ContentManager.saveUser(GuestManager.getUser());
                        return true;
                    }
                    break block16;
                }
                try {
                    Gson gson;
                    GuestProfileResponse errorResponse;
                    ResponseBody errorBody = r.errorBody();
                    if (errorBody != null && (errorResponse = (GuestProfileResponse)(gson = new Gson()).fromJson(errorBody.string(), GuestProfileResponse.class)) != null) {
                        String areaError;
                        DebugLog.e(TAG, "runGetGuestProfile error" + errorResponse.toString());
                        if (errorResponse.responses != null && errorResponse.responses.size() > 0 && errorResponse.responses.get(0) != null && errorResponse.responses.get((int)0).getGuestProfile != null && !errorResponse.responses.get((int)0).getGuestProfile.succeeded && (areaError = errorResponse.responses.get((int)0).getGuestProfile.areaError) != null) {
                            switch (areaError) {
                                default: 
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        GuestManager.onConnectionFailed();
        return false;
    }
}

