/*
 * Decompiled with CFR 0.152.
 */
package com.irisvalet.android.apps.mobilevalethelper.service.api_calls;

import android.content.Context;
import com.google.gson.Gson;
import com.irisvalet.android.apps.mobilevalethelper.ContentManager;
import com.irisvalet.android.apps.mobilevalethelper.GuestManager;
import com.irisvalet.android.apps.mobilevalethelper.api.ApiClient;
import com.irisvalet.android.apps.mobilevalethelper.api.ApiInterface;
import com.irisvalet.android.apps.mobilevalethelper.api.Requests.LoginByRoomRequestDetails;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.LoginByRoomResponse;
import com.irisvalet.android.apps.mobilevalethelper.exception.SessionExpiredException;
import com.irisvalet.android.apps.mobilevalethelper.service.api_calls.GuestProfileAPICalls;
import com.irisvalet.android.apps.mobilevalethelper.service.api_calls.ResponseHandler;
import com.irisvalet.android.apps.mobilevalethelper.utils.DebugLog;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.Retrofit;

public class LoginByRoomAPICall {
    private static final String TAG = "LoginByRoomAPICall";

    public static boolean runLoginByRoom(Context context, ApiInterface apiService, String sessionToken, String lastName, String roomNumber) throws SessionExpiredException {
        block13: {
            Retrofit client;
            if (apiService == null && (client = ApiClient.getClient()) != null) {
                apiService = (ApiInterface)client.create(ApiInterface.class);
            }
            if (apiService == null) {
                GuestManager.onConnectionFailed();
                return false;
            }
            LoginByRoomRequestDetails data = new LoginByRoomRequestDetails();
            data.lastName = lastName;
            data.roomNumber = roomNumber;
            data.sessionToken = sessionToken;
            DebugLog.d(TAG, "runLoginByRoom");
            String strError = "Unknown error";
            try {
                Call<LoginByRoomResponse> call = apiService.doLoginByRoom(GuestManager.getEnvPath(), data);
                Response r = call.execute();
                if (ResponseHandler.checkResponse(context, r)) {
                    LoginByRoomResponse response = (LoginByRoomResponse)r.body();
                    if (response != null && response.responses != null && response.responses.size() > 0 && response.responses.get(0) != null && response.responses.get((int)0).loginGuestByRoom != null && response.responses.get((int)0).loginGuestByRoom.succeeded) {
                        try {
                            sessionToken = ContentManager.getContentSessionToken();
                            return GuestProfileAPICalls.runGetGuestProfile(context, apiService, sessionToken);
                        }
                        catch (SessionExpiredException e) {
                            e.printStackTrace();
                            return GuestProfileAPICalls.runGetGuestProfile(context, apiService, sessionToken);
                        }
                    }
                    break block13;
                }
                try {
                    ResponseBody errorBody = r.errorBody();
                    if (errorBody != null) {
                        Gson gson = new Gson();
                        LoginByRoomResponse errorResponse = (LoginByRoomResponse)gson.fromJson(errorBody.string(), LoginByRoomResponse.class);
                        if (errorResponse != null) {
                            DebugLog.e(TAG, "runLoginByRoom error" + errorResponse.toString());
                        }
                        if (errorResponse != null && errorResponse.responses != null && errorResponse.responses.size() > 0 && errorResponse.responses.get(0) != null && errorResponse.responses.get((int)0).loginGuestByRoom != null && !errorResponse.responses.get((int)0).loginGuestByRoom.succeeded) {
                            strError = errorResponse.responses.get((int)0).loginGuestByRoom.areaError;
                            DebugLog.e(TAG, "runLoginByRoom error: " + strError);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        DebugLog.d(TAG, "runLoginByRoom unknown error");
        return false;
    }
}

