/*
 * Decompiled with CFR 0.152.
 */
package com.irisvalet.android.apps.mobilevalethelper.service.api_calls;

import android.content.Context;
import com.irisvalet.android.apps.mobilevalethelper.ContentManager;
import com.irisvalet.android.apps.mobilevalethelper.GuestManager;
import com.irisvalet.android.apps.mobilevalethelper.api.ApiClient;
import com.irisvalet.android.apps.mobilevalethelper.api.ApiInterface;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.OrderHistoryResponse;
import com.irisvalet.android.apps.mobilevalethelper.exception.SessionExpiredException;
import com.irisvalet.android.apps.mobilevalethelper.service.api_calls.ResponseHandler;
import com.irisvalet.android.apps.mobilevalethelper.utils.DebugLog;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.Retrofit;

public class OrderHistoryAPICall {
    private static final String TAG = "OrderHistoryAPICall";

    public static void getOrderHistory(Context context, ApiInterface apiService, String sessionToken) throws SessionExpiredException {
        block9: {
            Retrofit client;
            if (apiService == null && (client = ApiClient.getClient()) != null) {
                apiService = (ApiInterface)client.create(ApiInterface.class);
            }
            if (apiService == null) {
                GuestManager.onConnectionFailed();
                return;
            }
            try {
                Call<OrderHistoryResponse> call = apiService.getOrderHistory(GuestManager.getEnvPath(), sessionToken);
                Response r = call.execute();
                DebugLog.d(TAG, "getOrderHistory (" + r.code() + ") " + sessionToken);
                if (ResponseHandler.checkResponse(context, r)) {
                    OrderHistoryResponse response = (OrderHistoryResponse)r.body();
                    if (response != null && response.responses != null && response.responses.size() > 0 && response.responses.get(0) != null && response.responses.get((int)0).getOrders != null && response.responses.get((int)0).getOrders.succeeded && response.responses.get((int)0).getOrders.content != null) {
                        ContentManager.saveGuestOrderHistory(response.responses.get((int)0).getOrders.content);
                        GuestManager.onGuestOrderHistorySuccess();
                        return;
                    }
                    break block9;
                }
                try {
                    ResponseBody errorBody = r.errorBody();
                    if (errorBody != null) {
                        GuestManager.onGuestOrderHistoryFailed(errorBody.string());
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        GuestManager.onGuestOrderHistoryFailed("GetGuestProfile Error");
    }
}

