/*
 * Decompiled with CFR 0.152.
 */
package com.irisvalet.android.apps.mobilevalethelper.service.api_calls;

import android.content.Context;
import com.irisvalet.android.apps.mobilevalethelper.GuestManager;
import com.irisvalet.android.apps.mobilevalethelper.api.ApiClient;
import com.irisvalet.android.apps.mobilevalethelper.api.ApiInterface;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.EncryptedURLResponse;
import com.irisvalet.android.apps.mobilevalethelper.exception.SessionExpiredException;
import com.irisvalet.android.apps.mobilevalethelper.service.api_calls.ResponseHandler;
import com.irisvalet.android.apps.mobilevalethelper.utils.DebugLog;
import java.io.IOException;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.Retrofit;

public class SectionEncryptedURL {
    private static final String TAG = "SectionEncryptedURL";

    public static void getSectionEncryptedURL(Context context, ApiInterface apiService, String sectionCode, String sessionToken) throws SessionExpiredException {
        Retrofit client;
        if (apiService == null && (client = ApiClient.getClient()) != null) {
            apiService = (ApiInterface)client.create(ApiInterface.class);
        }
        if (apiService == null) {
            GuestManager.onConnectionFailed();
            return;
        }
        DebugLog.d(TAG, "getSectionEncryptedURL");
        try {
            Call<EncryptedURLResponse> call = apiService.getSectionEncryptedURL(GuestManager.getEnvPath(), sectionCode, sessionToken);
            Response r = call.execute();
            DebugLog.d(TAG, "getSectionEncryptedURL (" + r.code() + ") " + sessionToken);
            if (ResponseHandler.checkResponse(context, r)) {
                EncryptedURLResponse response = (EncryptedURLResponse)r.body();
                if (response != null && response.responses != null && response.responses.size() > 0 && response.responses.get(0) != null && response.responses.get((int)0).getEncryptedUrl != null && response.responses.get((int)0).getEncryptedUrl.content != null && response.responses.get((int)0).getEncryptedUrl.content.encryptedUrl != null) {
                    GuestManager.onSectionEncryptedURLReceived(response.responses.get((int)0).getEncryptedUrl.content.encryptedUrl);
                    return;
                }
            } else {
                String errorResponse = r.errorBody().string();
                DebugLog.d(TAG, "errorResponse: " + errorResponse);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DebugLog.e(TAG, "getSectionEncryptedURL response.errorBody(): Error");
        GuestManager.onSectionEncryptedURLFailed("Error");
    }
}

