/*
 * Decompiled with CFR 0.152.
 */
package com.irisvalet.android.apps.mobilevalethelper.service.api_calls;

import android.content.Context;
import com.google.gson.JsonObject;
import com.irisvalet.android.apps.mobilevalethelper.ContentManager;
import com.irisvalet.android.apps.mobilevalethelper.GuestManager;
import com.irisvalet.android.apps.mobilevalethelper.ServiceManager;
import com.irisvalet.android.apps.mobilevalethelper.api.ApiClient;
import com.irisvalet.android.apps.mobilevalethelper.api.ApiInterface;
import com.irisvalet.android.apps.mobilevalethelper.api.Requests.ServiceRequestDetails;
import com.irisvalet.android.apps.mobilevalethelper.api.Requests.ServiceRequestItem;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.OutletGuestServiceRequestResponse;
import com.irisvalet.android.apps.mobilevalethelper.exception.SessionExpiredException;
import com.irisvalet.android.apps.mobilevalethelper.object.NonVerifiedGuestField;
import com.irisvalet.android.apps.mobilevalethelper.service.api_calls.ResponseHandler;
import com.irisvalet.android.apps.mobilevalethelper.utils.DebugLog;
import com.irisvalet.android.apps.mobilevalethelper.utils.TranslationUtils;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.Retrofit;

public class ServiceRequestAPICalls {
    private static final String TAG = "ServiceRequestAPICalls";

    public static void placeGuestServiceRequest(Context context, ApiInterface apiService, String sessionToken, String outletCode, String comments) throws SessionExpiredException {
        Retrofit client;
        if (apiService == null && (client = ApiClient.getClient()) != null) {
            apiService = (ApiInterface)client.create(ApiInterface.class);
        }
        if (apiService == null) {
            GuestManager.onConnectionFailed();
            return;
        }
        DebugLog.d(TAG, "placeGuestServiceRequest");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.getDefault());
        Date deliveryTime = new Date();
        if (ServiceManager.getDeliveryTime() != null) {
            deliveryTime = ServiceManager.getDeliveryTime();
        }
        ServiceRequestDetails data = new ServiceRequestDetails();
        data.sessionToken = sessionToken;
        if (ServiceManager.mIsASAP) {
            data.deliverLater = "now";
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            data.deliveryDateTime = sdf.format(deliveryTime);
            data.isDeliveryDateTimeUtc = true;
        } else {
            data.deliverLater = "later";
            data.deliveryDateTime = sdf.format(deliveryTime);
            data.isDeliveryDateTimeUtc = false;
        }
        boolean isVerifiedGuest = GuestManager.isUserExists();
        data.deliveryType = isVerifiedGuest ? "Room" : "Collection";
        data.deliveryLocationCode = null;
        if (!isVerifiedGuest && ServiceManager.getOutletSettings() != null) {
            data.orderFormDetailsDictionary = new JsonObject();
            try {
                data.orderFormDetailsDictionary.addProperty("DeliveryLocationCode", ServiceManager.getDeliveryLocationCode());
                if (ServiceManager.getNonVerifiedGuestsFields(outletCode) != null) {
                    for (NonVerifiedGuestField field : ServiceManager.getNonVerifiedGuestsFields(outletCode)) {
                        if (field == null || field.name == null) continue;
                        data.orderFormDetailsDictionary.addProperty(field.name, field.value);
                    }
                }
                int noOfGuests = 1;
                try {
                    if (ServiceManager.getOutletSettings().nonVerifiedGuestFieldMap.get("NoOfGuests") != null) {
                        noOfGuests = Integer.parseInt(ServiceManager.getOutletSettings().nonVerifiedGuestFieldMap.get("NoOfGuests"));
                    }
                }
                catch (NumberFormatException field) {
                    // empty catch block
                }
                data.orderFormDetailsDictionary.addProperty("NoOfGuests", (Number)noOfGuests);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        data.item = new ServiceRequestItem(ServiceManager.getServiceItem());
        data.item.comment = comments;
        try {
            String responseError;
            DebugLog.d(TAG, "data: " + data.toString());
            Call<OutletGuestServiceRequestResponse> call = isVerifiedGuest ? apiService.postPlaceVerifiedGuestServiceRequest(GuestManager.getEnvPath(), outletCode, outletCode, sessionToken, data) : apiService.postPlaceNonVerifiedGuestServiceRequest(GuestManager.getEnvPath(), outletCode, outletCode, sessionToken, data);
            Response r = call.execute();
            DebugLog.d(TAG, "placeGuestServiceRequest (" + r.code() + ") " + sessionToken);
            if (ResponseHandler.checkResponse(context, r)) {
                OutletGuestServiceRequestResponse response = (OutletGuestServiceRequestResponse)r.body();
                if (response != null && response.responses != null && response.responses.size() > 0 && response.responses.get(0) != null) {
                    if (isVerifiedGuest) {
                        if (response.responses.get((int)0).placeVerifiedGuestServiceRequestAsync != null && response.responses.get((int)0).placeVerifiedGuestServiceRequestAsync.succeeded && response.responses.get((int)0).placeVerifiedGuestServiceRequestAsync.content != null) {
                            ServiceManager.onPostServiceRequestSuccess(context, false);
                            return;
                        }
                    } else if (response.responses.get((int)0).placeNonVerifiedGuestServiceRequestAsync != null && response.responses.get((int)0).placeNonVerifiedGuestServiceRequestAsync.succeeded && response.responses.get((int)0).placeNonVerifiedGuestServiceRequestAsync.content != null) {
                        String orderReference = response.responses.get((int)0).placeNonVerifiedGuestServiceRequestAsync.content.sosServiceRequestId;
                        if (orderReference == null || orderReference.isEmpty()) {
                            orderReference = response.responses.get((int)0).placeNonVerifiedGuestServiceRequestAsync.content.gxpOrderReference;
                        }
                        ContentManager.saveNonVerifiedServiceRequest(data, orderReference);
                        ServiceManager.onPostServiceRequestSuccess(context, true);
                        return;
                    }
                }
            } else if (r.errorBody() != null && (responseError = r.errorBody().string()) != null) {
                DebugLog.e(TAG, "placeGuestServiceRequest: " + responseError);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ServiceManager.onPostServiceRequestFailed(context, TranslationUtils.getTranslatedString("valet_shared_label.error_occured"));
    }
}

