/*
 * Decompiled with CFR 0.152.
 */
package com.irisvalet.android.apps.mobilevalethelper.service.api_calls;

import android.content.Context;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.irisvalet.android.apps.mobilevalethelper.ContentManager;
import com.irisvalet.android.apps.mobilevalethelper.GuestManager;
import com.irisvalet.android.apps.mobilevalethelper.api.ApiClient;
import com.irisvalet.android.apps.mobilevalethelper.api.ApiInterface;
import com.irisvalet.android.apps.mobilevalethelper.api.Requests.SessionInitialiseRequestDetails;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.RegisterAssetResponseDetailsAssetContent;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.SessionInitialiseResponse;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.SessionInitialiseResponseDetails;
import com.irisvalet.android.apps.mobilevalethelper.exception.SessionExpiredException;
import com.irisvalet.android.apps.mobilevalethelper.object.User;
import com.irisvalet.android.apps.mobilevalethelper.service.api_calls.GuestProfileAPICalls;
import com.irisvalet.android.apps.mobilevalethelper.service.api_calls.LoginByRoomAPICall;
import com.irisvalet.android.apps.mobilevalethelper.service.api_calls.ResponseHandler;
import com.irisvalet.android.apps.mobilevalethelper.utils.DebugLog;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.Retrofit;

public class SessionInitialise {
    private static final String TAG = "SessionInitialise";

    public static boolean initializeSession(Context context, ApiInterface apiService, String propertyCode, String languageCode) {
        if (TextUtils.isEmpty((CharSequence)ContentManager.getAppToken())) {
            GuestManager.onAppTokenMissing();
            return false;
        }
        if (GuestManager.isGV()) {
            RegisterAssetResponseDetailsAssetContent assetContent = ContentManager.getAssetRegistration();
            if (assetContent != null && assetContent.assetKey != null && SessionInitialise.runSessionInitialiseByAssetKey(context, apiService, assetContent.assetKey, propertyCode, languageCode)) {
                return true;
            }
            if (SessionInitialise.runSessionInitialise(context, apiService, propertyCode, languageCode)) {
                return true;
            }
            GuestManager.onDevicePairingRevoked(null);
        } else if (SessionInitialise.runSessionInitialise(context, apiService, propertyCode, languageCode)) {
            User user = GuestManager.getUser();
            if (user != null) {
                String lastName = user.lastName;
                String roomNumber = user.roomNumber;
                if (!TextUtils.isEmpty((CharSequence)lastName) && !TextUtils.isEmpty((CharSequence)roomNumber)) {
                    try {
                        String sessionToken = ContentManager.getContentSessionToken();
                        if (LoginByRoomAPICall.runLoginByRoom(context, apiService, sessionToken, lastName, roomNumber)) {
                            sessionToken = ContentManager.getContentSessionToken();
                            return GuestProfileAPICalls.runGetGuestProfile(context, apiService, sessionToken);
                        }
                    }
                    catch (SessionExpiredException e1) {
                        e1.printStackTrace();
                    }
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean runSessionInitialise(Context context, ApiInterface apiService, String propertyCode, String languageCode) {
        Retrofit client;
        if (apiService == null && (client = ApiClient.getClient()) != null) {
            apiService = (ApiInterface)ApiClient.getClient().create(ApiInterface.class);
        }
        if (apiService == null) {
            GuestManager.onConnectionFailed();
            return false;
        }
        SessionInitialiseRequestDetails data = new SessionInitialiseRequestDetails();
        data.interfaceToken = ContentManager.getAppToken();
        data.propertyCode = propertyCode;
        data.languageCode = languageCode;
        if (data.interfaceToken == null) {
            GuestManager.onAppTokenMissing();
            return false;
        }
        DebugLog.d(TAG, "runSessionInitialise propertyCode: " + propertyCode + " data: " + data.toString());
        String error = "Error";
        try {
            Call<SessionInitialiseResponse> call = apiService.initializeSession(GuestManager.getEnvPath(), data);
            Response r = call.clone().execute();
            if (ResponseHandler.checkResponse(context, r)) {
                return true;
            }
            if (r.errorBody() != null) {
                error = r.errorBody().string();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            error = e.getMessage();
        }
        DebugLog.e(TAG, "runSessionInitialise response.errorBody(): " + error);
        GuestManager.onSessionInitializationError("Error");
        return false;
    }

    private static boolean runSessionInitialiseByAssetKey(Context context, ApiInterface apiService, String assetKey, String propertyCode, String languageCode) {
        block14: {
            Retrofit client;
            if (apiService == null && (client = ApiClient.getClient()) != null) {
                apiService = (ApiInterface)client.create(ApiInterface.class);
            }
            if (apiService == null) {
                GuestManager.onConnectionFailed();
                return false;
            }
            DebugLog.d(TAG, "runInitializeSessionByAssetKey");
            try {
                SessionInitialiseRequestDetails request = new SessionInitialiseRequestDetails();
                request.interfaceToken = ContentManager.getAppToken();
                request.assetKey = assetKey;
                request.propertyCode = propertyCode;
                request.languageCode = languageCode;
                Call<SessionInitialiseResponse> call = apiService.initialiseByAsset(GuestManager.getEnvPath(), request);
                Response r = call.clone().execute();
                if (ResponseHandler.checkResponse(context, r)) {
                    SessionInitialiseResponse response = (SessionInitialiseResponse)r.body();
                    boolean initialiseSession = false;
                    boolean isGuestInRoom = false;
                    if (response != null && response.responses != null && response.responses.size() > 0) {
                        for (SessionInitialiseResponseDetails responseDetails : response.responses) {
                            if (responseDetails == null) continue;
                            if (responseDetails.initialiseSession != null && responseDetails.initialiseSession.succeeded) {
                                initialiseSession = true;
                                continue;
                            }
                            if (responseDetails.initialiseSessionByAsset == null || !responseDetails.initialiseSessionByAsset.succeeded) continue;
                            isGuestInRoom = responseDetails.initialiseSessionByAsset.content != null && responseDetails.initialiseSessionByAsset.content.roomStatus != null && responseDetails.initialiseSessionByAsset.content.roomStatus.equals("RoomIsOccupied");
                        }
                        if (initialiseSession && isGuestInRoom && GuestProfileAPICalls.runGetGuestProfile(context, apiService, ContentManager.getContentSessionToken())) {
                            GuestManager.onGuestCheckedInSuccess();
                        } else {
                            GuestManager.onGuestCheckedOut();
                        }
                        return true;
                    }
                    break block14;
                }
                Gson gson = new Gson();
                SessionInitialiseResponse errorBody = null;
                try {
                    errorBody = (SessionInitialiseResponse)gson.fromJson(r.errorBody().string(), SessionInitialiseResponse.class);
                }
                catch (JsonSyntaxException e) {
                    e.printStackTrace();
                }
                if (errorBody != null && errorBody.responses != null && errorBody.responses.get(0) != null && errorBody.responses.get((int)0).initialiseSessionByAsset != null && !errorBody.responses.get((int)0).initialiseSessionByAsset.succeeded && errorBody.responses.get((int)0).initialiseSessionByAsset.areaError != null) {
                    String areaError = errorBody.responses.get((int)0).initialiseSessionByAsset.areaError;
                    DebugLog.e(TAG, "runInitializeSessionByAsseteKey response.errorBody(): " + areaError);
                    if (areaError.equals("Invalid asset key")) {
                        GuestManager.onDevicePairingRevoked(areaError);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

