/*
 * Decompiled with CFR 0.152.
 */
package com.irisvalet.android.apps.mobilevalethelper.service.api_calls;

import android.content.Context;
import com.irisvalet.android.apps.mobilevalethelper.ContentManager;
import com.irisvalet.android.apps.mobilevalethelper.GuestManager;
import com.irisvalet.android.apps.mobilevalethelper.LanguagesManager;
import com.irisvalet.android.apps.mobilevalethelper.api.ApiClient;
import com.irisvalet.android.apps.mobilevalethelper.api.ApiInterface;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.SettingsResponse;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.SettingsResponseDetails;
import com.irisvalet.android.apps.mobilevalethelper.service.api_calls.ResponseHandler;
import com.irisvalet.android.apps.mobilevalethelper.utils.DebugLog;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.Retrofit;

public class SettingsAPICalls {
    private static final String TAG = "SettingsAPICalls";

    public static boolean getSettings(Context context, ApiInterface apiService, String propertyCode, String languageCode, int version) {
        Retrofit client;
        if (apiService == null && (client = ApiClient.getClient()) != null) {
            apiService = (ApiInterface)client.create(ApiInterface.class);
        }
        if (apiService == null) {
            GuestManager.onConnectionFailed();
            return false;
        }
        try {
            SettingsResponse response;
            Call<SettingsResponse> call = apiService.getSettings(GuestManager.getEnvPath(), ContentManager.getContentSessionToken());
            Response r = call.execute();
            DebugLog.d(TAG, "getSettings (" + r.code() + ") " + ContentManager.getContentSessionToken());
            if (ResponseHandler.checkResponse(context, r) && (response = (SettingsResponse)r.body()) != null && response.responses != null && response.responses.size() > 0) {
                boolean getCartSettings = false;
                boolean getCMSSettings = false;
                boolean getLanguages = false;
                boolean getPropertySettings = false;
                boolean getOutletSettings = false;
                for (SettingsResponseDetails settings : response.responses) {
                    if (settings == null) continue;
                    if (settings.getCartSettings != null && settings.getCartSettings.succeeded && settings.getCartSettings.content != null) {
                        ContentManager.setCartSettings(propertyCode, version, settings.getCartSettings.content);
                        getCartSettings = true;
                        continue;
                    }
                    if (settings.getCMSSettings != null && settings.getCMSSettings.succeeded && settings.getCMSSettings.content != null) {
                        ContentManager.setCMSSettings(propertyCode, version, settings.getCMSSettings.content);
                        getCMSSettings = true;
                        continue;
                    }
                    if (settings.getLanguages != null && settings.getLanguages.succeeded && settings.getLanguages.content != null && settings.getLanguages.content.languages != null) {
                        LanguagesManager.setLanguages(propertyCode, version, settings.getLanguages.content);
                        getLanguages = true;
                        continue;
                    }
                    if (settings.getPropertySettings != null && settings.getPropertySettings.succeeded && settings.getPropertySettings.content != null) {
                        ContentManager.setPropertySettings(propertyCode, version, settings.getPropertySettings.content);
                        getPropertySettings = true;
                        continue;
                    }
                    if (settings.getOutletSettings == null || !settings.getOutletSettings.succeeded || settings.getOutletSettings.content == null || settings.getOutletSettings.content.outletSettings == null) continue;
                    ContentManager.setOutletSettings(propertyCode, version, settings.getOutletSettings.content.outletSettings);
                    getOutletSettings = true;
                }
                return getCartSettings && getCMSSettings && getLanguages && getPropertySettings && getOutletSettings;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DebugLog.e(TAG, "getSettings response.errorBody(): Error");
        GuestManager.onContentFailed("Error");
        return false;
    }
}

