/*
 * Decompiled with CFR 0.152.
 */
package com.irisvalet.android.apps.mobilevalethelper.utils;

import com.irisvalet.android.apps.mobilevalethelper.ContentManager;
import com.irisvalet.android.apps.mobilevalethelper.object.AvailabilitySummary;
import com.irisvalet.android.apps.mobilevalethelper.object.AvailabilitySummaryItem;
import com.irisvalet.android.apps.mobilevalethelper.object.AvailabilitySummaryPeriod;
import com.irisvalet.android.apps.mobilevalethelper.object.CategoryItem;
import com.irisvalet.android.apps.mobilevalethelper.object.Section;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

public class AvailabilityUtils {
    public static Availability isCategoryItemAvailable(Section section, CategoryItem item, Date deliveryTime) {
        Availability sectionAvailability;
        if (item == null || deliveryTime == null) {
            return Availability.N_A;
        }
        if (section == null) {
            section = ContentManager.getSection(item.sectionCode);
        }
        if ((sectionAvailability = AvailabilityUtils.isSectionAvailable(section, deliveryTime)) == Availability.NOT_AVAILABLE) {
            return Availability.NOT_AVAILABLE;
        }
        Availability itemAvailability = AvailabilityUtils.checkAvailabilitySummary(item.availabilitySummary, deliveryTime);
        if (itemAvailability != Availability.N_A) {
            return itemAvailability;
        }
        return sectionAvailability;
    }

    public static Availability isSectionAvailable(Section section, Date deliveryTime) {
        if (section == null || deliveryTime == null) {
            return Availability.N_A;
        }
        return AvailabilityUtils.checkAvailabilitySummary(section.availabilitySummary, deliveryTime);
    }

    private static Availability checkAvailabilitySummary(AvailabilitySummary availabilitySummary, Date deliveryTime) {
        if (availabilitySummary != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(deliveryTime);
            int dayOfWeek = c.get(7);
            int minuteOfDay = 60 * c.get(11) + c.get(12);
            switch (dayOfWeek) {
                case 2: {
                    if (availabilitySummary.monday == null) {
                        return Availability.N_A;
                    }
                    return AvailabilityUtils.checkAvailabilityDaySlots(availabilitySummary.monday, minuteOfDay);
                }
                case 3: {
                    if (availabilitySummary.tuesday == null) {
                        return Availability.N_A;
                    }
                    return AvailabilityUtils.checkAvailabilityDaySlots(availabilitySummary.tuesday, minuteOfDay);
                }
                case 4: {
                    if (availabilitySummary.wednesday == null) {
                        return Availability.N_A;
                    }
                    return AvailabilityUtils.checkAvailabilityDaySlots(availabilitySummary.wednesday, minuteOfDay);
                }
                case 5: {
                    if (availabilitySummary.thursday == null) {
                        return Availability.N_A;
                    }
                    return AvailabilityUtils.checkAvailabilityDaySlots(availabilitySummary.thursday, minuteOfDay);
                }
                case 6: {
                    if (availabilitySummary.friday == null) {
                        return Availability.N_A;
                    }
                    return AvailabilityUtils.checkAvailabilityDaySlots(availabilitySummary.friday, minuteOfDay);
                }
                case 7: {
                    if (availabilitySummary.saturday == null) {
                        return Availability.N_A;
                    }
                    return AvailabilityUtils.checkAvailabilityDaySlots(availabilitySummary.saturday, minuteOfDay);
                }
                case 1: {
                    if (availabilitySummary.sunday == null) {
                        return Availability.N_A;
                    }
                    return AvailabilityUtils.checkAvailabilityDaySlots(availabilitySummary.sunday, minuteOfDay);
                }
            }
        }
        return Availability.N_A;
    }

    private static Availability checkAvailabilityDaySlots(AvailabilitySummaryItem day, int minuteOfDay) {
        if (day != null && day.periods != null && day.periods.size() > 0) {
            for (AvailabilitySummaryPeriod period : day.periods) {
                if (minuteOfDay < period.start || minuteOfDay > period.end) continue;
                return Availability.AVAILABLE;
            }
            return Availability.NOT_AVAILABLE;
        }
        return Availability.N_A;
    }

    private static ArrayList<String> createAvailabilityPeriods(AvailabilitySummaryItem day) {
        ArrayList<String> availabilityPeriodStrings = null;
        if (day != null && day.periods != null && day.periods.size() > 0) {
            availabilityPeriodStrings = new ArrayList<String>();
            for (AvailabilitySummaryPeriod period : day.periods) {
                availabilityPeriodStrings.add(period.format());
            }
        }
        return availabilityPeriodStrings;
    }

    public static ArrayList<String> getCategoryItemAvailabilityPeriods(Section section, CategoryItem item, Date deliveryTime) {
        ArrayList<String> availabilityPeriods;
        if (deliveryTime == null) {
            return null;
        }
        if (item.availabilitySummary != null && (availabilityPeriods = AvailabilityUtils.createAvailabilityPeriods(item.availabilitySummary, deliveryTime)) != null && availabilityPeriods.size() > 0) {
            return availabilityPeriods;
        }
        if (section == null) {
            section = ContentManager.getSection(item.sectionCode);
        }
        return AvailabilityUtils.getSectionAvailabilityPeriods(section, deliveryTime);
    }

    private static ArrayList<String> getSectionAvailabilityPeriods(Section section, Date deliveryTime) {
        if (deliveryTime == null || section == null || section.availabilitySummary == null) {
            return null;
        }
        return AvailabilityUtils.createAvailabilityPeriods(section.availabilitySummary, deliveryTime);
    }

    private static ArrayList<String> createAvailabilityPeriods(AvailabilitySummary availabilitySummary, Date deliveryTime) {
        Calendar c = Calendar.getInstance();
        c.setTime(deliveryTime);
        int dayOfWeek = c.get(7);
        switch (dayOfWeek) {
            case 2: {
                return AvailabilityUtils.createAvailabilityPeriods(availabilitySummary.monday);
            }
            case 3: {
                return AvailabilityUtils.createAvailabilityPeriods(availabilitySummary.tuesday);
            }
            case 4: {
                return AvailabilityUtils.createAvailabilityPeriods(availabilitySummary.wednesday);
            }
            case 5: {
                return AvailabilityUtils.createAvailabilityPeriods(availabilitySummary.thursday);
            }
            case 6: {
                return AvailabilityUtils.createAvailabilityPeriods(availabilitySummary.friday);
            }
            case 7: {
                return AvailabilityUtils.createAvailabilityPeriods(availabilitySummary.saturday);
            }
            case 1: {
                return AvailabilityUtils.createAvailabilityPeriods(availabilitySummary.sunday);
            }
        }
        return null;
    }

    public static enum Availability {
        AVAILABLE,
        NOT_AVAILABLE,
        N_A;

    }
}

