/*
 * Decompiled with CFR 0.152.
 */
package com.irisvalet.android.apps.mobilevalethelper.utils;

import com.irisvalet.android.apps.mobilevalethelper.utils.DebugLog;
import java.io.UnsupportedEncodingException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class CryptoUtils {
    public static final String TAG = "CryptoUtils";
    private static Cipher cipher;
    private static byte[] IV;

    private static void initCipher(String encryptionKey) throws NoSuchAlgorithmException, NoSuchPaddingException, UnsupportedEncodingException, InvalidKeyException, InvalidAlgorithmParameterException {
        cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        SecretKeySpec keySpec = new SecretKeySpec(encryptionKey.getBytes("UTF-8"), "AES");
        cipher.init(1, keySpec);
    }

    private static byte[] createRandomSalt() {
        SecureRandom RANDOM = new SecureRandom();
        byte[] salt = new byte[16];
        ((Random)RANDOM).nextBytes(salt);
        return salt;
    }

    public byte[] encrypt(String stringToHash, String encryptionKey) throws UnsupportedEncodingException {
        try {
            byte[] inputBytes = stringToHash.getBytes("UTF-8");
            CryptoUtils.initCipher(encryptionKey);
            AlgorithmParameters params = cipher.getParameters();
            byte[] iv = params.getParameterSpec(IvParameterSpec.class).getIV();
            byte[] cipherText = cipher.doFinal(inputBytes);
            byte[] encryptedBytes = new byte[iv.length + cipherText.length];
            System.arraycopy(iv, 0, encryptedBytes, 0, iv.length);
            System.arraycopy(cipherText, 0, encryptedBytes, iv.length, cipherText.length);
            return encryptedBytes;
        }
        catch (IllegalBlockSizeException e) {
            DebugLog.e(TAG, "The length of data provided to a block cipher is incorrect " + e);
        }
        catch (BadPaddingException e) {
            DebugLog.e(TAG, "The input data but the data is not padded properly " + e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    static {
        IV = null;
    }
}

