/*
 * Decompiled with CFR 0.152.
 */
package com.irisvalet.android.apps.mobilevalethelper.utils;

import android.content.Context;
import android.os.Environment;
import com.irisvalet.android.apps.mobilevalethelper.utils.DebugLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public class DatabaseBackupUtils {
    private static final String TAG = "DatabaseBackupUtils";

    public static void backupDatabaseToSD(Context context, String propertyCode) {
        if (!"release".toLowerCase().contains("debug")) {
            return;
        }
        try {
            DebugLog.d(TAG, "backupDatabaseToSD: " + propertyCode);
            File sourceFile = DatabaseBackupUtils.getDatabaseFile(context);
            String strPath = "/iRiS/";
            File destinationDirectory = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS) + strPath);
            if (destinationDirectory.exists() || destinationDirectory.mkdir()) {
                File destFile = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS) + strPath + propertyCode + "_database_file.db");
                DatabaseBackupUtils.copyFile(sourceFile, destFile);
                DebugLog.d(TAG, "backupDatabaseToSD: completed: " + destFile.toString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void copyDataBase(InputStream sourceFile, String destinationFolder) throws IOException {
        File destinationDirectory = new File(destinationFolder);
        if (destinationDirectory.exists() || destinationDirectory.mkdir()) {
            int length;
            String outFileName = destinationFolder + "/" + "NATIVE_MOBILE_VALET_DB.db";
            FileOutputStream myOutput = new FileOutputStream(outFileName);
            byte[] buffer = new byte[1024];
            while ((length = sourceFile.read(buffer)) > 0) {
                ((OutputStream)myOutput).write(buffer, 0, length);
            }
            myOutput.flush();
            ((OutputStream)myOutput).close();
            sourceFile.close();
        }
    }

    private static File getDatabaseFile(Context context) {
        try {
            return context.getDatabasePath("NATIVE_MOBILE_VALET_DB.db");
        }
        catch (Exception e) {
            DebugLog.e(TAG, "getDatabaseFolder Caught Exception" + e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File sourceFile, File destFile) throws IOException {
        DebugLog.d(TAG, "copyFile sourceFile: " + sourceFile.toString() + " to destFile: " + destFile.toString());
        if (destFile.exists() || destFile.createNewFile()) {
            FileChannel source = null;
            AbstractInterruptibleChannel destination = null;
            try {
                source = new FileInputStream(sourceFile).getChannel();
                destination = new FileOutputStream(destFile).getChannel();
                ((FileChannel)destination).transferFrom(source, 0L, source.size());
            }
            catch (Exception e) {
                DebugLog.e(TAG, "copyFile Caught Exception" + e.getMessage());
            }
            finally {
                if (source != null) {
                    source.close();
                }
                if (destination != null) {
                    destination.close();
                }
            }
        }
    }
}

