/*
 * Decompiled with CFR 0.152.
 */
package com.irisvalet.android.apps.mobilevalethelper.utils;

import android.content.Context;
import android.text.TextUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.irisvalet.android.apps.mobilevalethelper.ContentManager;
import com.irisvalet.android.apps.mobilevalethelper.GuestManager;
import com.irisvalet.android.apps.mobilevalethelper.LanguagesManager;
import com.irisvalet.android.apps.mobilevalethelper.utils.DebugLog;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class TranslationUtils {
    private static final String TAG = "TranslationUtils";
    public static Map<String, JsonObject> mStaticContentData = new HashMap<String, JsonObject>();
    private static String mLanguageCode = null;
    private static Map<String, String> mTranslationDictionary = new HashMap<String, String>();

    public static String getTranslatedString(Context context, int resourceId) {
        String value;
        DebugLog.d(TAG, "getTranslatedString: " + resourceId);
        String resourceName = context.getResources().getResourceEntryName(resourceId);
        if (!TextUtils.isEmpty((CharSequence)resourceName) && !TextUtils.isEmpty((CharSequence)(value = TranslationUtils.getTranslatedString(resourceName)))) {
            return value;
        }
        String string = context.getString(resourceId);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        DebugLog.e(TAG, "Translation failed, resource not found !!!!!!!!!!!!!!!!!!!!!!");
        return "";
    }

    public static String getTranslatedString(String resourceName) {
        String result;
        String langCode = LanguagesManager.getSelectedLanguageCode();
        if (mLanguageCode == null || !mLanguageCode.equals(langCode) || mTranslationDictionary == null || mTranslationDictionary.size() == 0) {
            TranslationUtils.initializeDictionary(langCode);
        }
        if (mTranslationDictionary != null && (result = mTranslationDictionary.get(resourceName)) != null) {
            return TranslationUtils.parseTokenizedValues(result);
        }
        DebugLog.e(TAG, "Translation not found !!!!!!!!!!!!!!!!!!!!!! for " + resourceName);
        return resourceName;
    }

    public static String parseTokenizedValues(String value) {
        if (value != null) {
            value = value.replace("{prefix}", GuestManager.getGuestTitle()).replace("{title}", GuestManager.getGuestTitle()).replace("{lastName}", GuestManager.getGuestLastName()).replace("{surname}", GuestManager.getGuestLastName()).replace("{firstName}", GuestManager.getGuestFirstName()).replace("{name}", GuestManager.getGuestFullName()).replace("{guestName}", GuestManager.getGuestFullNameWithTitle()).replace("{roomNumber}", GuestManager.getRoomNumber()).replace("&nbsp;", " ");
        }
        return value;
    }

    private static void initializeDictionary(String langCode) {
        JsonObject data;
        mLanguageCode = langCode;
        if (mStaticContentData == null) {
            mStaticContentData = new HashMap<String, JsonObject>();
        }
        if ((data = mStaticContentData.get(mLanguageCode)) == null) {
            data = ContentManager.getStaticContent();
        }
        if (data != null) {
            mTranslationDictionary = new HashMap<String, String>();
            DebugLog.d(TAG, "insertStaticContent for Language: " + langCode);
            JsonObject element = (JsonObject)data.get(langCode);
            if (element != null) {
                Set set = element.entrySet();
                for (Map.Entry entry : set) {
                    try {
                        if (entry == null || TextUtils.isEmpty((CharSequence)((CharSequence)entry.getKey())) || TextUtils.isEmpty((CharSequence)((JsonElement)entry.getValue()).getAsString())) continue;
                        mTranslationDictionary.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static String translate(String string) {
        return string;
    }

    public static boolean checkStaticContentForLanguage(String propertyCode, String langCode) {
        JsonObject data = mStaticContentData.get(mLanguageCode);
        if (data == null) {
            data = ContentManager.getStaticContent(propertyCode, langCode);
        }
        return data != null;
    }
}

