package com.irisvalet.android.apps.mobile_key_lib;

import android.content.Context;

import com.irisvalet.android.apps.mobile_key.MobileWalletKey;

import java.util.ArrayList;

/**
 * Created by golanshay on 04/05/2017.
 */

public interface MobileKeyLibInterface {

    void onDeviceInitializationStarted();
    void onDeviceInitializationCompleted(Object data);
    void onDeviceInitializationFailed(String error);

    void onRegistrationStarted();
    void onRegistrationCompleted(Object data);
    void onRegistrationFailed(String error);

    void onUnRegistrationStarted();
    void onUnRegistrationCompleted(Object data);
    void onUnRegistrationFailed(String error);

    void onKeyRequestStarted();
    void onKeysRefreshCompleted(ArrayList<MobileWalletKey> keys);
    void onKeysRefreshFailed(String error);

    void onKeysRefreshStarted();
    void onKeyRequestCompleted(ArrayList<MobileWalletKey> keys);
    void onKeyRequestFailed(String error);

    void onLockAccessStarted();
    void onLockAccessGranted();
    void onLockAccessFailed(String error);

    void onBluetoothEnabled();
    void onBluetoothFailed();
    void onBluetoothNotSupported();

    Context getApplicationContext();
    Context getContext();
}
