package com.irisvalet.android.apps.mobile_key_lib;

import android.content.Context;

import com.google.gson.JsonObject;
import com.irisvalet.android.apps.mobile_key.MobileKey;
import com.irisvalet.android.apps.mobile_key.MobileKeyInterface;
import com.irisvalet.android.apps.mobile_key.MobileWalletKey;

import java.util.ArrayList;

/**
 * Created by golanshay on 16/01/2018.
 */

public class MobileKeyManager implements MobileKeyLibFactory, MobileKeyInterface {

    private static final String TAG = "MobileKeyManager";
    private static MobileKeyLibInterface mContext;
    private MobileKey mMobileKeyManager;

    public MobileKeyManager(MobileKeyLibInterface context) {
        mContext = context;
        mMobileKeyManager = new MobileKey(this);
    }

    public void setContext(MobileKeyLibInterface context) {
        mContext = context;
    }

    @Override
    public Context getApplicationContext() {
        if (mContext != null)
            return mContext.getApplicationContext();
        return null;
    }

    @Override
    public Context getContext() {
        return (Context) mContext;
    }

    @Override
    public boolean isReady() {
        return (mMobileKeyManager != null && mMobileKeyManager.isReady());
    }

    @Override
    public void initialize(JsonObject settings) {
        DebugLog.d(TAG, "initialize");
        if (mMobileKeyManager != null) {
            mMobileKeyManager.initialize(settings);
        }
    }

    @Override
    public void register(String deviceId, String pin, String lastName, String roomNumber) {
        DebugLog.d(TAG, "register");
        if (mMobileKeyManager != null) {
            mMobileKeyManager.register(deviceId, pin, lastName, roomNumber);
        }
    }

    @Override
    public void unRegister() {
        DebugLog.d(TAG, "unRegister");
        if (mMobileKeyManager != null) {
            mMobileKeyManager.unRegister();
        }
    }

    @Override
    public void requestKeys(Object data) {
        DebugLog.d(TAG, "requestKeys");
        if (mMobileKeyManager != null) {
            mMobileKeyManager.requestKeys(data);
        }
    }

    @Override
    public void refreshKeys() {
        DebugLog.d(TAG, "refreshKeys");
        if (mMobileKeyManager != null) {
            mMobileKeyManager.refreshKeys();
        }
    }

    @Override
    public void accessLock() {
        DebugLog.d(TAG, "accessLock");
        if (mMobileKeyManager != null) {
            mMobileKeyManager.accessLock();
        }
    }

    public void onDestroy() {
        if (mMobileKeyManager != null)
            mMobileKeyManager.onDestroy();
    }

    @Override
    public void onDeviceInitializationStarted() {
        DebugLog.d(TAG, "onDeviceInitializationStarted");
        if (mContext != null) {
            mContext.onDeviceInitializationStarted();
        }
    }

    @Override
    public void onDeviceInitializationCompleted(Object data) {
        DebugLog.d(TAG, "onDeviceInitializationCompleted");
        if (mContext != null) {
            mContext.onDeviceInitializationCompleted(data);
        }
    }

    @Override
    public void onDeviceInitializationFailed(String error) {
        DebugLog.d(TAG, "onDeviceInitializationFailed " + error);
        if (mContext != null) {
            mContext.onDeviceInitializationFailed(error);
        }
    }

    @Override
    public void onRegistrationStarted() {
        DebugLog.d(TAG, "onRegistrationStarted");
        if (mContext != null) {
            mContext.onRegistrationStarted();
        }
    }

    @Override
    public void onRegistrationCompleted(Object data) {
        DebugLog.d(TAG, "onRegistrationCompleted");
        if (mContext != null) {
            mContext.onRegistrationCompleted(data);
        }
    }

    @Override
    public void onRegistrationFailed(String error) {
        DebugLog.d(TAG, "onRegistrationFailed " + error);
        if (mContext != null) {
            mContext.onRegistrationFailed(error);
        }
    }

    @Override
    public void onUnRegistrationStarted() {
        DebugLog.d(TAG, "onUnRegistrationStarted");
        if (mContext != null) {
            mContext.onUnRegistrationStarted();
        }
    }

    @Override
    public void onUnRegistrationCompleted(Object data) {
        DebugLog.d(TAG, "onUnRegistrationCompleted");
        if (mContext != null) {
            mContext.onUnRegistrationCompleted(data);
        }
    }

    @Override
    public void onUnRegistrationFailed(String error) {
        DebugLog.d(TAG, "onUnRegistrationFailed " + error);
        if (mContext != null) {
            mContext.onUnRegistrationFailed(error);
        }
    }

    @Override
    public void onKeyRequestStarted() {
        DebugLog.d(TAG, "onKeyRequestStarted");
        if (mContext != null) {
            mContext.onKeyRequestStarted();
        }
    }

    @Override
    public void onKeysRefreshCompleted(ArrayList<MobileWalletKey> keys) {
        DebugLog.d(TAG, "onKeysRefreshCompleted");
        if (mContext != null) {
            mContext.onKeysRefreshCompleted(keys);
        }
    }

    @Override
    public void onKeysRefreshFailed(String error) {
        DebugLog.d(TAG, "onKeysRefreshFailed " + error);
        if (mContext != null) {
            mContext.onKeysRefreshFailed(error);
        }
    }

    @Override
    public void onKeysRefreshStarted() {
        DebugLog.d(TAG, "onKeysRefreshStarted");
        if (mContext != null) {
            mContext.onKeysRefreshStarted();
        }
    }

    @Override
    public void onKeyRequestCompleted(ArrayList<MobileWalletKey> keys) {
        DebugLog.d(TAG, "onKeyRequestCompleted");
        if (mContext != null) {
            mContext.onKeyRequestCompleted(keys);
        }
    }

    @Override
    public void onKeyRequestFailed(String error) {
        DebugLog.d(TAG, "onKeyRequestFailed " + error);
        if (mContext != null) {
            mContext.onKeyRequestFailed(error);
        }
    }

    @Override
    public void onLockAccessStarted() {
        DebugLog.d(TAG, "onLockAccessStarted");
        if (mContext != null) {
            mContext.onLockAccessStarted();
        }
    }

    @Override
    public void onLockAccessGranted() {
        DebugLog.d(TAG, "onLockAccessGranted");
        if (mContext != null) {
            mContext.onLockAccessGranted();
        }
    }

    @Override
    public void onLockAccessFailed(String error) {
        DebugLog.d(TAG, "onLockAccessFailed " + error);
        if (mContext != null) {
            mContext.onLockAccessFailed(error);
        }
    }

    @Override
    public void onBluetoothEnabled() {
        DebugLog.d(TAG, "onBluetoothEnabled");
        if (mContext != null) {
            mContext.onBluetoothEnabled();
        }
    }

    @Override
    public void onBluetoothFailed() {
        DebugLog.d(TAG, "onBluetoothFailed");
        if (mContext != null) {
            mContext.onBluetoothFailed();
        }
    }

    @Override
    public void onBluetoothNotSupported() {
        DebugLog.d(TAG, "onBluetoothNotSupported");
        if (mContext != null) {
            mContext.onBluetoothNotSupported();
        }
    }

    @Override
    public void cancelLockAccess() {
        DebugLog.d(TAG, "cancelLockAccess");

    }

    @Override
    public void revokeKeys() {
        DebugLog.d(TAG, "revokeKeys");
        mMobileKeyManager.revokeKeys();
    }

}
