/*
 * Decompiled with CFR 0.152.
 */
package com.saltosystems.justinmobile.sdk.ble;

import android.annotation.TargetApi;
import android.app.Service;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import com.saltosystems.justinmobile.obscured.E;
import com.saltosystems.justinmobile.obscured.R;
import com.saltosystems.justinmobile.obscured.af;
import com.saltosystems.justinmobile.sdk.ble.c;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

abstract class b
extends Service
implements c {
    private static final String TAG = R.a(b.class);
    private static final int STATE_DISCONNECTED = 0;
    private static final int STATE_CONNECTING = 1;
    private static final int STATE_CONNECTED = 2;
    private final Object mGattLock = new Object();
    private final IBinder mBinder = new a();
    private BluetoothManager mBluetoothManager;
    private BluetoothAdapter mBluetoothAdapter;
    private BluetoothGatt mBluetoothGatt;
    private int mConnectionState = 0;
    private final BluetoothGattCallback mGattCallback = new BluetoothGattCallback(){

        public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
            if (newState == 2) {
                if (b.this.mConnectionState == 2) {
                    R.a(TAG, "Received Connected state when already connected");
                    return;
                }
                String string = "com.saltosystems.bluetooth.ACTION_GATT_CONNECTED";
                b.this.mConnectionState = 2;
                b.this.broadcastUpdate(string);
                R.a(TAG, "Connected to GATT server.");
                R.a(TAG, "Attempting to start service discovery");
                if (b.this.mBluetoothGatt != null) {
                    b.this.mBluetoothGatt.discoverServices();
                } else {
                    R.a(TAG, "Attempting to discoer services when BluetoothGatt is null");
                }
            } else if (newState == 0) {
                String string = "com.saltosystems.bluetooth.ACTION_GATT_DISCONNECTED";
                b.this.mConnectionState = 0;
                R.a(TAG, "Disconnected from GATT server.");
                b.this.close();
                b.this.broadcastUpdate(string);
            }
        }

        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            if (status == 0) {
                R.a(TAG, "Services Successfully discovered");
                b.this.broadcastUpdate("com.saltosystems.bluetooth.ACTION_GATT_SERVICES_DISCOVERED");
            } else {
                R.a(TAG, "onServicesDiscovered received: " + status);
            }
        }

        public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            if (status == 0) {
                b.this.broadcastUpdate("com.saltosystems.bluetooth.ACTION_DATA_AVAILABLE", characteristic);
            }
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            b.this.broadcastUpdate("com.saltosystems.bluetooth.ACTION_DATA_AVAILABLE", characteristic);
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            super.onCharacteristicWrite(gatt, characteristic, status);
            if (status == 0) {
                b.this.broadcastUpdate("com.saltosystems.bluetooth.ACTION_DATA_WRITE_FINISHED", characteristic);
            }
        }

        public void onReliableWriteCompleted(BluetoothGatt gatt, int status) {
            super.onReliableWriteCompleted(gatt, status);
        }

        public void onReadRemoteRssi(BluetoothGatt gatt, int rssi, int status) {
            super.onReadRemoteRssi(gatt, rssi, status);
        }

        public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            if (status == 0) {
                b.this.broadcastUpdate("com.saltosystems.bluetooth.ACTION_GATT_WROTE_DESCRIPTOR", descriptor);
            }
        }
    };

    b() {
    }

    private void broadcastUpdate(String action) {
        Intent intent = new Intent(action);
        this.sendBroadcast(intent);
    }

    private void broadcastUpdate(String action, BluetoothGattCharacteristic characteristic) {
        Intent intent = new Intent(action);
        byte[] byArray = characteristic.getValue();
        if (byArray != null && byArray.length > 0) {
            intent.putExtra("com.saltosystems.bluetooth.EXTRA_DATA", E.a(byArray));
        }
        this.sendBroadcast(intent);
    }

    private void broadcastUpdate(String action, BluetoothGattDescriptor descriptor) {
        Intent intent = new Intent(action);
        byte[] byArray = descriptor.getValue();
        if (byArray != null && byArray.length > 0) {
            intent.putExtra("com.saltosystems.bluetooth.EXTRA_DATA", E.a(byArray));
        }
        this.sendBroadcast(intent);
    }

    public IBinder onBind(Intent intent) {
        return this.mBinder;
    }

    public boolean onUnbind(Intent intent) {
        this.close();
        return super.onUnbind(intent);
    }

    @Override
    public boolean initialize() {
        if (this.mBluetoothManager == null) {
            this.mBluetoothManager = (BluetoothManager)this.getSystemService("bluetooth");
            if (this.mBluetoothManager == null) {
                R.e(TAG, "Unable to initialize BluetoothManager.");
                return false;
            }
        }
        this.mBluetoothAdapter = this.mBluetoothManager.getAdapter();
        if (this.mBluetoothAdapter == null) {
            R.e(TAG, "Unable to obtain a BluetoothAdapter.");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TargetApi(value=23)
    public boolean connect(String address) {
        if (this.mBluetoothAdapter == null || address == null) {
            R.a(TAG, "BluetoothAdapter not initialized or unspecified address.");
            return false;
        }
        Object object = this.mGattLock;
        synchronized (object) {
            BluetoothDevice bluetoothDevice;
            if (this.mBluetoothGatt != null) {
                R.c(TAG, "gatt.close() when connect()");
                this.mBluetoothGatt.close();
                this.mBluetoothGatt = null;
            }
            if ((bluetoothDevice = this.mBluetoothAdapter.getRemoteDevice(address)) == null) {
                R.a(TAG, "Device not found.  Unable to connect.");
                return false;
            }
            if (af.g()) {
                R.c(TAG, "===== Attempting LE TRANSPORT (Marshmallow) =====");
                this.mBluetoothGatt = bluetoothDevice.connectGatt((Context)this, false, this.mGattCallback, 2);
            } else if (af.f()) {
                try {
                    R.c(TAG, "===== Attempting LE TRANSPORT (Lollipop - Reflection) =====");
                    Method method = bluetoothDevice.getClass().getDeclaredMethod("connectGatt", Context.class, Boolean.TYPE, BluetoothGattCallback.class, Integer.TYPE);
                    int n2 = bluetoothDevice.getClass().getDeclaredField("TRANSPORT_LE").getInt(null);
                    this.mBluetoothGatt = (BluetoothGatt)method.invoke((Object)bluetoothDevice, this, false, this.mGattCallback, n2);
                }
                catch (Exception exception) {
                    R.c(TAG, "===== Attempting fallback (Lollipop - Reflection) =====", exception);
                    this.mBluetoothGatt = bluetoothDevice.connectGatt((Context)this, false, this.mGattCallback);
                }
            } else {
                R.c(TAG, "===== Attempting LE TRANSPORT (Pre-Lollipop - Classic) =====");
                this.mBluetoothGatt = bluetoothDevice.connectGatt((Context)this, false, this.mGattCallback);
            }
            R.a(TAG, "Trying to create a new connection.");
            this.mConnectionState = 1;
            return true;
        }
    }

    @Override
    public void disconnect() {
        if (this.mBluetoothAdapter == null || this.mBluetoothGatt == null) {
            R.a(TAG, "BluetoothAdapter not initialized");
            return;
        }
        this.mBluetoothGatt.disconnect();
    }

    @Override
    public void close() {
        R.a(TAG, "BluetoothLeService Close");
        if (this.mBluetoothGatt == null) {
            return;
        }
        this.mBluetoothGatt.close();
        this.mBluetoothGatt = null;
    }

    @Override
    public boolean isConnected() {
        return this.mBluetoothManager != null && !this.mBluetoothManager.getConnectedDevices(7).isEmpty();
    }

    @Override
    public boolean readCharacteristic(BluetoothGattCharacteristic characteristic) {
        if (this.mBluetoothAdapter == null || this.mBluetoothGatt == null) {
            R.a(TAG, "BluetoothAdapter not initialized");
            return false;
        }
        return this.mBluetoothGatt.readCharacteristic(characteristic);
    }

    @Override
    public boolean writeCharacteristic(BluetoothGattCharacteristic characteristic) {
        if (this.mBluetoothAdapter == null || this.mBluetoothGatt == null) {
            R.a(TAG, "BluetoothAdapter not initialized");
            return false;
        }
        return this.mBluetoothGatt.writeCharacteristic(characteristic);
    }

    @Override
    public boolean setCharacteristicNotification(BluetoothGattCharacteristic characteristic, boolean enabled) {
        if (this.mBluetoothAdapter == null || this.mBluetoothGatt == null) {
            R.a(TAG, "BluetoothAdapter not initialized");
            return false;
        }
        boolean bl = this.mBluetoothGatt.setCharacteristicNotification(characteristic, enabled);
        BluetoothGattDescriptor bluetoothGattDescriptor = characteristic.getDescriptor(UUID.fromString("00002902-0000-1000-8000-00805F9B34FB"));
        bluetoothGattDescriptor.setValue(BluetoothGattDescriptor.ENABLE_INDICATION_VALUE);
        return bl &= this.mBluetoothGatt.writeDescriptor(bluetoothGattDescriptor);
    }

    @Override
    public List<BluetoothGattService> getSupportedGattServices() {
        if (this.mBluetoothGatt == null) {
            return null;
        }
        BluetoothGattService bluetoothGattService = this.mBluetoothGatt.getService(UUID.fromString("B6E60001-E2E3-BC82-4C72-929D0D29CA17"));
        ArrayList<BluetoothGattService> arrayList = new ArrayList<BluetoothGattService>();
        arrayList.add(bluetoothGattService);
        return arrayList;
    }

    public class a
    extends Binder {
        public c a() {
            return b.this;
        }
    }
}

