/*
 * Decompiled with CFR 0.152.
 */
package com.saltosystems.justinmobile.sdk.ble;

import android.app.Activity;
import android.app.Application;
import android.bluetooth.BluetoothDevice;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.support.annotation.NonNull;
import com.saltosystems.justinmobile.obscured.R;
import com.saltosystems.justinmobile.obscured.aW;
import com.saltosystems.justinmobile.obscured.aX;
import com.saltosystems.justinmobile.obscured.ba;
import com.saltosystems.justinmobile.sdk.ble.BluetoothLeService;
import com.saltosystems.justinmobile.sdk.ble.IMasterDeviceManagerApi;
import com.saltosystems.justinmobile.sdk.ble.IMasterDeviceManagerKeyRetriever;
import com.saltosystems.justinmobile.sdk.ble.IMasterDeviceManagerResultAndDiscoverCallback;
import com.saltosystems.justinmobile.sdk.ble.IMasterDeviceManagerResultCallback;
import com.saltosystems.justinmobile.sdk.ble.b;
import com.saltosystems.justinmobile.sdk.ble.c;
import com.saltosystems.justinmobile.sdk.ble.e;
import com.saltosystems.justinmobile.sdk.ble.f;
import com.saltosystems.justinmobile.sdk.ble.j;
import com.saltosystems.justinmobile.sdk.ble.o;
import com.saltosystems.justinmobile.sdk.exceptions.SaltoException;
import com.saltosystems.justinmobile.sdk.model.SaltoAccessKey;
import java.util.concurrent.atomic.AtomicBoolean;

abstract class l
implements IMasterDeviceManagerApi {
    private static final int MAX_NUMBER_CONNECTION_RETRIES_TO_LOCK = 3;
    private static final int PROCESS_RETRY_COUNT = 3;
    private static final String TAG = R.a(l.class);
    private static AtomicBoolean mRunning = new AtomicBoolean();
    private static int retryCount;
    private final int GLOBAL_PROCESS_TIMEOUT = 10000;
    private o mSaltoDeviceScanner;
    private e masterDeviceManager;
    private byte[] audits;
    private Handler handlerMainProcess;
    private Context mContext;
    private c mIBluetoothLeService;
    private final ServiceConnection mServiceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName componentName, IBinder service) {
            l.this.mIBluetoothLeService = ((b.a)service).a();
            if (!l.this.mIBluetoothLeService.initialize()) {
                R.e(TAG, "Unable to initialize Bluetooth");
            }
        }

        public void onServiceDisconnected(ComponentName componentName) {
            l.this.mIBluetoothLeService = null;
        }
    };
    private IMasterDeviceManagerResultCallback startProcessCallback;
    private IMasterDeviceManagerKeyRetriever keyRetriever;

    public l(Context context) throws SaltoException {
        Application application;
        this.mContext = context;
        if (this.mIBluetoothLeService != null && (application = ((BluetoothLeService)this.mIBluetoothLeService).getApplication()) != null) {
            ba.a(application, new aX(){

                @Override
                public void a(Activity activity) {
                    if (l.this.mSaltoDeviceScanner != null) {
                        l.this.mSaltoDeviceScanner.a();
                    }
                }

                @Override
                public void b(Activity activity) {
                    if (l.this.mSaltoDeviceScanner != null) {
                        l.this.mSaltoDeviceScanner.b();
                    }
                }

                @Override
                public void c(Activity activity) {
                    l.this.mContext.unbindService(l.this.mServiceConnection);
                    l.this.mIBluetoothLeService = null;
                }
            });
        }
        int n2 = this.mContext.checkCallingOrSelfPermission("android.permission.BLUETOOTH");
        int n3 = this.mContext.checkCallingOrSelfPermission("android.permission.BLUETOOTH_ADMIN");
        if (n2 != 0 || n3 != 0) {
            throw new SaltoException(404);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLockOpening(@NonNull IMasterDeviceManagerKeyRetriever keyCallback, @NonNull IMasterDeviceManagerResultCallback callback) {
        Intent intent = new Intent(this.mContext, BluetoothLeService.class);
        this.mContext.bindService(intent, this.mServiceConnection, 1);
        R.a(TAG, "<START>");
        this.startProcessCallback = callback;
        this.keyRetriever = keyCallback;
        this.handlerMainProcess = new Handler(this.mContext.getMainLooper());
        if (mRunning.getAndSet(true)) {
            this.callOnFailure(new SaltoException(401));
            return;
        }
        l l2 = this;
        synchronized (l2) {
            if (!this.hasPermissionsToContinue()) {
                return;
            }
            this.handlerMainProcess.postDelayed(new Runnable(){

                @Override
                public void run() {
                    R.a(TAG, "Fired timeout of 10000");
                    l.this.callOnFailure(new SaltoException(410));
                }
            }, 10000L);
            retryCount = 3;
            try {
                this.executeScanning();
            }
            catch (SaltoException saltoException) {
                this.callOnFailure(saltoException);
            }
            catch (Exception exception) {
                this.callOnFailure(new SaltoException(400));
            }
        }
    }

    @Override
    public void startLockOpening(@NonNull IMasterDeviceManagerKeyRetriever keyCallback, @NonNull IMasterDeviceManagerResultAndDiscoverCallback callback) {
        this.startLockOpening(keyCallback, (IMasterDeviceManagerResultCallback)callback);
    }

    @Override
    public void startLockOpening(final @NonNull SaltoAccessKey saltoAccessKey, @NonNull IMasterDeviceManagerResultCallback callback) {
        this.startLockOpening(new IMasterDeviceManagerKeyRetriever(){

            @Override
            public SaltoAccessKey retrieve() {
                return saltoAccessKey;
            }
        }, callback);
    }

    @Override
    public void startLockOpening(@NonNull SaltoAccessKey saltoAccessKey, @NonNull IMasterDeviceManagerResultAndDiscoverCallback callback) {
        this.startLockOpening(saltoAccessKey, (IMasterDeviceManagerResultCallback)callback);
    }

    private void executeScanning() throws SaltoException {
        R.a(TAG, "<EXECUTE_SCANNING>");
        this.mSaltoDeviceScanner = new o(this.mContext);
        this.mSaltoDeviceScanner.a(10000, new o.a(){

            @Override
            public void a(BluetoothDevice bluetoothDevice) {
                if (bluetoothDevice != null) {
                    R.a(TAG, String.format("Success called with peripheral: %s - Address: %s", bluetoothDevice.getName(), bluetoothDevice.getAddress()));
                    l.this.callOnPeripheralFound();
                    SaltoAccessKey saltoAccessKey = l.this.keyRetriever.retrieve();
                    if (saltoAccessKey == null || !saltoAccessKey.isValid()) {
                        R.e(TAG, "Provided key is not valid");
                        l.this.callOnFailure(new SaltoException(402));
                        return;
                    }
                    l.this.executeConnectPeripheral(l.this.mContext, bluetoothDevice, saltoAccessKey);
                } else {
                    R.a(TAG, "Timeout reached with no locks found");
                    l.this.callOnFailure(new SaltoException(410));
                }
            }
        });
    }

    private void executeConnectPeripheral(final Context context, final BluetoothDevice saltoLock, final SaltoAccessKey saltoAccessKey) {
        if (!mRunning.get()) {
            R.a(TAG, "Executed executeConnectPeripheral when Running = false");
            return;
        }
        R.a(TAG, "<CONNECTING> - " + saltoLock.getAddress());
        if (this.masterDeviceManager == null) {
            this.masterDeviceManager = new j(context, this.mIBluetoothLeService);
        }
        this.masterDeviceManager.a(saltoLock, saltoAccessKey, 3, new f(){

            @Override
            public void a(int n2, byte[] byArray) {
                R.a(TAG, "Success startLockOpening with numberOfRetries: " + (3 - retryCount));
                l.this.callOnSuccess(n2, byArray);
            }

            @Override
            public void a(SaltoException saltoException, boolean bl) {
                R.a(TAG, "Error startLockOpening onFailure numberOfRetries: " + (3 - retryCount));
                if (!bl) {
                    l.this.callOnFailure(saltoException);
                    return;
                }
                retryCount--;
                l.this.mSaltoDeviceScanner = null;
                if (retryCount > 0) {
                    R.d(TAG, "Retrying connection with previous lock...");
                    l.this.executeConnectPeripheral(context, saltoLock, saltoAccessKey);
                } else {
                    l.this.callOnFailure(saltoException);
                }
            }
        });
    }

    private void callOnPeripheralFound() {
        if (!mRunning.get()) {
            return;
        }
        this.handlerMainProcess.post(new Runnable(){

            @Override
            public void run() {
                if (l.this.startProcessCallback != null && l.this.startProcessCallback instanceof IMasterDeviceManagerResultAndDiscoverCallback) {
                    ((IMasterDeviceManagerResultAndDiscoverCallback)l.this.startProcessCallback).onPeripheralFound();
                }
            }
        });
    }

    private void callOnSuccess(final int authResult, byte[] audits) {
        if (!mRunning.get()) {
            return;
        }
        this.audits = audits;
        this.finishExecutionTasks();
        this.handlerMainProcess.post(new Runnable(){

            @Override
            public void run() {
                if (l.this.startProcessCallback != null) {
                    l.this.startProcessCallback.onSuccess(authResult);
                    l.this.startProcessCallback = null;
                }
            }
        });
    }

    private void callOnFailure(final SaltoException e2) {
        if (!mRunning.get()) {
            return;
        }
        this.audits = null;
        R.e(TAG, e2.getLocalizedMessage());
        this.finishExecutionTasks();
        if (this.masterDeviceManager != null) {
            this.masterDeviceManager.a();
        }
        this.handlerMainProcess.post(new Runnable(){

            @Override
            public void run() {
                if (l.this.startProcessCallback != null) {
                    l.this.startProcessCallback.onFailure(e2);
                    l.this.startProcessCallback = null;
                }
            }
        });
    }

    private void finishExecutionTasks() {
        R.a(TAG, "finishExecutionTasks");
        try {
            if (this.mServiceConnection != null) {
                this.mContext.unbindService(this.mServiceConnection);
            }
        }
        finally {
            this.mIBluetoothLeService = null;
        }
        mRunning.set(false);
        this.cancelTimer();
        if (this.mSaltoDeviceScanner != null) {
            this.mSaltoDeviceScanner.b();
        }
        if (this.mIBluetoothLeService != null) {
            this.mIBluetoothLeService.disconnect();
        }
    }

    private void cancelTimer() {
        if (this.handlerMainProcess != null) {
            this.handlerMainProcess.removeCallbacksAndMessages(null);
        }
    }

    private boolean hasPermissionsToContinue() {
        int n2;
        if (aW.a(this.mContext) && (n2 = this.mContext.checkCallingOrSelfPermission("android.permission.ACCESS_COARSE_LOCATION")) != 0) {
            this.callOnFailure(new SaltoException(501));
            return false;
        }
        return true;
    }
}

