/*
 * Decompiled with CFR 0.152.
 */
package com.saltosystems.justinmobile.sdk.exceptions;

import android.util.SparseArray;

public final class SaltoErrorMessages {
    private static final String CONNECTION_GENERAL_ERROR_MESSAGE = "A general error has occurred";
    private static final String PROCESS_ALREADY_RUNNING_ERROR_MESSAGE = "Process already running";
    private static final String INCORRECT_ACCESS_KEY_DATA_ERROR_MESSAGE = "The provided binary information to the Salto Key is not valid";
    private static final String BLUETOOTH_NOT_SUPPORTED_ERROR_MESSAGE = "Bluetooth is not supported by the device";
    private static final String BLUETOOTH_FEATURE_NOT_ENABLED_ERROR_MESSAGE = "Bluetooth feature is not enabled";
    private static final String BLUETOOTH_NOT_INITIALIZED_ERROR_MESSAGE = "Bluetooth is not activated or is not ready yet";
    private static final String DISCONNECTED_GATT_SERVER_ERROR_MESSAGE = "GATT (Generic Attribute Profile) server disconnected";
    private static final String OPERATION_CANCELLED_ERROR_MESSAGE = "Cancelled";
    private static final String NO_SERVICES_FOUND_ERROR_MESSAGE = "No SALTO Services found in peripheral";
    private static final String TIMEOUT_REACHED_ERROR_MESSAGE = "Timeout reached";
    private static final String INVALID_SERVICE_CHARACTERISTICS_ERROR_MESSAGE = "Invalid characteristics found in the service";
    private static final String INVALID_BLE_PROTOCOL_VERSION_ERROR_MESSAGE = "The lock has returned a protocol version that the current SDK version is not compatible with";
    private static final String INVALID_DATA_RECEIVED_ERROR_MESSAGE = "The provided binary information to the Salto Key is not valid";
    private static final String AUTHENTICATION_FAILED_ERROR_MESSAGE = "An authentication error has occurred between the mobile phone and the lock";
    private static final String BLUETOOTH_SERVICE_NOT_FOUND_ERROR_MESSAGE = "Bluetooth service cannot be loaded or found. Check it is properly declared in the AndroidManifest.xml file";
    private static final String COARSE_LOCATION_PERMISSION_DENIED_ERROR_MESSAGE = "Coarse permission not granted when it is required since Android 6.0 (target SDK 23)";
    private static final String COARSE_LOCATION_NOT_ENABLED_ERROR_MESSAGE = "Coarse location not enabled when it is necessary since Android 6.0 (target SDK 23)";
    private static final SparseArray<String> dictionarySaltoErrorResult = new SparseArray();

    public static String MapSaltoException(int errorCode) {
        return dictionarySaltoErrorResult.indexOfKey(errorCode) < 0 ? (String)dictionarySaltoErrorResult.get(400) : (String)dictionarySaltoErrorResult.get(errorCode);
    }

    static {
        dictionarySaltoErrorResult.put(400, (Object)CONNECTION_GENERAL_ERROR_MESSAGE);
        dictionarySaltoErrorResult.put(401, (Object)PROCESS_ALREADY_RUNNING_ERROR_MESSAGE);
        dictionarySaltoErrorResult.put(402, (Object)"The provided binary information to the Salto Key is not valid");
        dictionarySaltoErrorResult.put(403, (Object)BLUETOOTH_NOT_SUPPORTED_ERROR_MESSAGE);
        dictionarySaltoErrorResult.put(404, (Object)BLUETOOTH_FEATURE_NOT_ENABLED_ERROR_MESSAGE);
        dictionarySaltoErrorResult.put(405, (Object)BLUETOOTH_NOT_INITIALIZED_ERROR_MESSAGE);
        dictionarySaltoErrorResult.put(406, (Object)DISCONNECTED_GATT_SERVER_ERROR_MESSAGE);
        dictionarySaltoErrorResult.put(407, (Object)OPERATION_CANCELLED_ERROR_MESSAGE);
        dictionarySaltoErrorResult.put(409, (Object)NO_SERVICES_FOUND_ERROR_MESSAGE);
        dictionarySaltoErrorResult.put(410, (Object)TIMEOUT_REACHED_ERROR_MESSAGE);
        dictionarySaltoErrorResult.put(411, (Object)INVALID_SERVICE_CHARACTERISTICS_ERROR_MESSAGE);
        dictionarySaltoErrorResult.put(412, (Object)INVALID_BLE_PROTOCOL_VERSION_ERROR_MESSAGE);
        dictionarySaltoErrorResult.put(413, (Object)"The provided binary information to the Salto Key is not valid");
        dictionarySaltoErrorResult.put(414, (Object)AUTHENTICATION_FAILED_ERROR_MESSAGE);
        dictionarySaltoErrorResult.put(500, (Object)BLUETOOTH_SERVICE_NOT_FOUND_ERROR_MESSAGE);
        dictionarySaltoErrorResult.put(501, (Object)COARSE_LOCATION_PERMISSION_DENIED_ERROR_MESSAGE);
        dictionarySaltoErrorResult.put(502, (Object)COARSE_LOCATION_NOT_ENABLED_ERROR_MESSAGE);
    }
}

