/*
 * Decompiled with CFR 0.152.
 */
package com.saltosystems.justinmobile.sdk.model;

import com.saltosystems.justinmobile.obscured.E;
import com.saltosystems.justinmobile.obscured.N;
import com.saltosystems.justinmobile.sdk.model.helpers.SaltoAccessKeyTransformer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;

public final class SaltoAccessKey {
    private static final byte AUTHENTICATION_LENGTH = 32;
    final String CODE_CHARACTERISTIC_VERSION = "01";
    final String CODE_CHARACTERISTIC_IDD_AT = "02";
    final String CODE_CHARACTERISTIC_RECEIVED_RANDOM = "03";
    final String CODE_CHARACTERISTIC_ENCRYPTED_RANDOM = "04";
    final String CODE_CHARACTERISTIC_INDICATION_RESULT_STATE = "05";
    private String authentication;
    private String image;
    private String supportedBLEVersion;

    public SaltoAccessKey(String hexData) {
        Triple<String, String, String> triple = SaltoAccessKeyTransformer.a(N.a(hexData));
        this.supportedBLEVersion = (String)triple.getLeft();
        this.image = (String)triple.getMiddle();
        this.authentication = (String)triple.getRight();
    }

    public boolean isValid() {
        return StringUtils.isNotBlank((CharSequence)this.authentication) && N.a(this.authentication) && this.authentication.length() == 32 && StringUtils.isNotBlank((CharSequence)this.image) && N.a(this.image) && StringUtils.isNotBlank((CharSequence)this.supportedBLEVersion) && N.a(this.supportedBLEVersion);
    }

    public byte[] getAuthentication() {
        return N.a(this.authentication);
    }

    public byte[] getImage() {
        byte[] byArray = N.a(this.image);
        return E.a(N.a("02"), byArray);
    }

    public String getSupportedBLEVersion() {
        return this.supportedBLEVersion;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        SaltoAccessKey saltoAccessKey = (SaltoAccessKey)o2;
        if (this.authentication != null ? !this.authentication.equals(saltoAccessKey.authentication) : saltoAccessKey.authentication != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(saltoAccessKey.image) : saltoAccessKey.image != null) {
            return false;
        }
        return !(this.supportedBLEVersion != null ? !this.supportedBLEVersion.equals(saltoAccessKey.supportedBLEVersion) : saltoAccessKey.supportedBLEVersion != null);
    }

    public int hashCode() {
        int n2 = this.authentication != null ? this.authentication.hashCode() : 0;
        n2 = 31 * n2 + (this.image != null ? this.image.hashCode() : 0);
        n2 = 31 * n2 + (this.supportedBLEVersion != null ? this.supportedBLEVersion.hashCode() : 0);
        return n2;
    }
}

