/*
 * Decompiled with CFR 0.152.
 */
package com.irisvalet.android.apps.mobile_key;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.google.gson.JsonObject;
import com.irisvalet.android.apps.DebugLog;
import com.irisvalet.android.apps.mobile_key.MobileKeyFactory;
import com.irisvalet.android.apps.mobile_key.MobileKeyLibInterface;
import com.irisvalet.android.apps.mobile_key.MobileWalletKey;
import com.irisvalet.android.apps.salto_api.API.ApiClient;
import com.irisvalet.android.apps.salto_api.API.ApiInterface;
import com.irisvalet.android.apps.salto_api.API.Request.DeviceRegistrationDetails;
import com.irisvalet.android.apps.salto_api.API.Response.RegistrationResponse;
import com.irisvalet.android.apps.utils.Prefs;
import com.saltosystems.justinmobile.sdk.ble.IMasterDeviceManagerApi;
import com.saltosystems.justinmobile.sdk.ble.IMasterDeviceManagerResultAndDiscoverCallback;
import com.saltosystems.justinmobile.sdk.ble.MasterDeviceManagerApi;
import com.saltosystems.justinmobile.sdk.exceptions.SaltoException;
import com.saltosystems.justinmobile.sdk.model.SaltoAccessKey;
import java.util.ArrayList;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import retrofit2.Retrofit;

public class MobileKeyManager
implements MobileKeyFactory {
    private static final String TAG = "SaltoManager";
    private static MobileKeyLibInterface mContext;
    private static String mBaseURL;
    private IMasterDeviceManagerApi masterDeviceManager;
    private static String mSaltoAccessKey;
    private static SaltoAccessKey mVirtualKey;

    public MobileKeyManager(MobileKeyLibInterface context) {
        mContext = context;
        Prefs.initPrefs(mContext.getApplicationContext());
    }

    @Override
    public void setContext(MobileKeyLibInterface context) {
        mContext = context;
    }

    @Override
    public boolean isReady() {
        DebugLog.d(TAG, "isReady");
        if (mSaltoAccessKey == null) {
            mSaltoAccessKey = Prefs.getString("SaltoAccessKey", null);
        }
        return mSaltoAccessKey != null;
    }

    @Override
    public void initialize(JsonObject settings) {
        DebugLog.d(TAG, "initialize");
        if (mBaseURL == null) {
            mBaseURL = Prefs.getString("BASE_URL", null);
        }
        if (!this.parseSettings(settings)) {
            mContext.onDeviceInitializationFailed("Missing Configuration settings");
            return;
        }
        mContext.onDeviceInitializationStarted();
        if (TextUtils.isEmpty((CharSequence)mBaseURL)) {
            mContext.onDeviceInitializationFailed("Missing baseURL");
        } else {
            mContext.onDeviceInitializationCompleted(null);
        }
    }

    private boolean parseSettings(JsonObject settings) {
        if (settings != null) {
            try {
                JsonObject Salto;
                JsonObject mobileKey;
                JsonObject integrations;
                JsonObject config = (JsonObject)settings.get("config");
                if (config != null && (integrations = (JsonObject)config.get("integrations")) != null && (mobileKey = (JsonObject)integrations.get("mobileKey")) != null && (Salto = (JsonObject)mobileKey.get("Salto")) != null) {
                    mBaseURL = Salto.get("endPointSetupURL").getAsString();
                    Prefs.putString("BASE_URL", mBaseURL);
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public void register(String deviceId, String pin, String lastName, String roomNumber) {
        DebugLog.d(TAG, "register");
        if (mContext != null) {
            ApiInterface apiService;
            String errorDescription = null;
            if (TextUtils.isEmpty((CharSequence)pin)) {
                errorDescription = "Missing pin";
            } else if (TextUtils.isEmpty((CharSequence)lastName)) {
                errorDescription = "Missing lastName";
            } else if (TextUtils.isEmpty((CharSequence)roomNumber)) {
                errorDescription = "Missing roomNumber";
            }
            Retrofit client = ApiClient.getClient(mBaseURL);
            if (client == null) {
                errorDescription = "Error creating API client";
            }
            if ((apiService = (ApiInterface)client.create(ApiInterface.class)) == null) {
                errorDescription = "Error creating API Service";
            }
            if (errorDescription != null) {
                mContext.onRegistrationFailed(errorDescription);
                return;
            }
            DeviceRegistrationDetails data = new DeviceRegistrationDetails();
            data.ReservationNumber = pin;
            data.PIN = pin;
            data.LastName = lastName;
            data.RoomNumber = roomNumber;
            Call<RegistrationResponse> call = apiService.requestBinaryKey(data);
            call.enqueue((Callback)new Callback<RegistrationResponse>(){

                public void onResponse(@NonNull Call<RegistrationResponse> call, @NonNull Response<RegistrationResponse> response) {
                    String errorDescription = "Unknown error";
                    if (response != null) {
                        RegistrationResponse responseBody = (RegistrationResponse)response.body();
                        if (responseBody != null) {
                            DebugLog.d(MobileKeyManager.TAG, "registerDevice : " + responseBody.toString());
                        }
                        if (responseBody == null) {
                            errorDescription = response.message();
                        } else if (responseBody.Status != null && responseBody.Status.equalsIgnoreCase("Success") && responseBody.BinaryKey != null && !responseBody.BinaryKey.isEmpty()) {
                            mSaltoAccessKey = responseBody.BinaryKey;
                            Prefs.putString("SaltoAccessKey", mSaltoAccessKey);
                            mContext.onRegistrationCompleted(mSaltoAccessKey);
                            return;
                        }
                    }
                    mContext.onRegistrationFailed(errorDescription);
                }

                public void onFailure(@NonNull Call<RegistrationResponse> call, Throwable t) {
                    String error = "onFailure Unknown error";
                    try {
                        error = t.getMessage();
                        DebugLog.e(MobileKeyManager.TAG, "registerDevice onFailure: " + error);
                        error = t.getMessage();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    mContext.onRegistrationFailed(error);
                }
            });
        }
    }

    @Override
    public void unRegister() {
        DebugLog.d(TAG, "unRegister");
        if (mContext != null) {
            this.masterDeviceManager = null;
            mSaltoAccessKey = null;
            mVirtualKey = null;
            Prefs.remove("SaltoAccessKey");
            mContext.onUnRegistrationCompleted(null);
        }
    }

    @Override
    public void requestKeys(Object data) {
        DebugLog.d(TAG, "requestKeys");
        if (mSaltoAccessKey == null) {
            mSaltoAccessKey = Prefs.getString("SaltoAccessKey", null);
        }
        if (data == null) {
            data = mSaltoAccessKey;
        }
        if (data != null) {
            try {
                mSaltoAccessKey = (String)data;
                if (!TextUtils.isEmpty((CharSequence)mSaltoAccessKey)) {
                    mVirtualKey = new SaltoAccessKey(mSaltoAccessKey);
                    ArrayList<MobileWalletKey> keys = this.createKeys();
                    if (keys != null) {
                        mContext.onKeyRequestCompleted(keys);
                    } else {
                        mContext.onKeyRequestFailed("No keys available");
                    }
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (mContext != null) {
            mContext.onKeyRequestFailed("Error requesting keys");
        }
    }

    private ArrayList<MobileWalletKey> createKeys() {
        DebugLog.d(TAG, "createKeys");
        ArrayList<MobileWalletKey> keys = null;
        if (mVirtualKey != null) {
            keys = new ArrayList<MobileWalletKey>();
            MobileWalletKey key = new MobileWalletKey();
            key.name = "Salto Key";
            keys.add(key);
        }
        return keys;
    }

    @Override
    public void refreshKeys() {
        DebugLog.d(TAG, "refreshKeys");
        if (mContext != null) {
            mVirtualKey = new SaltoAccessKey(mSaltoAccessKey);
            ArrayList<MobileWalletKey> keys = this.createKeys();
            if (keys != null) {
                mContext.onKeysRefreshCompleted(keys);
            } else {
                mContext.onKeysRefreshFailed("No keys available");
            }
        }
    }

    @Override
    public void accessLock() {
        DebugLog.d(TAG, "accessLock");
        if (mContext != null) {
            block7: {
                try {
                    if (mVirtualKey == null) {
                        this.refreshKeys();
                    }
                    if (mVirtualKey == null) break block7;
                    if (this.masterDeviceManager == null) {
                        try {
                            this.masterDeviceManager = new MasterDeviceManagerApi(mContext.getApplicationContext());
                        }
                        catch (SaltoException e) {
                            e.printStackTrace();
                        }
                    }
                    mContext.onLockAccessStarted();
                    this.masterDeviceManager.startLockOpening(mVirtualKey, new IMasterDeviceManagerResultAndDiscoverCallback(){

                        public void onPeripheralFound() {
                            mContext.onBluetoothEnabled();
                        }

                        public void onSuccess(int authResult) {
                            if (authResult == 2) {
                                DebugLog.d(MobileKeyManager.TAG, "startLockOpening: Access granted");
                                mContext.onLockAccessGranted();
                                return;
                            }
                            DebugLog.d(MobileKeyManager.TAG, "startLockOpening: Access rejected");
                            mContext.onLockAccessFailed("Access rejected");
                        }

                        public void onFailure(SaltoException e) {
                            DebugLog.e(MobileKeyManager.TAG, "startLockOpening: " + e.getMessage());
                            switch (e.getErrorCode()) {
                                case 403: {
                                    mContext.onBluetoothNotSupported();
                                    break;
                                }
                                case 404: 
                                case 405: {
                                    mContext.onBluetoothFailed();
                                    break;
                                }
                                default: {
                                    mContext.onLockAccessFailed(e.getMessage());
                                }
                            }
                        }
                    });
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            mContext.onLockAccessFailed("Failed to access the lock");
        }
    }

    @Override
    public void cancelLockAccess() {
        mContext.onLockAccessFailed("Access Cancelled");
    }

    @Override
    public void revokeKeys() {
        this.masterDeviceManager = null;
        mSaltoAccessKey = null;
        mVirtualKey = null;
        Prefs.remove("SaltoAccessKey");
    }

    @Override
    public void onDestroy() {
    }

    static {
        mBaseURL = null;
        mSaltoAccessKey = null;
        mVirtualKey = null;
    }
}

