package net.isger.brick.bus;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import net.isger.brick.Constants;
import net.isger.brick.bus.protocol.Protocol;
import net.isger.brick.core.Console;
import net.isger.brick.inject.Container;
import net.isger.brick.util.CommandOperator;
import net.isger.util.Helpers;
import net.isger.util.Strings;
import net.isger.util.anno.Alias;
import net.isger.util.anno.Ignore;
import net.isger.util.anno.Ignore.Mode;

/**
 * 抽象端点
 * 
 * @author issing
 *
 */
@Ignore
public abstract class AbstractEndpoint implements Endpoint {

    /** 容器 */
    @Ignore(mode = Mode.INCLUDE)
    @Alias(Constants.SYSTEM)
    protected Container container;

    /** 控制台 */
    @Ignore(mode = Mode.INCLUDE)
    @Alias(Constants.SYSTEM)
    protected Console console;

    /** 总线 */
    @Ignore(mode = Mode.INCLUDE)
    @Alias(Constants.SYSTEM)
    private Bus bus;

    /** 操作器 */
    @Ignore(mode = Mode.INCLUDE)
    private CommandOperator operator;

    @Ignore(mode = Mode.INCLUDE)
    private String name;

    @Ignore(mode = Mode.INCLUDE)
    private String protocol;

    private transient Protocol endpointProtocol;

    @Ignore(mode = Mode.INCLUDE)
    private IdentityHandler handler;

    @Ignore(mode = Mode.INCLUDE)
    private Map<String, Object> parameters;

    private transient volatile Status status;

    public AbstractEndpoint() {
        operator = new CommandOperator(this);
        parameters = new HashMap<String, Object>();
        status = Status.INACTIVATE; // 非激活状态
    }

    public final void initial() {
        status = Status.ACTIVATING; // 激活中状态
        if (Strings.isEmpty(protocol)) {
            protocol = name();
        }
        endpointProtocol = findProtocol(protocol, getClass(), null);
        if (handler != null) {
            container.inject(handler);
        }
        /* 等待控制台就绪 */
        while (!console.hasReady()) {
            Helpers.sleep(200l);
        }
        open();
        status = Status.ACTIVATED; // 已激活状态状态
    }

    @SuppressWarnings("unchecked")
    private Protocol findProtocol(String name, Class<?> rawClass, String namespace) {
        Protocol protocol;
        if (Strings.isEmpty(namespace)) {
            protocol = bus.getProtocol(name);
        } else {
            protocol = bus.getProtocol(name + "." + namespace);
        }
        if (protocol == null && rawClass != AbstractEndpoint.class) {
            protocol = findProtocol(name, rawClass.getSuperclass(), Endpoints.getName((Class<Endpoint>) rawClass));
        }
        return protocol;
    }

    public String name() {
        if (Strings.isEmpty(name)) {
            name = Endpoints.getName(getClass());
        }
        return name;
    }

    public Status getStatus() {
        return status;
    }

    public boolean isActive() {
        return status == Status.ACTIVATED;
    }

    public String getProtocolName() {
        return protocol;
    }

    public Protocol getProtocol() {
        return endpointProtocol;
    }

    public IdentityHandler getHandler() {
        return handler;
    }

    public final Object getParameter(String name) {
        return parameters.get(name);
    }

    public final Map<String, Object> getParameters() {
        return Collections.unmodifiableMap(parameters);
    }

    public void operate(BusCommand cmd) {
        operator.operate(cmd);
    }

    /**
     * 打开
     */
    protected abstract void open();

    /**
     * 关闭
     */
    protected abstract void close();

    public final void destroy() {
        if (status != Status.DEACTIVATED) {
            close();
        }
        status = Status.DEACTIVATED; // 已制动状态
    }

}
