/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.auth;

import net.isger.brick.auth.AuthCommand;
import net.isger.brick.auth.AuthIdentity;
import net.isger.brick.core.CoreHelper;

public class AuthHelper
extends CoreHelper {
    protected AuthHelper() {
    }

    public static AuthCommand makeCommand(Object token) {
        AuthCommand cmd = AuthCommand.newAction();
        if (cmd == null) {
            cmd = new AuthCommand();
        }
        cmd.setToken(token);
        return cmd;
    }

    public static AuthCommand makeCommand(String domain, Object token) {
        AuthCommand cmd = AuthHelper.makeCommand(token);
        cmd.setDomain(domain);
        return cmd;
    }

    public static AuthCommand makeCommand(AuthIdentity identity, Object token) {
        AuthCommand cmd = AuthHelper.makeCommand(token);
        cmd.setIdentity(identity);
        return cmd;
    }

    public static AuthCommand makeCommand(AuthIdentity identity, String domain, Object token) {
        AuthCommand cmd = AuthHelper.makeCommand(domain, token);
        cmd.setIdentity(identity);
        return cmd;
    }

    public static AuthCommand toLogin(Object token) {
        AuthCommand cmd = AuthHelper.makeCommand(token);
        cmd.setOperate("login");
        CoreHelper.toConsole(cmd);
        return cmd;
    }

    public static AuthCommand toLogin(AuthIdentity identity, Object token) {
        AuthCommand cmd = AuthHelper.makeCommand(identity, token);
        cmd.setOperate("login");
        CoreHelper.toConsole(cmd);
        return cmd;
    }

    public static AuthCommand toLogin(String domain, Object token) {
        AuthCommand cmd = AuthHelper.makeCommand(domain, token);
        cmd.setOperate("login");
        CoreHelper.toConsole(cmd);
        return cmd;
    }

    public static AuthCommand toCheck(String domain, Object token) {
        AuthCommand cmd = AuthHelper.makeCommand(domain, token);
        cmd.setOperate("check");
        CoreHelper.toConsole(cmd);
        return cmd;
    }

    public static AuthCommand toLogout(Object token) {
        AuthCommand cmd = AuthHelper.makeCommand(token);
        cmd.setOperate("logout");
        CoreHelper.toConsole(cmd);
        return cmd;
    }
}

