/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.auth;

import net.isger.brick.auth.AuthCommand;
import net.isger.brick.auth.AuthHelper;
import net.isger.brick.auth.AuthModule;
import net.isger.brick.auth.BaseToken;
import net.isger.brick.core.BaseCommand;
import net.isger.brick.core.Command;
import net.isger.brick.core.Console;
import net.isger.brick.core.Context;
import net.isger.brick.core.Preparer;
import net.isger.util.Helpers;
import net.isger.util.Strings;
import net.isger.util.anno.Alias;
import net.isger.util.anno.Ignore;

public class AuthPreparer
extends Preparer {
    @Ignore(mode=Ignore.Mode.INCLUDE)
    @Alias(value="system")
    private Console console;
    @Ignore(mode=Ignore.Mode.INCLUDE)
    @Alias(value="auth")
    private AuthModule module;

    @Override
    protected Context createContext(BaseCommand command) {
        return super.createContext(this.meddle(command));
    }

    @Override
    protected void updateContext(Context context, BaseCommand command) {
        super.updateContext(context, this.meddle(command));
    }

    protected BaseCommand meddle(BaseCommand command) {
        if (command instanceof AuthCommand) {
            AuthCommand cmd = (AuthCommand)command;
            Object token = cmd.getToken();
            boolean result = Strings.isEmpty((Object)cmd.getDomain()) && Strings.isEmpty((Object)cmd.getOperate()) && token instanceof Command || this.module.getGate(cmd.getDomain()) == null;
            if (result) {
                command = BaseCommand.cast((Command)((Object)token));
            }
            cmd.setResult(result);
        } else {
            String domain = this.console.getModuleName(command);
            if (this.module.getGate(domain) != null) {
                AuthCommand cmd = AuthHelper.makeCommand(command.getIdentity(), domain, command);
                cmd.setOperate("check");
                command = cmd;
            } else if (command.getIdentity() == null) {
                AuthCommand cmd = AuthHelper.makeCommand("system", (Object)new BaseToken(Helpers.makeUUID(), command));
                cmd.setOperate("login");
                this.console.execute(cmd);
                command.setIdentity(cmd.getIdentity());
            }
        }
        return command;
    }
}

