/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.auth;

import net.isger.brick.auth.Auth;
import net.isger.brick.auth.AuthChecker;
import net.isger.brick.auth.AuthCommand;
import net.isger.brick.auth.AuthIdentity;
import net.isger.brick.auth.AuthToken;
import net.isger.brick.auth.Authenticator;
import net.isger.brick.auth.Authorizer;
import net.isger.brick.core.BaseGate;
import net.isger.util.Helpers;

public class BaseAuth
extends BaseGate
implements Auth {
    protected AuthChecker checker;
    protected Authenticator authenticator;
    protected Authorizer authorizer;

    @Override
    public void initial() {
        super.initial();
        if (this.checker == null) {
            this.checker = new AuthChecker();
        }
        this.container.inject(this.checker);
        if (this.authenticator == null) {
            this.authenticator = new Authenticator();
        }
        this.container.inject(this.authenticator);
        if (this.authorizer == null) {
            this.authorizer = new Authorizer();
        }
        this.container.inject(this.authorizer);
    }

    @Override
    public final void login(AuthCommand cmd) {
        AuthIdentity identity = cmd.getIdentity();
        if (identity == null) {
            identity = this.createIdentity();
            cmd.setIdentity(identity);
        } else if (identity.isLogin()) {
            this.logout(identity);
        }
        Object result = null;
        AuthToken<?> token = this.login(identity, (AuthToken<?>)this.authenticator.handle(cmd));
        if (token != null) {
            result = token.getSource();
        }
        cmd.setResult(result);
    }

    protected AuthIdentity createIdentity() {
        return new AuthIdentity();
    }

    protected AuthToken<?> login(AuthIdentity identity, AuthToken<?> token) {
        if (token != null) {
            identity.setToken(token);
        }
        return token;
    }

    @Override
    public final void check(AuthCommand cmd) {
        Object token = cmd.getToken();
        AuthIdentity identity = cmd.getIdentity();
        cmd.setResult(identity != null && Helpers.toBoolean((Object)this.check(identity, token)) || this.isIgnore(token));
        this.checker.handle(cmd);
    }

    protected Object check(AuthIdentity identity, Object token) {
        return identity.getToken().equals(token);
    }

    protected boolean isIgnore(Object token) {
        return this.checker.isIgnore(token);
    }

    @Override
    public final void auth(AuthCommand cmd) {
        cmd.setResult(this.authorizer.handle(cmd));
    }

    @Override
    public final void logout(AuthCommand cmd) {
        AuthIdentity identity = cmd.getIdentity();
        if (identity != null && identity.isLogin()) {
            this.logout(identity);
        }
    }

    protected void logout(AuthIdentity identity) {
        identity.clear();
        identity.setToken(null);
    }

    @Override
    public void destroy() {
        super.destroy();
    }
}

