/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.bus;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.isger.brick.bus.Bus;
import net.isger.brick.bus.BusCommand;
import net.isger.brick.bus.Endpoint;
import net.isger.brick.bus.Endpoints;
import net.isger.brick.bus.IdentityHandler;
import net.isger.brick.bus.Status;
import net.isger.brick.bus.protocol.Protocol;
import net.isger.brick.core.Console;
import net.isger.brick.inject.Container;
import net.isger.brick.util.CommandOperator;
import net.isger.util.Helpers;
import net.isger.util.Strings;
import net.isger.util.anno.Alias;
import net.isger.util.anno.Ignore;

@Ignore
public abstract class AbstractEndpoint
implements Endpoint {
    @Ignore(mode=Ignore.Mode.INCLUDE)
    @Alias(value="system")
    protected Container container;
    @Ignore(mode=Ignore.Mode.INCLUDE)
    @Alias(value="system")
    protected Console console;
    @Ignore(mode=Ignore.Mode.INCLUDE)
    @Alias(value="system")
    private Bus bus;
    @Ignore(mode=Ignore.Mode.INCLUDE)
    private CommandOperator operator = new CommandOperator(this);
    @Ignore(mode=Ignore.Mode.INCLUDE)
    private String name;
    @Ignore(mode=Ignore.Mode.INCLUDE)
    private String protocol;
    private transient Protocol endpointProtocol;
    @Ignore(mode=Ignore.Mode.INCLUDE)
    private IdentityHandler handler;
    @Ignore(mode=Ignore.Mode.INCLUDE)
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private volatile transient Status status = Status.INACTIVATE;

    public final void initial() {
        this.status = Status.ACTIVATING;
        if (Strings.isEmpty((Object)this.protocol)) {
            this.protocol = this.name();
        }
        this.endpointProtocol = this.findProtocol(this.protocol, this.getClass(), null);
        if (this.handler != null) {
            this.container.inject(this.handler);
        }
        while (!this.console.hasReady()) {
            Helpers.sleep((long)200L);
        }
        this.open();
        this.status = Status.ACTIVATED;
    }

    private Protocol findProtocol(String name, Class<?> rawClass, String namespace) {
        Protocol protocol = Strings.isEmpty((Object)namespace) ? this.bus.getProtocol(name) : this.bus.getProtocol(name + "." + namespace);
        if (protocol == null && rawClass != AbstractEndpoint.class) {
            protocol = this.findProtocol(name, rawClass.getSuperclass(), Endpoints.getName(rawClass));
        }
        return protocol;
    }

    public String name() {
        if (Strings.isEmpty((Object)this.name)) {
            this.name = Endpoints.getName(this.getClass());
        }
        return this.name;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public boolean isActive() {
        return this.status == Status.ACTIVATED;
    }

    public String getProtocolName() {
        return this.protocol;
    }

    public Protocol getProtocol() {
        return this.endpointProtocol;
    }

    public IdentityHandler getHandler() {
        return this.handler;
    }

    public final Object getParameter(String name) {
        return this.parameters.get(name);
    }

    public final Map<String, Object> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    @Override
    public void operate(BusCommand cmd) {
        this.operator.operate(cmd);
    }

    protected abstract void open();

    protected abstract void close();

    public final void destroy() {
        if (this.status != Status.DEACTIVATED) {
            this.close();
        }
        this.status = Status.DEACTIVATED;
    }
}

