/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.bus;

import net.isger.brick.bus.Bus;
import net.isger.brick.bus.Endpoint;
import net.isger.brick.bus.Endpoints;
import net.isger.brick.bus.protocol.Protocol;
import net.isger.brick.bus.protocol.Protocols;
import net.isger.brick.core.Console;
import net.isger.brick.inject.Container;
import net.isger.brick.task.TaskCommand;
import net.isger.util.Callable;
import net.isger.util.anno.Alias;
import net.isger.util.anno.Ignore;

public class BaseBus
implements Bus {
    @Ignore(mode=Ignore.Mode.INCLUDE)
    @Alias(value="system")
    private Console console;
    @Ignore(mode=Ignore.Mode.INCLUDE)
    @Alias(value="system")
    private Container container;
    private Protocols protocols = new Protocols();
    private Endpoints endpoints = new Endpoints();

    public void initial() {
        for (Protocol protocol : this.protocols.gets().values()) {
            this.container.inject(protocol);
            protocol.initial();
        }
        TaskCommand cmd = new TaskCommand();
        cmd.setDaemon(true);
        cmd.setOperate("submit");
        for (final Endpoint endpoint : this.endpoints.gets().values()) {
            this.container.inject(endpoint);
            cmd.setCallback(new Callable<Exception>(){

                public Exception call(Object ... args) {
                    Exception cause = null;
                    try {
                        endpoint.initial();
                    }
                    catch (Exception e) {
                        cause = e;
                    }
                    return cause;
                }
            });
            this.console.execute(cmd);
        }
    }

    @Override
    public Protocol getProtocol(String name) {
        return this.protocols.get(name);
    }

    @Override
    public Endpoint getEndpoint(String name) {
        return this.endpoints.get(name);
    }

    public void destroy() {
        for (Endpoint endpoint : this.endpoints.gets().values()) {
            try {
                endpoint.destroy();
            }
            catch (Exception exception) {}
        }
        for (Protocol protocol : this.protocols.gets().values()) {
            try {
                protocol.destroy();
            }
            catch (Exception exception) {}
        }
    }
}

