/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.bus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.isger.brick.bus.EndpointsConversion;
import net.isger.brick.bus.protocol.Protocol;
import net.isger.brick.bus.protocol.ProtocolsConversion;
import net.isger.brick.util.AbstractDesigner;

public class BusDesigner
extends AbstractDesigner {
    private static final String PARAM_PROTOCOLS = "protocols";

    @Override
    public void design(Map<String, Object> config) {
        if (config != null) {
            ArrayList<Object> protocols = config.get(PARAM_PROTOCOLS);
            if (protocols == null) {
                protocols = Protocol.class.getPackage().getName();
            } else {
                ArrayList<Object> values = new ArrayList<Object>();
                values.add(Protocol.class.getPackage().getName());
                if (protocols instanceof Collection) {
                    values.addAll((Collection)protocols);
                } else {
                    values.add(protocols);
                }
                protocols = values;
            }
            config.put(PARAM_PROTOCOLS, protocols);
        }
        super.design(config);
    }

    @Override
    protected void prepare() {
        this.addConversion(EndpointsConversion.getInstance());
        this.addConversion(ProtocolsConversion.getInstance());
    }
}

