/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.bus;

import java.util.Map;
import net.isger.brick.bus.BaseBus;
import net.isger.brick.bus.Bus;
import net.isger.brick.bus.BusCommand;
import net.isger.brick.bus.Endpoint;
import net.isger.brick.core.AbstractModule;
import net.isger.brick.core.BaseCommand;
import net.isger.brick.inject.ConstantStrategy;
import net.isger.util.Asserts;
import net.isger.util.reflect.ClassAssembler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusModule
extends AbstractModule {
    private static final String BUS = "bus";
    private static final Logger LOG = LoggerFactory.getLogger(BusModule.class);

    @Override
    public Class<?> getTargetClass() {
        return Bus.class;
    }

    public Class<?> getImplementsClass() {
        return this.getImplementClass(BUS);
    }

    @Override
    public Class<?> getBaseClass() {
        return BaseBus.class;
    }

    @Override
    protected Object create(Class<?> clazz, Map<String, Object> res, ClassAssembler assembler) {
        Bus bus = (Bus)super.create(clazz, res, assembler);
        this.setBus(bus);
        return bus;
    }

    protected final Bus getBus() {
        return (Bus)this.container.getInstance(this.getTargetClass(), "system");
    }

    protected final void setBus(Bus bus) {
        Asserts.isNotNull((Object)bus, (String)"The bus cannot be null", (Object[])new Object[0]);
        if (LOG.isDebugEnabled()) {
            LOG.info("Achieve bus [{}]", (Object)bus);
        }
        Class<?> type = this.getTargetClass();
        this.setBus(type, "system", bus);
        if (type != bus.getClass()) {
            this.setBus(bus.getClass(), "system", bus);
        }
    }

    private void setBus(Class<?> type, String name, Object bus) {
        bus = ConstantStrategy.set(this.container, type, name, bus);
        if (LOG.isDebugEnabled() && bus != null) {
            LOG.info("(!) Discard bus [{}]", bus);
        }
    }

    @Override
    protected Bus create() {
        return (Bus)super.create();
    }

    public final Endpoint getEndpoint() {
        return (Endpoint)this.getInternal("brick.core.endpoint");
    }

    @Override
    public void initial() {
        super.initial();
        Bus bus = this.getBus();
        if (bus == null) {
            this.setBus(this.create());
            bus = this.getBus();
        }
        bus.initial();
    }

    @Override
    public final void execute(BaseCommand cmd) {
        BusCommand bcmd = (BusCommand)cmd;
        String name = bcmd.getEndpoint();
        if (name == null) {
            super.execute(bcmd);
        } else {
            Endpoint endpoint = this.getBus().getEndpoint(name);
            this.setInternal("brick.core.endpoint", endpoint);
            endpoint.operate(bcmd);
        }
    }

    @Override
    public void destroy() {
        Bus bus = this.getBus();
        if (bus != null) {
            bus.destroy();
        }
        super.destroy();
    }
}

