/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.bus;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.isger.brick.bus.Endpoint;
import net.isger.util.Helpers;
import net.isger.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Endpoints {
    private static final Logger LOG = LoggerFactory.getLogger(Endpoints.class);
    private Map<String, Endpoint> endpoints = new HashMap<String, Endpoint>();

    public Endpoints() {
        this(null);
    }

    public Endpoints(Map<String, Endpoint> endpoints) {
        if (endpoints != null) {
            for (Map.Entry<String, Endpoint> endpoint : endpoints.entrySet()) {
                this.put(endpoint.getKey(), endpoint.getValue());
            }
        }
    }

    public void put(String name, Endpoint endpoint) {
        String key;
        int index = name.lastIndexOf(".");
        if (index++ > 0) {
            key = name.substring(0, index);
            name = name.substring(index);
        } else {
            key = "";
        }
        key = key + Endpoints.getName(endpoint.getClass(), name);
        if (LOG.isDebugEnabled()) {
            LOG.info("Binding [{}] endpoint [{}]", (Object)key, (Object)endpoint);
        }
        if ((endpoint = this.endpoints.put(key, endpoint)) != null) {
            LOG.warn("(!) Discard [{}] endpoint [{}]", (Object)key, (Object)endpoint);
        }
    }

    public Map<String, Endpoint> gets() {
        return Collections.unmodifiableMap(this.endpoints);
    }

    public Endpoint get(String name) {
        return this.endpoints.get(name);
    }

    public static final String getName(Class<? extends Endpoint> clazz) {
        return Endpoints.getName(clazz, "");
    }

    public static final String getName(Class<? extends Endpoint> clazz, String name) {
        return Helpers.getAliasName(clazz, (String)"Endpoint$", (String)Strings.toLower((String)name));
    }
}

