/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.bus;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.isger.brick.bus.Endpoint;
import net.isger.brick.bus.Endpoints;
import net.isger.brick.util.DesignLoader;
import net.isger.util.Asserts;
import net.isger.util.Reflects;
import net.isger.util.reflect.ClassAssembler;
import net.isger.util.reflect.conversion.Conversion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointsConversion
extends DesignLoader
implements Conversion {
    private static final String KEY_NAME = "name";
    private static final Logger LOG = LoggerFactory.getLogger(EndpointsConversion.class);
    private static EndpointsConversion INSTANCE;

    private EndpointsConversion() {
        super(Endpoint.class);
    }

    public static Conversion getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EndpointsConversion();
        }
        return INSTANCE;
    }

    public boolean isSupport(Type type) {
        return Endpoints.class.isAssignableFrom(Reflects.getRawClass((Type)type));
    }

    public Object convert(Type type, Object res, ClassAssembler assembler) {
        HashMap<String, Endpoint> result;
        Object instance = this.load(res, assembler);
        if (instance instanceof List) {
            result = new HashMap<String, Endpoint>();
            for (Map o : (List)instance) {
                result.putAll(o);
            }
        } else {
            result = (HashMap<String, Endpoint>)instance;
        }
        return new Endpoints(result);
    }

    @Override
    protected final Object create(Class<?> clazz, Map<String, Object> res, ClassAssembler assembler) {
        HashMap<String, Endpoint> result = new HashMap<String, Endpoint>();
        for (Map.Entry<String, Object> entry : res.entrySet()) {
            Object resource;
            String name = entry.getKey();
            Object config = entry.getValue();
            if (config instanceof String && (resource = this.console.loadResource((String)config)) != null) {
                config = resource;
            }
            if (!(config instanceof Map)) {
                LOG.debug("Skipped unexpected config [{}]", config);
                continue;
            }
            res = (Map)config;
            res.put(KEY_NAME, name);
            result.put(name, this.createEndpoint(super.getImplementClass(res), res, assembler));
        }
        return result;
    }

    protected Object create(Object res) {
        throw Asserts.argument((String)("Unexpected config " + res), (Object[])new Object[0]);
    }

    protected Endpoint createEndpoint(Class<? extends Endpoint> clazz, Map<String, Object> res, ClassAssembler assembler) {
        return (Endpoint)super.create(clazz, res, assembler);
    }

    public String toString() {
        return Endpoints.class.getName();
    }
}

