/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.bus;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import net.isger.brick.bus.AbstractEndpoint;
import net.isger.brick.bus.protocol.SocketProtocol;
import net.isger.util.Asserts;
import net.isger.util.Strings;
import net.isger.util.anno.Ignore;

@Ignore
public abstract class SocketEndpoint
extends AbstractEndpoint {
    public static final String CHANNEL_UDP = "udp";
    public static final String CHANNEL_TCP = "tcp";
    @Ignore(mode=Ignore.Mode.INCLUDE)
    private String network;
    private NetworkInterface networkInterface;
    @Ignore(mode=Ignore.Mode.INCLUDE)
    private String channel;
    @Ignore(mode=Ignore.Mode.INCLUDE)
    private String host;
    @Ignore(mode=Ignore.Mode.INCLUDE)
    private int port;
    private InetSocketAddress address;

    public SocketEndpoint() {
        this(null, 0);
    }

    public SocketEndpoint(String host, int port) {
        if (Strings.isEmpty((Object)host)) {
            try {
                host = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                host = "localhost";
            }
        }
        this.host = host;
        this.port = port;
    }

    public String getChannel() {
        return this.channel;
    }

    public NetworkInterface getNetworkInterface() {
        return this.networkInterface;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    @Override
    public SocketProtocol getProtocol() {
        return (SocketProtocol)super.getProtocol();
    }

    protected InetSocketAddress newAddress(String host, int port) {
        return new InetSocketAddress(host, port);
    }

    @Override
    protected void open() {
        this.address = this.newAddress(this.host, this.port);
        try {
            this.networkInterface = Strings.isEmpty((Object)this.network) ? NetworkInterface.getByInetAddress(this.address.getAddress()) : NetworkInterface.getByName(this.network);
        }
        catch (SocketException e) {
            throw Asserts.argument((String)"Invalid network interface name [%s]", (Object[])new Object[]{this.network, e});
        }
    }

    @Override
    protected void close() {
    }
}

