/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.bus.protocol;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.isger.brick.bus.protocol.Protocol;
import net.isger.util.Helpers;
import net.isger.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Protocols {
    private static final Logger LOG = LoggerFactory.getLogger(Protocols.class);
    private Map<String, Protocol> protocols = new HashMap<String, Protocol>();

    public Protocols() {
        this(null);
    }

    public Protocols(List<Object> protocols) {
        if (protocols != null) {
            for (Object instance : protocols) {
                if (instance instanceof Protocol) {
                    this.add((Protocol)instance);
                    continue;
                }
                if (!(instance instanceof Map)) continue;
                for (Map.Entry entry : ((Map)instance).entrySet()) {
                    instance = entry.getValue();
                    if (!(instance instanceof Protocol)) continue;
                    this.put((String)entry.getKey(), (Protocol)instance);
                }
            }
        }
    }

    public void add(Protocol protocol) {
        this.put("", protocol);
    }

    public void put(String name, Protocol protocol) {
        String key;
        int index = name.lastIndexOf(".");
        if (index++ > 0) {
            key = name.substring(0, index);
            name = name.substring(index);
        } else {
            key = "";
        }
        key = key + Protocols.getName(protocol.getClass(), name);
        if (LOG.isDebugEnabled()) {
            LOG.info("Binding [{}] protocol [{}]", (Object)key, (Object)protocol);
        }
        if ((protocol = this.protocols.put(key, protocol)) != null) {
            LOG.warn("(!) Discard [{}] protocol [{}]", (Object)key, (Object)protocol);
        }
    }

    public Protocol get(String name) {
        return this.protocols.get(name);
    }

    public Map<String, Protocol> gets() {
        return Collections.unmodifiableMap(this.protocols);
    }

    public static final String getName(Class<? extends Protocol> clazz) {
        return Protocols.getName(clazz, "");
    }

    public static final String getName(Class<? extends Protocol> clazz, String name) {
        return Helpers.getAliasName(clazz, (String)"Protocol$", (String)Strings.toLower((String)name));
    }
}

