/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.bus.protocol;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import net.isger.brick.Constants;
import net.isger.util.Asserts;
import net.isger.util.Decoder;
import net.isger.util.Strings;

public class TextSocketDecoder
implements Decoder {
    private String sourceCharset;
    private String targetCharset;
    private transient byte[] delimiter;

    public TextSocketDecoder() {
        this(Constants.ENC_UTF8, Constants.ENC_UTF8, "\n");
    }

    public TextSocketDecoder(String sourceCharset, String targetCharset, String delimiter) {
        this.sourceCharset = sourceCharset;
        this.targetCharset = targetCharset;
        try {
            this.delimiter = delimiter.getBytes(sourceCharset);
        }
        catch (UnsupportedEncodingException e) {
            throw Asserts.argument((String)"Unsupported encoding [{}]", (Object[])new Object[]{sourceCharset});
        }
    }

    public Object decode(byte[] content) {
        return this.decode(new ByteArrayInputStream(content));
    }

    public Object decode(InputStream is) {
        is.mark(0);
        try {
            byte[] data = new byte[Math.max(is.available(), this.delimiter.length)];
            int size = is.read(data) - this.delimiter.length;
            int i = 0;
            block2: while (i++ < size) {
                int j = 0;
                while (data[i + j] == this.delimiter[j]) {
                    if (++j < this.delimiter.length) continue;
                    is.reset();
                    is.skip(i + j);
                    String value = new String(data, 0, i, this.sourceCharset).trim();
                    if (value.length() == 0 || value.equals(new String(this.delimiter, this.targetCharset))) {
                        is.mark(0);
                        continue block2;
                    }
                    return Strings.toCharset((byte[])value.getBytes(this.sourceCharset), (String)this.sourceCharset, (String)this.targetCharset);
                }
            }
            is.reset();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return null;
    }

    public String getSourceCharset() {
        return this.sourceCharset;
    }

    public String getTargetCharset() {
        return this.targetCharset;
    }

    public String getEncoding() {
        return this.getTargetCharset();
    }

    public byte[] getDelimiter() {
        return this.delimiter;
    }
}

